/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.lib.aura.AuraChunk;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.events.ServerTickEventsFML;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketSealToClient;
import thaumcraft.common.lib.world.ChunkLoc;

public class ChunkEvents {
    @SubscribeEvent
    public void chunkSave(ChunkDataEvent.Save event) {
        int dim = event.world.field_73011_w.func_177502_q();
        ChunkCoordIntPair loc = event.getChunk().func_76632_l();
        NBTTagCompound nbt = new NBTTagCompound();
        event.getData().func_74782_a("Thaumcraft", (NBTBase)nbt);
        nbt.func_74757_a(Config.regenKey, true);
        AuraChunk ac = AuraHandler.getAuraChunk(dim, loc.field_77276_a, loc.field_77275_b);
        if (ac != null) {
            nbt.func_74777_a("base", ac.getBase());
            ac.getCurrentAspects().writeToNBT(nbt, "current");
            if (!event.getChunk().func_177410_o()) {
                AuraHandler.removeAuraChunk(dim, loc.field_77276_a, loc.field_77275_b);
            }
        }
        NBTTagList tagList = new NBTTagList();
        for (SealEntity seal : SealHandler.getSealsInChunk(event.world, loc)) {
            NBTTagCompound sealnbt = seal.writeNBT();
            tagList.func_74742_a((NBTBase)sealnbt);
            if (event.getChunk().func_177410_o()) continue;
            SealHandler.removeSealEntity(event.world, seal.getSealPos(), true);
        }
        nbt.func_74782_a("seals", (NBTBase)tagList);
    }

    @SubscribeEvent
    public void chunkLoad(ChunkDataEvent.Load event) {
        NBTTagCompound nbt;
        int dim = event.world.field_73011_w.func_177502_q();
        ChunkCoordIntPair loc = event.getChunk().func_76632_l();
        if (event.getData().func_74775_l("Thaumcraft").func_74764_b("base")) {
            nbt = event.getData().func_74775_l("Thaumcraft");
            short base = nbt.func_74765_d("base");
            AspectList current = new AspectList();
            current.readFromNBT(nbt, "current");
            AuraHandler.addAuraChunk(dim, event.getChunk(), base, current);
        } else {
            AuraHandler.generateAura(event.getChunk(), event.world.field_73012_v);
        }
        if (event.getData().func_74775_l("Thaumcraft").func_74764_b("seals")) {
            nbt = event.getData().func_74775_l("Thaumcraft");
            NBTTagList tagList = nbt.func_150295_c("seals", 10);
            for (int a = 0; a < tagList.func_74745_c(); ++a) {
                NBTTagCompound tasknbt = tagList.func_150305_b(a);
                SealEntity seal = new SealEntity(event.world);
                seal.readNBT(tasknbt);
                SealHandler.addSealEntity(event.world, seal);
            }
        }
        if (!event.getData().func_74775_l("Thaumcraft").func_74764_b(Config.regenKey) && (Config.regenAmber || Config.regenAura || Config.regenCinnibar || Config.regenCrystals || Config.regenStructure || Config.regenTrees)) {
            Thaumcraft.log.warn("World gen was never run for chunk at " + event.getChunk().func_76632_l() + ". Adding to queue for regeneration.");
            ArrayList<ChunkLoc> chunks = ServerTickEventsFML.chunksToGenerate.get(dim);
            if (chunks == null) {
                ServerTickEventsFML.chunksToGenerate.put(dim, new ArrayList());
                chunks = ServerTickEventsFML.chunksToGenerate.get(dim);
            }
            if (chunks != null) {
                chunks.add(new ChunkLoc(loc.field_77276_a, loc.field_77275_b));
                ServerTickEventsFML.chunksToGenerate.put(dim, chunks);
            }
        }
    }

    @SubscribeEvent
    public void chunkWatch(ChunkWatchEvent.Watch event) {
        for (SealEntity seal : SealHandler.getSealsInChunk(event.player.field_70170_p, event.chunk)) {
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketSealToClient(seal), event.player);
        }
    }
}

