/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.internal.WorldCoordinates;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXEssentiaSource;
import thaumcraft.common.tiles.devices.TileMirrorEssentia;

public class EssentiaHandler {
    static final int DELAY = 5000;
    private static HashMap<WorldCoordinates, ArrayList<WorldCoordinates>> sources = new HashMap();
    private static HashMap<WorldCoordinates, Long> sourcesDelay = new HashMap();
    public static HashMap<String, EssentiaSourceFX> sourceFX = new HashMap();

    public static boolean drainEssentia(TileEntity tile, Aspect aspect, EnumFacing direction, int range) {
        return EssentiaHandler.drainEssentia(tile, aspect, direction, range, false);
    }

    public static boolean drainEssentia(TileEntity tile, Aspect aspect, EnumFacing direction, int range, boolean ignoreMirror) {
        WorldCoordinates tileLoc = new WorldCoordinates(tile.func_174877_v(), tile.func_145831_w().field_73011_w.func_177502_q());
        if (!sources.containsKey(tileLoc)) {
            EssentiaHandler.getSources(tile.func_145831_w(), tileLoc, direction, range);
            if (sources.containsKey(tileLoc)) {
                return EssentiaHandler.drainEssentia(tile, aspect, direction, range);
            }
            return false;
        }
        ArrayList<WorldCoordinates> es = sources.get(tileLoc);
        for (WorldCoordinates source : es) {
            IAspectSource as;
            TileEntity sourceTile = tile.func_145831_w().func_175625_s(source.pos);
            if (sourceTile == null || !(sourceTile instanceof IAspectSource)) break;
            if (ignoreMirror && sourceTile instanceof TileMirrorEssentia || !(as = (IAspectSource)sourceTile).takeFromContainer(aspect, 1)) continue;
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXEssentiaSource(tile.func_174877_v(), (byte)(tile.func_174877_v().func_177958_n() - source.pos.func_177958_n()), (byte)(tile.func_174877_v().func_177956_o() - source.pos.func_177956_o()), (byte)(tile.func_174877_v().func_177952_p() - source.pos.func_177952_p()), aspect.getColor()), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.func_177502_q(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), 32.0));
            return true;
        }
        sources.remove(tileLoc);
        sourcesDelay.put(tileLoc, System.currentTimeMillis() + 5000L);
        return false;
    }

    public static boolean findEssentia(TileEntity tile, Aspect aspect, EnumFacing direction, int range) {
        WorldCoordinates tileLoc = new WorldCoordinates(tile.func_174877_v(), tile.func_145831_w().field_73011_w.func_177502_q());
        if (!sources.containsKey(tileLoc)) {
            EssentiaHandler.getSources(tile.func_145831_w(), tileLoc, direction, range);
            if (sources.containsKey(tileLoc)) {
                return EssentiaHandler.findEssentia(tile, aspect, direction, range);
            }
            return false;
        }
        ArrayList<WorldCoordinates> es = sources.get(tileLoc);
        for (WorldCoordinates source : es) {
            TileEntity sourceTile = tile.func_145831_w().func_175625_s(source.pos);
            if (sourceTile == null || !(sourceTile instanceof IAspectSource)) break;
            IAspectSource as = (IAspectSource)sourceTile;
            if (!as.doesContainerContainAmount(aspect, 1)) continue;
            return true;
        }
        sources.remove(tileLoc);
        sourcesDelay.put(tileLoc, System.currentTimeMillis() + 5000L);
        return false;
    }

    private static void getSources(World world, WorldCoordinates tileLoc, EnumFacing direction, int range) {
        if (sourcesDelay.containsKey(tileLoc)) {
            long d = sourcesDelay.get(tileLoc);
            if (d <= System.currentTimeMillis()) {
                sourcesDelay.remove(tileLoc);
            } else {
                return;
            }
        }
        TileEntity sourceTile = world.func_175625_s(tileLoc.pos);
        ArrayList<WorldCoordinates> sourceList = new ArrayList<WorldCoordinates>();
        int start = 0;
        if (direction == null) {
            start = -range;
            direction = EnumFacing.UP;
        }
        int xx = 0;
        int yy = 0;
        int zz = 0;
        for (int aa = -range; aa <= range; ++aa) {
            for (int bb = -range; bb <= range; ++bb) {
                for (int cc = start; cc < range; ++cc) {
                    if (aa == 0 && bb == 0 && cc == 0) continue;
                    xx = tileLoc.pos.func_177958_n();
                    yy = tileLoc.pos.func_177956_o();
                    zz = tileLoc.pos.func_177952_p();
                    if (direction.func_96559_d() != 0) {
                        xx += aa;
                        yy += cc * direction.func_96559_d();
                        zz += bb;
                    } else if (direction.func_82601_c() == 0) {
                        xx += aa;
                        yy += bb;
                        zz += cc * direction.func_82599_e();
                    } else {
                        xx += cc * direction.func_82601_c();
                        yy += aa;
                        zz += bb;
                    }
                    TileEntity te = world.func_175625_s(new BlockPos(xx, yy, zz));
                    if (te == null || !(te instanceof IAspectSource) || sourceTile instanceof TileMirrorEssentia && te instanceof TileMirrorEssentia && sourceTile.func_174877_v().func_177958_n() == ((TileMirrorEssentia)te).linkX && sourceTile.func_174877_v().func_177956_o() == ((TileMirrorEssentia)te).linkY && sourceTile.func_174877_v().func_177952_p() == ((TileMirrorEssentia)te).linkZ && sourceTile.func_145831_w().field_73011_w.func_177502_q() == ((TileMirrorEssentia)te).linkDim) continue;
                    sourceList.add(new WorldCoordinates(new BlockPos(xx, yy, zz), world.field_73011_w.func_177502_q()));
                }
            }
        }
        if (sourceList.size() > 0) {
            sources.put(tileLoc, sourceList);
        } else {
            sourcesDelay.put(tileLoc, System.currentTimeMillis() + 5000L);
        }
    }

    public static void refreshSources(TileEntity tile) {
        sources.remove(new WorldCoordinates(tile.func_174877_v(), tile.func_145831_w().field_73011_w.func_177502_q()));
    }

    public static class EssentiaSourceFX {
        public BlockPos start;
        public BlockPos end;
        public int ticks;
        public int color;

        public EssentiaSourceFX(BlockPos start, BlockPos end, int ticks, int color) {
            this.start = start;
            this.end = end;
            this.ticks = ticks;
            this.color = color;
        }
    }
}

