/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.EntityFollowingItem;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.Utils;

public class BlockUtils {
    static BlockPos lastPos = BlockPos.field_177992_a;
    static int lasty = 0;
    static int lastz = 0;
    static double lastdistance = 0.0;
    public static ArrayList<String> portableHoleBlackList = new ArrayList();

    public static boolean harvestBlock(World world, EntityPlayer player, BlockPos pos) {
        return BlockUtils.harvestBlock(world, player, pos, false, 0);
    }

    public static boolean harvestBlock(World world, EntityPlayer player, BlockPos pos, boolean followItem, int color) {
        IBlockState bs = world.func_180495_p(pos);
        if (bs.func_177230_c().func_176195_g(world, pos) < 0.0f) {
            return false;
        }
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)bs));
        boolean flag = false;
        if (player.field_71075_bZ.field_75098_d) {
            flag = BlockUtils.removeBlock(world, pos, player, false);
        } else {
            boolean flag1 = false;
            if (bs != null) {
                flag1 = bs.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, player);
            }
            if ((flag = BlockUtils.removeBlock(world, pos, player, true)) && flag1) {
                ArrayList<Entity> entities;
                bs.func_177230_c().func_180657_a(world, player, pos, bs, world.func_175625_s(pos));
                if (followItem && (entities = EntityUtils.getEntitiesInRange(world, pos, (Entity)player, EntityItem.class, 2.0)) != null && entities.size() > 0) {
                    for (Entity e : entities) {
                        if (e.field_70128_L || !(e instanceof EntityItem) || e.field_70173_aa != 0 || e instanceof EntityFollowingItem) continue;
                        EntityFollowingItem fi = new EntityFollowingItem(world, e.field_70165_t, e.field_70163_u, e.field_70161_v, ((EntityItem)e).func_92059_d().func_77946_l(), (Entity)player, color);
                        fi.field_70159_w = e.field_70159_w;
                        fi.field_70181_x = e.field_70181_x;
                        fi.field_70179_y = e.field_70179_y;
                        world.func_72838_d((Entity)fi);
                        e.func_70106_y();
                    }
                }
            }
        }
        return true;
    }

    public static ItemStack createStackedBlock(IBlockState bs) {
        ItemStack dropped = null;
        try {
            Method m = ReflectionHelper.findMethod(Block.class, (Object)bs.func_177230_c(), (String[])new String[]{"createStackedBlock", "func_180643_i", "i"}, (Class[])new Class[]{IBlockState.class});
            dropped = (ItemStack)m.invoke((Object)bs.func_177230_c(), bs);
        }
        catch (Exception e) {
            Thaumcraft.log.warn("Could not invoke net.minecraft.block.Block method createStackedBlock");
        }
        return dropped;
    }

    public static boolean removeBlock(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        boolean flag;
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != null) {
            block.func_176208_a(world, pos, world.func_180495_p(pos), player);
        }
        boolean bl = flag = block != null && block.removedByPlayer(world, pos, player, willHarvest);
        if (block != null && flag) {
            block.func_176206_d(world, pos, world.func_180495_p(pos));
        }
        return flag;
    }

    public static void findBlocks(World world, BlockPos pos, Block block) {
        boolean count = false;
        for (int xx = -2; xx <= 2; ++xx) {
            for (int yy = 2; yy >= -2; --yy) {
                for (int zz = -2; zz <= 2; ++zz) {
                    double zd;
                    double yd;
                    double xd;
                    double d;
                    if (Math.abs(lastPos.func_177958_n() + xx - pos.func_177958_n()) > 24) {
                        return;
                    }
                    if (Math.abs(lastPos.func_177956_o() + yy - pos.func_177956_o()) > 48) {
                        return;
                    }
                    if (Math.abs(lastPos.func_177952_p() + zz - pos.func_177952_p()) > 24) {
                        return;
                    }
                    if (world.func_180495_p(lastPos).func_177230_c() != block || !Utils.isWoodLog((IBlockAccess)world, lastPos.func_177982_a(xx, yy, zz)) || !(block.func_176195_g(world, lastPos.func_177982_a(xx, yy, zz)) >= 0.0f) || !((d = (xd = (double)(lastPos.func_177958_n() + xx - pos.func_177958_n())) * xd + (yd = (double)(lastPos.func_177956_o() + yy - pos.func_177956_o())) * yd + (zd = (double)(lastPos.func_177952_p() + zz - pos.func_177952_p())) * zd) > lastdistance)) continue;
                    lastdistance = d;
                    lastPos = lastPos.func_177982_a(xx, yy, zz);
                    BlockUtils.findBlocks(world, pos, block);
                    return;
                }
            }
        }
    }

    public static boolean breakFurthestBlock(World world, BlockPos pos, Block block, EntityPlayer player) {
        return BlockUtils.breakFurthestBlock(world, pos, block, player, false, 0);
    }

    public static boolean breakFurthestBlock(World world, BlockPos pos, Block block, EntityPlayer player, boolean followitem, int color) {
        lastPos = new BlockPos((Vec3i)pos);
        lastdistance = 0.0;
        BlockUtils.findBlocks(world, pos, block);
        boolean worked = BlockUtils.harvestBlock(world, player, lastPos, followitem, color);
        world.func_175689_h(pos);
        if (worked) {
            world.func_175689_h(lastPos);
            for (int xx = -3; xx <= 3; ++xx) {
                for (int yy = -3; yy <= 3; ++yy) {
                    for (int zz = -3; zz <= 3; ++zz) {
                        world.func_175684_a(lastPos.func_177982_a(xx, yy, zz), world.func_180495_p(lastPos.func_177982_a(xx, yy, zz)).func_177230_c(), 150 + world.field_73012_v.nextInt(150));
                    }
                }
            }
        }
        return worked;
    }

    public static MovingObjectPosition getTargetBlock(World world, Entity entity, boolean par3) {
        return BlockUtils.getTargetBlock(world, entity, par3, 10.0);
    }

    public static MovingObjectPosition getTargetBlock(World world, Entity entity, boolean par3, double range) {
        float var4 = 1.0f;
        float var5 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * var4;
        float var6 = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * var4;
        double var7 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)var4;
        double var9 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)var4 + (double)entity.func_70047_e();
        double var11 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)var4;
        Vec3 var13 = new Vec3(var7, var9, var11);
        float var14 = MathHelper.func_76134_b((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = MathHelper.func_76126_a((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var16 = -MathHelper.func_76134_b((float)(-var5 * ((float)Math.PI / 180)));
        float var17 = MathHelper.func_76126_a((float)(-var5 * ((float)Math.PI / 180)));
        float var18 = var15 * var16;
        float var20 = var14 * var16;
        Vec3 var23 = var13.func_72441_c((double)var18 * range, (double)var17 * range, (double)var20 * range);
        return world.func_147447_a(var13, var23, par3, !par3, false);
    }

    public static int countExposedSides(World world, BlockPos pos) {
        int count = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!world.func_175623_d(pos.func_177972_a(dir))) continue;
            ++count;
        }
        return count;
    }

    public static boolean isBlockExposed(World world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.values()) {
            if (world.func_180495_p(pos.func_177972_a(face)).func_177230_c().func_149662_c()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdjacentToSolidBlock(World world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.values()) {
            if (!world.isSideSolid(pos.func_177972_a(face), face.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockTouching(IBlockAccess world, BlockPos pos, IBlockState bs) {
        for (EnumFacing face : EnumFacing.values()) {
            if (world.func_180495_p(pos.func_177972_a(face)) != bs) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockTouching(IBlockAccess world, BlockPos pos, Block bs) {
        for (EnumFacing face : EnumFacing.values()) {
            if (world.func_180495_p(pos.func_177972_a(face)).func_177230_c() != bs) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockTouching(IBlockAccess world, BlockPos pos, Material mat, boolean solid) {
        for (EnumFacing face : EnumFacing.values()) {
            if (world.func_180495_p(pos.func_177972_a(face)).func_177230_c().func_149688_o() != mat || solid && !world.func_180495_p(pos.func_177972_a(face)).func_177230_c().isSideSolid(world, pos.func_177972_a(face), face.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    public static EnumFacing getFaceBlockTouching(IBlockAccess world, BlockPos pos, Block bs) {
        for (EnumFacing face : EnumFacing.values()) {
            if (world.func_180495_p(pos.func_177972_a(face)).func_177230_c() != bs) continue;
            return face;
        }
        return null;
    }

    public static boolean isPortableHoleBlackListed(IBlockState blockstate) {
        return BlockUtils.isBlockListed(blockstate, portableHoleBlackList);
    }

    public static boolean isBlockListed(IBlockState blockstate, List<String> list) {
        String stateString = blockstate.toString();
        for (String key : list) {
            String[] splitString = key.split(";");
            if (splitString[0].contains(":")) {
                if (!Block.field_149771_c.func_177774_c((Object)blockstate.func_177230_c()).toString().equals(splitString[0])) continue;
                if (splitString.length > 1) {
                    int matches = 0;
                    for (int a = 1; a < splitString.length; ++a) {
                        if (!stateString.contains(splitString[a])) continue;
                        ++matches;
                    }
                    if (matches != splitString.length - 1) continue;
                    return true;
                }
                return true;
            }
            ItemStack bs = new ItemStack(Item.func_150898_a((Block)blockstate.func_177230_c()), 1, blockstate.func_177230_c().func_176201_c(blockstate));
            for (ItemStack stack : OreDictionary.getOres((String)splitString[0])) {
                if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)bs, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static double distance(BlockPos b1, BlockPos b2) {
        double d3 = b1.func_177958_n() - b2.func_177958_n();
        double d4 = b1.func_177956_o() - b2.func_177956_o();
        double d5 = b1.func_177952_p() - b2.func_177952_p();
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public static EnumFacing.Axis getBlockAxis(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals("axis")) continue;
            if (state.func_177229_b(prop) instanceof BlockLog.EnumAxis) {
                return (BlockLog.EnumAxis)state.func_177229_b(prop) == BlockLog.EnumAxis.X ? EnumFacing.Axis.X : ((BlockLog.EnumAxis)state.func_177229_b(prop) == BlockLog.EnumAxis.Y ? EnumFacing.Axis.Y : ((BlockLog.EnumAxis)state.func_177229_b(prop) == BlockLog.EnumAxis.Z ? EnumFacing.Axis.Z : null));
            }
            if (!(state.func_177229_b(prop) instanceof EnumFacing.Axis)) continue;
            return (EnumFacing.Axis)state.func_177229_b(prop);
        }
        return EnumFacing.Axis.Y;
    }

    public static boolean hasLOS(World world, BlockPos source, BlockPos target) {
        MovingObjectPosition mop = ThaumcraftApiHelper.rayTraceIgnoringSource(world, new Vec3((double)source.func_177958_n() + 0.5, (double)source.func_177956_o() + 0.5, (double)source.func_177952_p() + 0.5), new Vec3((double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 0.5, (double)target.func_177952_p() + 0.5), false, true, false);
        return mop == null || mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mop.func_178782_a().func_177958_n() == target.func_177958_n() && mop.func_178782_a().func_177956_o() == target.func_177956_o() && mop.func_178782_a().func_177952_p() == target.func_177952_p();
    }
}

