/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.world;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.monster.cult.EntityCultistPortalLesser;
import thaumcraft.common.items.resources.ItemShard;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.aura.EntityAuraNode;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.world.biomes.BiomeHandler;
import thaumcraft.common.lib.world.dim.MazeHandler;
import thaumcraft.common.lib.world.dim.MazeThread;
import thaumcraft.common.lib.world.objects.WorldGenCustomFlowers;
import thaumcraft.common.lib.world.objects.WorldGenEldritchRing;
import thaumcraft.common.lib.world.objects.WorldGenGreatwoodTrees;
import thaumcraft.common.lib.world.objects.WorldGenMound;
import thaumcraft.common.lib.world.objects.WorldGenSilverwoodTrees;

public class ThaumcraftWorldGenerator
implements IWorldGenerator {
    HashMap<BlockPos, Boolean> structureNode = new HashMap();

    public void initialize() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(BiomeHandler.biomeMagicalForest, Config.biomeMagicalForestWeight));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(BiomeHandler.biomeMagicalForest, Config.biomeMagicalForestWeight));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.worldGeneration(random, chunkX, chunkZ, world, true);
        AuraHandler.generateAura(chunkProvider.func_73154_d(chunkX, chunkZ), random);
    }

    public void worldGeneration(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        if (world.field_73011_w.func_177502_q() == Config.dimensionOuterId) {
            MazeHandler.generateEldritch(world, random, chunkX, chunkZ);
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        } else {
            this.generateAll(world, random, chunkX, chunkZ, newGen);
            if (world.field_73011_w.func_177502_q() == -1) {
                this.generateNether(world, random, chunkX, chunkZ, newGen);
            } else if (world.field_73011_w.func_177502_q() == Config.overworldDim) {
                this.generateSurface(world, random, chunkX, chunkZ, newGen);
            }
            if (!newGen) {
                world.func_72964_e(chunkX, chunkZ).func_76630_e();
            }
        }
    }

    private void generateSurface(World world, Random random, int chunkX, int chunkZ, boolean newGen) {
        int randPosZ;
        int randPosX;
        BlockPos p;
        boolean auraGen = false;
        int blacklist = BiomeHandler.getDimBlacklist(world.field_73011_w.func_177502_q());
        if (blacklist == -1 && Config.genStructure && world.field_73011_w.func_177502_q() == Config.overworldDim && !world.func_72912_H().func_76067_t().func_77127_a().startsWith("flat") && (newGen || Config.regenStructure) && (p = world.func_175725_q(new BlockPos(randPosX = chunkX * 16 + random.nextInt(16), 0, randPosZ = chunkZ * 16 + random.nextInt(16))).func_177979_c(9)).func_177956_o() < world.func_72940_L()) {
            BlockPos p2;
            IBlockState bs;
            if (random.nextInt(150) == 0) {
                WorldGenMound mound = new WorldGenMound();
                if (mound.func_180709_b(world, random, p)) {
                    auraGen = true;
                    ThaumcraftWorldGenerator.spawnNode(world, p.func_177982_a(9, 8, 9), 1, 1.5f);
                }
            } else if (random.nextInt(66) == 0) {
                WorldGenEldritchRing stonering = new WorldGenEldritchRing();
                BlockPos p22 = p.func_177981_b(8);
                int w = 8 + random.nextInt(5) * 2;
                int h = 8 + random.nextInt(5) * 2;
                stonering.chunkX = chunkX;
                stonering.chunkZ = chunkZ;
                stonering.width = w;
                stonering.height = h;
                if (stonering.func_180709_b(world, random, p22)) {
                    world.func_175656_a(p22.func_177981_b(2), BlocksTC.eldritch.func_176203_a(6));
                    Thread t = new Thread(new MazeThread(chunkX, chunkZ, w, h, random.nextLong()));
                    t.start();
                }
            } else if (random.nextInt(500) == 0 && ((bs = world.func_180495_p(p2 = p.func_177981_b(8))).func_177230_c().func_149688_o() == Material.field_151578_c || bs.func_177230_c().func_149688_o() == Material.field_151576_e || bs.func_177230_c().func_149688_o() == Material.field_151595_p || bs.func_177230_c().func_149688_o() == Material.field_151597_y)) {
                EntityCultistPortalLesser eg = new EntityCultistPortalLesser(world);
                eg.func_70107_b((double)p2.func_177958_n() + 0.5, p2.func_177956_o() + 1, (double)p2.func_177952_p() + 0.5);
                eg.func_180482_a(world.func_175649_E(new BlockPos((Entity)eg)), null);
                world.func_72838_d((Entity)eg);
            }
        }
    }

    private void generateNodes(World world, Random random, int chunkX, int chunkZ, boolean newGen, int blacklist) {
        if (blacklist != 0 && blacklist != 2 && Config.genAura && (newGen || Config.regenAura)) {
            BlockPos var7 = new MapGenScatteredFeature().func_180706_b(world, world.func_175645_m(new BlockPos(chunkX * 16 + 8, 64, chunkZ * 16 + 8)));
            if (var7 != null && !this.structureNode.containsKey(var7)) {
                this.structureNode.put(var7, true);
                BlockPos bp = var7.func_177981_b(3);
                ThaumcraftWorldGenerator.spawnNode(world, bp, -1, 1.0f);
            } else {
                int z;
                int x = chunkX * 16 + random.nextInt(16);
                int h = world.func_175645_m(new BlockPos(x, 64, z = chunkZ * 16 + random.nextInt(16))).func_177956_o();
                if (h < world.func_72940_L() / 3) {
                    h = world.func_72940_L() / 3;
                }
                int y = 8 + random.nextInt(h);
                BlockPos bp = new BlockPos(x, y, z);
                while (!world.func_175623_d(bp)) {
                    if (world.func_180495_p(bp = bp.func_177981_b(2)).func_177230_c() != Blocks.field_150357_h && bp.func_177956_o() < world.func_72940_L()) continue;
                    return;
                }
                if (world.func_175623_d(bp) && random.nextInt(Math.max(2, Config.nodeRarity)) == 0) {
                    ThaumcraftWorldGenerator.spawnNode(world, bp, -1, 1.0f);
                }
            }
        }
    }

    public static void spawnNode(World world, BlockPos bp, int type, float sizemod) {
        EntityAuraNode e = new EntityAuraNode(world);
        e.func_70012_b((double)bp.func_177958_n() + 0.5, (double)bp.func_177956_o() + 0.5, (double)bp.func_177952_p() + 0.5, 0.0f, 0.0f);
        world.func_72838_d((Entity)e);
        e.randomizeNode();
        if (type >= 0) {
            e.setNodeType(type);
        }
        e.setNodeSize((int)((float)e.getNodeSize() * sizemod));
        if (e.getNodeType() == 4) {
            AuraHelper.pollute(world, bp, Config.AURABASE, false);
            for (int a = 0; a < 16; ++a) {
                BlockPos tt = bp.func_177982_a(world.field_73012_v.nextInt(16) - world.field_73012_v.nextInt(16), world.field_73012_v.nextInt(16) - world.field_73012_v.nextInt(16), world.field_73012_v.nextInt(16) - world.field_73012_v.nextInt(16));
                IBlockState ts = world.func_180495_p(tt);
                if (!world.func_175623_d(tt) && !ts.func_177230_c().func_176200_f(world, tt) || !BlockUtils.isAdjacentToSolidBlock(world, tt)) continue;
                world.func_175656_a(tt, BlocksTC.taintFibre.func_176223_P());
            }
        }
    }

    private void generateVegetation(World world, Random random, int chunkX, int chunkZ, boolean newGen) {
        BiomeGenBase bgb = world.func_180494_b(new BlockPos(chunkX * 16 + 8, 50, chunkZ * 16 + 8));
        if (BiomeHandler.getBiomeBlacklist(bgb.field_76756_M) != -1) {
            return;
        }
        if (random.nextInt(60) == 3) {
            ThaumcraftWorldGenerator.generateSilverwood(world, random, chunkX, chunkZ);
        }
        if (random.nextInt(25) == 7) {
            ThaumcraftWorldGenerator.generateGreatwood(world, random, chunkX, chunkZ);
        }
        int randPosX = chunkX * 16 + random.nextInt(16);
        int randPosZ = chunkZ * 16 + random.nextInt(16);
        BlockPos bp = world.func_175645_m(new BlockPos(randPosX, 0, randPosZ));
        if (world.func_180494_b((BlockPos)bp).field_76752_A == Blocks.field_150354_m.func_176223_P() && world.func_180494_b((BlockPos)bp).field_76750_F > 1.0f && random.nextInt(30) == 0) {
            ThaumcraftWorldGenerator.generateFlowers(world, random, bp, BlocksTC.cinderpearl, 0);
        }
    }

    private void generateOres(World world, Random random, int chunkX, int chunkZ, boolean newGen) {
        IBlockState block;
        int randPosX;
        int i;
        BiomeGenBase bgb = world.func_180494_b(new BlockPos(chunkX * 16 + 8, 50, chunkZ * 16 + 8));
        if (BiomeHandler.getBiomeBlacklist(bgb.field_76756_M) == 0 || BiomeHandler.getBiomeBlacklist(bgb.field_76756_M) == 2) {
            return;
        }
        float density = (float)Config.oreDensity / 100.0f;
        if (world.field_73011_w.func_177502_q() == -1) {
            return;
        }
        if (Config.genCinnibar && (newGen || Config.regenCinnibar)) {
            for (i = 0; i < Math.round(18.0f * density); ++i) {
                int randPosZ;
                int randPosY;
                randPosX = chunkX * 16 + random.nextInt(16);
                block = world.func_180495_p(new BlockPos(randPosX, randPosY = random.nextInt(world.func_72800_K() / 5), randPosZ = chunkZ * 16 + random.nextInt(16)));
                if (block != Blocks.field_150348_b.func_176223_P()) continue;
                world.func_180501_a(new BlockPos(randPosX, randPosY, randPosZ), BlocksTC.oreCinnabar.func_176223_P(), 0);
            }
        }
        if (Config.genAmber && (newGen || Config.regenAmber)) {
            for (i = 0; i < Math.round(20.0f * density); ++i) {
                int randPosZ;
                int randPosY;
                randPosX = chunkX * 16 + random.nextInt(16);
                block = world.func_180495_p(new BlockPos(randPosX, randPosY = world.func_175645_m(new BlockPos(randPosX, 0, randPosZ = chunkZ * 16 + random.nextInt(16))).func_177956_o() - random.nextInt(25), randPosZ));
                if (block != Blocks.field_150348_b.func_176223_P()) continue;
                world.func_180501_a(new BlockPos(randPosX, randPosY, randPosZ), BlocksTC.oreAmber.func_176223_P(), 0);
            }
        }
        if (Config.genCrystals && (newGen || Config.regenCrystals)) {
            int t = 8;
            int maxCrystals = Math.round(64.0f * density);
            int cc = 0;
            if (world.field_73011_w.func_177502_q() == -1) {
                t = 1;
            }
            for (int i2 = 0; i2 < Math.round((float)t * density); ++i2) {
                int randPosX2 = chunkX * 16 + random.nextInt(16);
                int randPosZ = chunkZ * 16 + random.nextInt(16);
                int randPosY = random.nextInt(Math.max(5, world.func_175645_m(new BlockPos(randPosX2, 0, randPosZ)).func_177956_o() - 5));
                BlockPos bp = new BlockPos(randPosX2, randPosY, randPosZ);
                int md = random.nextInt(6);
                if (random.nextInt(3) == 0) {
                    Aspect tag = BiomeHandler.getRandomBiomeTag(world.func_180494_b((BlockPos)bp).field_76756_M, random);
                    md = tag == null ? random.nextInt(6) : ItemShard.ShardType.getMetaByAspect(tag);
                }
                Block oreBlock = ItemShard.ShardType.byMetadata(md).getOre();
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int yy = -1; yy <= 1; ++yy) {
                        for (int zz = -1; zz <= 1; ++zz) {
                            IBlockState bs;
                            Material bm;
                            if (random.nextInt(3) == 0 || (bm = (bs = world.func_180495_p(bp.func_177982_a(xx, yy, zz))).func_177230_c().func_149688_o()).func_76224_d() || !world.func_175623_d(bp.func_177982_a(xx, yy, zz)) && !bs.func_177230_c().func_176200_f(world, bp.func_177982_a(xx, yy, zz)) || !BlockUtils.isBlockTouching((IBlockAccess)world, bp.func_177982_a(xx, yy, zz), Material.field_151576_e, true)) continue;
                            int amt = 1 + random.nextInt(3);
                            world.func_180501_a(bp.func_177982_a(xx, yy, zz), oreBlock.func_176203_a(amt), 0);
                            cc += amt;
                        }
                    }
                }
                if (cc > maxCrystals) break;
            }
        }
    }

    private void generateAll(World world, Random random, int chunkX, int chunkZ, boolean newGen) {
        boolean auraGen = false;
        int blacklist = BiomeHandler.getDimBlacklist(world.field_73011_w.func_177502_q());
        if (blacklist == -1 && Config.genTrees && !world.func_72912_H().func_76067_t().func_77127_a().startsWith("flat") && (newGen || Config.regenTrees)) {
            this.generateVegetation(world, random, chunkX, chunkZ, newGen);
        }
        if (blacklist != 0 && blacklist != 2) {
            this.generateOres(world, random, chunkX, chunkZ, newGen);
        }
        if (!auraGen) {
            this.generateNodes(world, random, chunkX, chunkZ, newGen, blacklist);
        }
    }

    private void generateNether(World world, Random random, int chunkX, int chunkZ, boolean newGen) {
        boolean auraGen = false;
    }

    public static boolean generateFlowers(World world, Random random, BlockPos pos, Block block, int md) {
        WorldGenCustomFlowers flowers = new WorldGenCustomFlowers(block, md);
        return flowers.func_180709_b(world, random, pos);
    }

    public static boolean generateGreatwood(World world, Random random, int chunkX, int chunkZ) {
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        BlockPos bp = world.func_175725_q(new BlockPos(x, 0, z));
        int bio = world.func_180494_b((BlockPos)bp).field_76756_M;
        if (BiomeHandler.getBiomeSupportsGreatwood(bio) > random.nextFloat()) {
            boolean t = new WorldGenGreatwoodTrees(false, random.nextInt(8) == 0).func_180709_b(world, random, bp);
            return t;
        }
        return false;
    }

    public static boolean generateSilverwood(World world, Random random, int chunkX, int chunkZ) {
        int z;
        int x = chunkX * 16 + random.nextInt(16);
        BlockPos bp = world.func_175725_q(new BlockPos(x, 0, z = chunkZ * 16 + random.nextInt(16)));
        BiomeGenBase bio = world.func_180494_b(bp);
        if (!bio.equals(BiomeHandler.biomeMagicalForest) && (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || bio.field_76756_M == BiomeGenBase.field_76785_t.field_76756_M || bio.field_76756_M == BiomeGenBase.field_150582_Q.field_76756_M)) {
            boolean t = new WorldGenSilverwoodTrees(false, 7, 4).func_180709_b(world, random, bp);
            return t;
        }
        return false;
    }
}

