/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.devices;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.TileThaumcraft;
import thaumcraft.common.lib.events.EssentiaHandler;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.lib.utils.Utils;

public class TileMirrorEssentia
extends TileThaumcraft
implements IAspectSource,
IUpdatePlayerListBox {
    public boolean linked = false;
    public int linkX;
    public int linkY;
    public int linkZ;
    public int linkDim;
    public EnumFacing linkedFacing = EnumFacing.DOWN;
    public int instability;
    int count = 0;
    int inc = 40;

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.linked = nbttagcompound.func_74767_n("linked");
        this.linkX = nbttagcompound.func_74762_e("linkX");
        this.linkY = nbttagcompound.func_74762_e("linkY");
        this.linkZ = nbttagcompound.func_74762_e("linkZ");
        this.linkDim = nbttagcompound.func_74762_e("linkDim");
        this.instability = nbttagcompound.func_74762_e("instability");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("linked", this.linked);
        nbttagcompound.func_74768_a("linkX", this.linkX);
        nbttagcompound.func_74768_a("linkY", this.linkY);
        nbttagcompound.func_74768_a("linkZ", this.linkZ);
        nbttagcompound.func_74768_a("linkDim", this.linkDim);
        nbttagcompound.func_74768_a("instability", this.instability);
    }

    protected void addInstability(World targetWorld, int amt) {
        TileEntity te;
        this.instability += amt;
        this.func_70296_d();
        if (targetWorld != null && (te = targetWorld.func_175625_s(new BlockPos(this.linkX, this.linkY, this.linkZ))) != null && te instanceof TileMirrorEssentia) {
            ((TileMirrorEssentia)te).instability += amt;
            if (((TileMirrorEssentia)te).instability < 0) {
                ((TileMirrorEssentia)te).instability = 0;
            }
            te.func_70296_d();
        }
    }

    public void restoreLink() {
        if (this.isDestinationValid()) {
            WorldServer targetWorld = MinecraftServer.func_71276_C().func_71218_a(this.linkDim);
            if (targetWorld == null) {
                return;
            }
            TileEntity te = targetWorld.func_175625_s(new BlockPos(this.linkX, this.linkY, this.linkZ));
            if (te != null && te instanceof TileMirrorEssentia) {
                TileMirrorEssentia tm = (TileMirrorEssentia)te;
                tm.linked = true;
                tm.linkX = this.func_174877_v().func_177958_n();
                tm.linkY = this.func_174877_v().func_177956_o();
                tm.linkZ = this.func_174877_v().func_177952_p();
                tm.linkDim = this.field_145850_b.field_73011_w.func_177502_q();
                targetWorld.func_175689_h(tm.func_174877_v());
                this.linkedFacing = BlockStateUtils.getFacing(targetWorld.func_180495_p(new BlockPos(this.linkX, this.linkY, this.linkZ)));
                this.linked = true;
                this.func_70296_d();
                tm.func_70296_d();
                this.field_145850_b.func_175689_h(this.func_174877_v());
            }
        }
    }

    public void invalidateLink() {
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (targetWorld == null) {
            return;
        }
        if (!Utils.isChunkLoaded((World)targetWorld, this.linkX, this.linkZ)) {
            return;
        }
        TileEntity te = targetWorld.func_175625_s(new BlockPos(this.linkX, this.linkY, this.linkZ));
        if (te != null && te instanceof TileMirrorEssentia) {
            TileMirrorEssentia tm = (TileMirrorEssentia)te;
            tm.linked = false;
            tm.linkedFacing = EnumFacing.DOWN;
            this.func_70296_d();
            tm.func_70296_d();
            targetWorld.func_175689_h(new BlockPos(this.linkX, this.linkY, this.linkZ));
        }
    }

    public boolean isLinkValid() {
        if (!this.linked) {
            return false;
        }
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (targetWorld == null) {
            return false;
        }
        TileEntity te = targetWorld.func_175625_s(new BlockPos(this.linkX, this.linkY, this.linkZ));
        if (te == null || !(te instanceof TileMirrorEssentia)) {
            this.linked = false;
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
            return false;
        }
        TileMirrorEssentia tm = (TileMirrorEssentia)te;
        if (!tm.linked) {
            this.linked = false;
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
            return false;
        }
        if (tm.linkX != this.func_174877_v().func_177958_n() || tm.linkY != this.func_174877_v().func_177956_o() || tm.linkZ != this.func_174877_v().func_177952_p() || tm.linkDim != this.field_145850_b.field_73011_w.func_177502_q()) {
            this.linked = false;
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
            return false;
        }
        return true;
    }

    public boolean isLinkValidSimple() {
        if (!this.linked) {
            return false;
        }
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (targetWorld == null) {
            return false;
        }
        TileEntity te = targetWorld.func_175625_s(new BlockPos(this.linkX, this.linkY, this.linkZ));
        if (te == null || !(te instanceof TileMirrorEssentia)) {
            return false;
        }
        TileMirrorEssentia tm = (TileMirrorEssentia)te;
        if (!tm.linked) {
            return false;
        }
        return tm.linkX == this.func_174877_v().func_177958_n() && tm.linkY == this.func_174877_v().func_177956_o() && tm.linkZ == this.func_174877_v().func_177952_p() && tm.linkDim == this.field_145850_b.field_73011_w.func_177502_q();
    }

    public boolean isDestinationValid() {
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (targetWorld == null) {
            return false;
        }
        TileEntity te = targetWorld.func_175625_s(new BlockPos(this.linkX, this.linkY, this.linkZ));
        if (te == null || !(te instanceof TileMirrorEssentia)) {
            this.linked = false;
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
            return false;
        }
        TileMirrorEssentia tm = (TileMirrorEssentia)te;
        return !tm.isLinkValid();
    }

    @Override
    public AspectList getAspects() {
        return null;
    }

    @Override
    public void setAspects(AspectList aspects) {
    }

    @Override
    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    @Override
    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    @Override
    public boolean takeFromContainer(Aspect tag, int amount) {
        TileEntity te;
        if (!this.isLinkValid() || amount > 1) {
            return false;
        }
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (this.linkedFacing == EnumFacing.DOWN && targetWorld != null) {
            this.linkedFacing = BlockStateUtils.getFacing(targetWorld.func_180495_p(new BlockPos(this.linkX, this.linkY, this.linkZ)));
        }
        if ((te = targetWorld.func_175625_s(new BlockPos(this.linkX, this.linkY, this.linkZ))) != null && te instanceof TileMirrorEssentia) {
            boolean b = EssentiaHandler.drainEssentia(te, tag, this.linkedFacing, 8, true);
            if (b) {
                this.addInstability(null, amount);
            }
            return b;
        }
        return false;
    }

    @Override
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    @Override
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @Override
    public int containerContains(Aspect tag) {
        return 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkInstability();
            if (this.count++ % this.inc == 0) {
                if (!this.isLinkValidSimple()) {
                    if (this.inc < 600) {
                        this.inc += 20;
                    }
                    this.restoreLink();
                } else {
                    this.inc = 40;
                }
            }
        }
    }

    public void checkInstability() {
        if (this.instability > 0 && this.field_145850_b.field_73012_v.nextInt(10000) < this.instability) {
            AuraHelper.pollute(this.field_145850_b, this.field_174879_c, 1, true);
            this.instability = 0;
            this.func_70296_d();
        }
    }
}

