/*
 * Decompiled with CFR 0.152.
 */
package net.micmu.mcmods.micsiege.core;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.micmu.mcmods.micsiege.Config;
import net.micmu.mcmods.micsiege.MicSiegeMod;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public abstract class SiegeAIBase {
    private static final Predicate<EntityPlayer> VALID_PLAYER = new Predicate<EntityPlayer>(){

        public boolean apply(@Nullable EntityPlayer p) {
            return EntitySelectors.field_180132_d.apply((Object)p) && !p.field_70128_L && !p.func_70608_bn();
        }
    };
    private int active;
    private int checkStage = -1;
    private int spawnCount;
    private World world;
    private Village village;
    private boolean spawnFailFlag = false;
    private boolean forced = false;
    private int tickCount;
    private long nextLigtning = -1L;

    boolean startTick() {
        this.onCheck();
        if (this.isForced() && this.tryStart()) {
            this.checkStage = 3;
            return true;
        }
        if (this.checkDaytime(false)) {
            if (this.checkStage == 0 && this.checkDaytime(true)) {
                int n = this.checkStage = this.checkChance() ? 1 : 2;
            }
            if (this.checkStage == 1 && this.tryStart()) {
                this.checkStage = 3;
                return true;
            }
            return false;
        }
        this.checkStage = 0;
        return false;
    }

    void resetTick() {
        this.world = null;
        this.forced = false;
        this.village = null;
        this.spawnFailFlag = false;
        this.spawnCount = 0;
        this.tickCount = 0;
        this.nextLigtning = -1L;
    }

    boolean decTickCount() {
        int t = this.getTickCount();
        if (t <= 0) {
            return false;
        }
        this.setTickCount(t - 1);
        return true;
    }

    boolean isSiegeAverted() {
        return this.spawnCount == 0;
    }

    protected abstract boolean checkDaytime(boolean var1);

    protected abstract boolean checkChance();

    protected abstract boolean tryStart();

    protected abstract void tick();

    protected void onCheck() {
    }

    protected boolean onInitializeWorld() {
        return true;
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    void setActive(int active) {
        this.active = active;
    }

    int getActive() {
        return this.active;
    }

    void setWorld(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    public Random getRNG() {
        return this.world.field_73012_v;
    }

    boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public Village getVillage() {
        return this.village;
    }

    protected void setVillage(Village village) {
        if (village != this.village) {
            this.village = village;
        }
    }

    protected void stopSiege() {
        this.setTickCount(0);
    }

    protected void setTickCount(int c) {
        this.tickCount = c;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    protected List<EntityPlayer> getRandomizedPlayers() {
        List lst = this.world.func_175661_b(EntityPlayer.class, VALID_PLAYER);
        int toi = lst.size();
        if (toi > 1) {
            Random rnd = this.getRNG();
            for (int i = 1; i < toi; ++i) {
                int b;
                int a = rnd.nextInt(toi);
                if (a == (b = rnd.nextInt(toi))) continue;
                EntityPlayer tmp = (EntityPlayer)lst.get(a);
                lst.set(a, lst.get(b));
                lst.set(b, tmp);
            }
        }
        return lst;
    }

    protected boolean spawnAttacker(EntityCreature creature, Vec3d pos) {
        if (pos == null) {
            return false;
        }
        try {
            VillagerRegistry.VillagerProfession p;
            creature.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.getRNG().nextFloat() * 360.0f, 0.0f);
            creature.func_180482_a(this.world.func_175649_E(new BlockPos((Entity)creature)), (IEntityLivingData)null);
            if (creature instanceof EntityZombie) {
                if (Config.zombiePreventBreakDoors && ((EntityZombie)creature).func_146072_bX()) {
                    ((EntityZombie)creature).func_146070_a(false);
                }
                if (creature instanceof EntityZombieVillager && (p = this.getRandomVillagerProfession()) != null) {
                    ((EntityZombieVillager)creature).setForgeProfession(p);
                }
            } else if (creature instanceof EntityVillager && (p = this.getRandomVillagerProfession()) != null) {
                ((EntityVillager)creature).setProfession(p);
            }
            if (this.world.func_72838_d((Entity)creature)) {
                long now;
                Village v;
                ++this.spawnCount;
                if (Config.zombiePreventDespawn && !creature.func_104002_bU() && !(creature instanceof EntityVillager)) {
                    creature.func_110163_bv();
                }
                if ((v = this.getVillage()) != null) {
                    creature.func_175449_a(v.func_180608_a(), v.func_75568_b());
                    if (!(creature instanceof EntityZombie)) {
                        boolean needsHomingAI = true;
                        for (EntityAITasks.EntityAITaskEntry e : creature.field_70714_bg.field_75782_a) {
                            if (!(e.field_75733_a instanceof EntityAIMoveTowardsRestriction)) continue;
                            needsHomingAI = false;
                            break;
                        }
                        if (needsHomingAI) {
                            creature.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction(creature, 1.0));
                        }
                    }
                }
                if (Config.lightningStrikes && (now = this.world.func_82737_E()) >= this.nextLigtning) {
                    this.nextLigtning = now + (long)(19 + this.getRNG().nextInt(12));
                    this.world.func_72942_c((Entity)new EntityLightningBolt(this.getWorld(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, true));
                }
                return true;
            }
        }
        catch (Exception ex) {
            String msg = "Failed to spawn siege entity: " + creature.getClass();
            if (this.spawnFailFlag) {
                MicSiegeMod.LOG.error(msg);
            }
            MicSiegeMod.LOG.error(msg, (Throwable)ex);
            this.spawnFailFlag = true;
        }
        return false;
    }

    public int getSpawnCount() {
        return this.spawnCount;
    }

    BlockPos getVillagePos() {
        Village v = this.getVillage();
        return v != null ? v.func_180608_a() : null;
    }

    public boolean isCelestialAngle(float f) {
        float x = this.world.func_72826_c(0.0f);
        return x > f - 0.001f && x < f + 0.015f;
    }

    private VillagerRegistry.VillagerProfession getRandomVillagerProfession() {
        Set entries = ForgeRegistries.VILLAGER_PROFESSIONS.getEntries();
        if (entries.isEmpty()) {
            return null;
        }
        VillagerRegistry.VillagerProfession p = null;
        int e = 1 + this.getRNG().nextInt(entries.size());
        Iterator it = entries.iterator();
        for (int i = 0; i < e; ++i) {
            p = (VillagerRegistry.VillagerProfession)((Map.Entry)it.next()).getValue();
        }
        return p;
    }
}

