/*
 * Decompiled with CFR 0.152.
 */
package net.micmu.mcmods.micsiege.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.micmu.mcmods.micsiege.MicSiegeMod;
import net.micmu.mcmods.micsiege.core.SiegeAIBase;
import net.micmu.mcmods.micsiege.core.SiegeZombies;
import net.micmu.mcmods.micsiege.core.VillageSiegeDisable;
import net.micmu.mcmods.micsiege.core.VillageSiegeManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.Village;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class SiegeCore {
    private static final SiegeCore INSTANCE = new SiegeCore();
    private final Set<Class<? extends SiegeAIBase>> siegeClasses = new HashSet<Class<? extends SiegeAIBase>>(4);
    private boolean exceptionDumped = false;
    private Field injectField = null;

    public static SiegeCore getInstance() {
        return INSTANCE;
    }

    private SiegeCore() {
        this.registerSiege(SiegeZombies.class);
    }

    public void reloadConfig() {
    }

    public void registerSiege(@Nonnull Class<? extends SiegeAIBase> siegeAIClass) {
        this.siegeClasses.add(siegeAIClass);
    }

    public void unregisterSiege(@Nonnull Class<? extends SiegeAIBase> siegeAIClass) {
        this.siegeClasses.remove(siegeAIClass);
    }

    public boolean initializeWorld(@Nonnull WorldServer world) {
        int dimension = world.field_73011_w.getDimension();
        Field f = this.getSiegeField();
        if (f == null) {
            return false;
        }
        try {
            VillageSiege siege = (VillageSiege)f.get(world);
            List<SiegeAIBase> handlers = this.createSiegeHandlers(world);
            if (handlers.isEmpty()) {
                if (!(siege instanceof VillageSiegeDisable)) {
                    f.set(world, (Object)new VillageSiegeDisable());
                    if (MicSiegeMod.LOG.isDebugEnabled()) {
                        MicSiegeMod.LOG.debug("Disabled Zombie Siege mechanics for world " + dimension + ".");
                    }
                    return true;
                }
            } else if (!(siege instanceof VillageSiegeManager)) {
                f.set(world, (Object)new VillageSiegeManager((World)world, handlers.toArray(new SiegeAIBase[handlers.size()])));
                if (MicSiegeMod.LOG.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder(128);
                    sb.append("Injected replacement Zombie Siege mechanics for world ");
                    sb.append(dimension);
                    sb.append(" (");
                    boolean v = false;
                    for (SiegeAIBase b : handlers) {
                        if (v) {
                            sb.append(", ");
                        } else {
                            v = true;
                        }
                        sb.append(b.getClass().getName());
                    }
                    sb.append(')');
                    MicSiegeMod.LOG.debug(sb.toString());
                }
                return true;
            }
        }
        catch (Throwable t) {
            this.reflectionFail(t);
        }
        return false;
    }

    public int triggerSiegeNow(@Nonnull World world, @Nonnull BlockPos pos) {
        VillageSiegeManager manager;
        VillageSiegeManager villageSiegeManager = manager = world instanceof WorldServer ? this.getManager((WorldServer)world) : null;
        if (manager == null) {
            return 0;
        }
        Village village = world.func_175714_ae().func_176056_a(pos, 32);
        if (village == null || village.func_75566_g()) {
            return -1;
        }
        return manager.triggerSiege(village);
    }

    private VillageSiegeManager getManager(@Nonnull WorldServer world) {
        Field f = this.getSiegeField();
        if (f != null) {
            try {
                VillageSiege siege = (VillageSiege)f.get(world);
                if (siege instanceof VillageSiegeManager) {
                    return (VillageSiegeManager)siege;
                }
            }
            catch (Throwable t) {
                this.reflectionFail(t);
            }
        }
        return null;
    }

    private Field getSiegeField() {
        Field f = this.injectField;
        if (f == null) {
            try {
                this.injectField = f = this.findField(WorldServer.class, "villageSiege", "field_175740_d");
            }
            catch (Throwable t) {
                this.reflectionFail(t);
                return null;
            }
        }
        return f;
    }

    private void reflectionFail(Throwable t) {
        this.injectField = null;
        if (!this.exceptionDumped) {
            this.exceptionDumped = true;
            MicSiegeMod.LOG.error("Minecraft/Forge/other mod compatiblitiy issue?", t);
        }
        MicSiegeMod.LOG.error("*** Failed to set up Zombie Siege mechanics! Enchanced Zombie Siege mechanics will not work! ***");
    }

    private List<SiegeAIBase> createSiegeHandlers(@Nonnull WorldServer world) throws InstantiationException, IllegalAccessException {
        ArrayList<SiegeAIBase> out = new ArrayList<SiegeAIBase>();
        boolean i = false;
        for (Class<? extends SiegeAIBase> c : this.siegeClasses) {
            SiegeAIBase b = c.newInstance();
            b.setWorld((World)world);
            if (b.onInitializeWorld()) {
                out.add(b);
            }
            b.setWorld(null);
        }
        return out;
    }

    @Nonnull
    private Field findField(@Nonnull Class<?> clazz, @Nonnull String fieldName, @Nullable String fieldObfName) throws NoSuchFieldException, SecurityException {
        if (fieldObfName != null) {
            try {
                Field f = clazz.getDeclaredField(fieldObfName);
                f.setAccessible(true);
                return f;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Field f = clazz.getDeclaredField(fieldName);
        f.setAccessible(true);
        return f;
    }
}

