/*
 * Decompiled with CFR 0.152.
 */
package net.micmu.mcmods.micsiege.core;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.micmu.mcmods.micsiege.Config;
import net.micmu.mcmods.micsiege.core.SiegeAIBase;
import net.micmu.mcmods.micsiege.core.SiegeCore;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.Village;
import net.minecraft.village.VillageCollection;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;

public class SiegeZombies
extends SiegeAIBase {
    private BlockPos siegePos;
    private Boolean huskCache;
    private float timeAngle = -1.0f;

    SiegeZombies() {
    }

    @Override
    protected boolean onInitializeWorld() {
        int d = this.getWorld().field_73011_w.getDimension();
        return d != -1 && d != 1;
    }

    @Override
    protected void onStop() {
        this.siegePos = null;
        this.huskCache = null;
        this.timeAngle = -1.0f;
    }

    @Override
    protected boolean checkDaytime(boolean precise) {
        if (precise) {
            if (this.timeAngle < 0.0f) {
                this.timeAngle = 0.5f;
                if (Config.randomizeTime) {
                    this.timeAngle += this.getRNG().nextFloat() * 0.2f;
                }
            }
            return this.isCelestialAngle(this.timeAngle);
        }
        return !this.getWorld().func_72935_r();
    }

    @Override
    protected boolean checkChance() {
        int c = Config.chancesPerNight;
        return c > 0 && (c >= 100 || c > this.getRNG().nextInt(100));
    }

    @Override
    protected boolean tryStart() {
        boolean forced;
        List<Object> players;
        BlockPos.MutableBlockPos m = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos spawn = new BlockPos.MutableBlockPos();
        VillageCollection villageCol = this.getWorld().func_175714_ae();
        Random rnd = this.getRNG();
        SiegeCore core = SiegeCore.getInstance();
        Village village = this.isForced() ? this.getVillage() : null;
        float multi = (float)Config.villageDistanceMultiplier + 0.1f - 0.2f * rnd.nextFloat();
        if (multi < 0.1f) {
            multi = 0.1f;
        } else if (multi > 1.9f) {
            multi = 1.9f;
        }
        if (village != null) {
            players = Collections.singletonList(null);
            forced = true;
        } else {
            players = this.getRandomizedPlayers();
            forced = false;
        }
        for (EntityPlayer entityPlayer : players) {
            if (entityPlayer != null) {
                m.func_181079_c(MathHelper.func_76128_c((double)entityPlayer.field_70165_t), MathHelper.func_76128_c((double)entityPlayer.field_70163_u), MathHelper.func_76128_c((double)entityPlayer.field_70161_v));
                village = villageCol.func_176056_a((BlockPos)m, 1);
            }
            if (village == null || !forced && !this.isValidVillage(village)) continue;
            BlockPos center = village.func_180608_a();
            float f = (float)village.func_75568_b() * multi;
            boolean b = false;
            for (int i = 0; i < 10; ++i) {
                float a = rnd.nextFloat() * ((float)Math.PI * 2);
                spawn.func_181079_c(center.func_177958_n() + (int)(MathHelper.func_76134_b((float)a) * f), center.func_177956_o(), center.func_177952_p() + (int)(MathHelper.func_76126_a((float)a) * f));
                b = false;
                for (Village vx : villageCol.func_75540_b()) {
                    if (vx == village || vx.func_75566_g()) continue;
                    int r = vx.func_75568_b();
                    if (!(spawn.func_177951_i((Vec3i)vx.func_180608_a()) < (double)(4 * r * r))) continue;
                    b = true;
                    break;
                }
                if (!b) break;
            }
            if (b) {
                return false;
            }
            if (this.locateSpawnPos(m, village, (BlockPos)spawn) == null) continue;
            this.setVillage(village);
            this.siegePos = spawn.func_185334_h();
            this.huskCache = null;
            this.setTickCount(this.determineSpawnCount(village));
            return true;
        }
        return false;
    }

    @Override
    protected void tick() {
        int c = Config.zombieVillagerChance;
        Object z = c > 0 && (c >= 100 || c > this.getRNG().nextInt(100)) ? new EntityZombieVillager(this.getWorld()) : (this.isHuskBiome() && this.getRNG().nextBoolean() ? new EntityHusk(this.getWorld()) : new EntityZombie(this.getWorld()));
        this.spawnAttacker((EntityCreature)z, this.locateSpawnPos(null, this.getVillage(), this.siegePos));
    }

    private boolean isHuskBiome() {
        if (this.huskCache == null) {
            boolean f = false;
            List spawns = this.getWorld().func_180494_b(this.siegePos).func_76747_a(EnumCreatureType.MONSTER);
            if (spawns != null && !spawns.isEmpty()) {
                for (Biome.SpawnListEntry e : spawns) {
                    if (!EntityHusk.class.isAssignableFrom(e.field_76300_b)) continue;
                    f = true;
                    break;
                }
            }
            this.huskCache = f;
        }
        return this.huskCache;
    }

    private boolean isValidVillage(Village village) {
        return village.func_75567_c() >= Config.villageMinDoors && village.func_75561_d() >= 20 && village.func_75562_e() >= Config.villageMinVillagers;
    }

    private int determineSpawnCount(Village village) {
        int i = Config.zombieSpawnCount;
        if (i < 1 || i > 1000) {
            return 0;
        }
        switch (this.getWorld().func_175659_aa()) {
            case EASY: {
                i = Math.round((float)i * 0.5f);
                break;
            }
            case NORMAL: {
                i = Math.round((float)i * 0.75f);
                break;
            }
        }
        int p = i > 2 ? i / 5 : 0;
        return p <= 0 ? i : i - p + this.getRNG().nextInt(p + 1);
    }

    private Vec3d locateSpawnPos(BlockPos.MutableBlockPos m, Village village, BlockPos pos) {
        World world = this.getWorld();
        Random rnd = this.getRNG();
        if (m == null) {
            m = new BlockPos.MutableBlockPos();
        }
        BlockPos center = village.func_180608_a();
        int i = village.func_75568_b();
        double r = 4 * i * i;
        for (i = 0; i < 45; ++i) {
            Block b;
            m.func_181079_c(pos.func_177958_n() + rnd.nextInt(17) - 8, pos.func_177956_o() + rnd.nextInt(11) - 5, pos.func_177952_p() + rnd.nextInt(17) - 8);
            if (!(m.func_177951_i((Vec3i)center) < r) || !world.func_175668_a((BlockPos)m, false) || !(b = world.func_180495_p((BlockPos)m).func_177230_c()).func_176205_b((IBlockAccess)world, (BlockPos)m) || !WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)world, (BlockPos)m) || this.isDoorNearby(village, (BlockPos)m) && world.func_175672_r((BlockPos)m).func_177956_o() > m.func_177956_o()) continue;
            return new Vec3d((double)m.func_177958_n() + 0.5, (double)m.func_177956_o(), (double)m.func_177952_p() + 0.5);
        }
        return null;
    }

    private boolean isDoorNearby(Village village, BlockPos p) {
        for (VillageDoorInfo di : village.func_75558_f()) {
            if (di.func_179846_b(p) > 150) continue;
            return true;
        }
        return false;
    }
}

