/*
 * Decompiled with CFR 0.152.
 */
package net.micmu.mcmods.micsiege.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.world.World;

final class SpawnableEntity {
    private final Class<? extends EntityCreature> entityClass;
    private final Constructor<? extends EntityCreature> constructor;
    private final int weight;

    SpawnableEntity(@Nonnull Class<? extends EntityCreature> entityClass, int weight) throws NoSuchMethodException, SecurityException {
        this.constructor = entityClass.getDeclaredConstructor(World.class);
        if (!this.constructor.isAccessible()) {
            this.constructor.setAccessible(true);
        }
        this.entityClass = entityClass;
        this.weight = weight;
    }

    int getWeight() {
        return this.weight;
    }

    boolean isDesertOnly() {
        return EntityHusk.class.isAssignableFrom(this.entityClass);
    }

    @Nonnull
    EntityCreature newInstance(@Nonnull World world) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.constructor.newInstance(world);
    }
}

