/*
 * Decompiled with CFR 0.152.
 */
package net.micmu.mcmods.micsiege.core;

import net.micmu.mcmods.micsiege.Config;
import net.micmu.mcmods.micsiege.MicSiegeMod;
import net.micmu.mcmods.micsiege.core.SiegeAIBase;
import net.minecraft.village.Village;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

final class VillageSiegeManager
extends VillageSiege {
    private final World world;
    private final SiegeAIBase[] sieges;
    private int tick;
    private SiegeAIBase active = null;

    VillageSiegeManager(World world, SiegeAIBase[] sieges) {
        super(null);
        this.world = world;
        this.sieges = sieges;
        this.tick = 100 + world.field_73012_v.nextInt(150);
    }

    public void func_75528_a() {
        if (this.tick > 0) {
            --this.tick;
        } else if (this.active != null) {
            SiegeAIBase s = this.active;
            try {
                switch (s.getActive()) {
                    case 1: {
                        s.onStart();
                        s.setActive(2);
                        if (MicSiegeMod.LOG.isTraceEnabled()) {
                            MicSiegeMod.LOG.trace("Siege [" + s.getClass().getName() + "] spawn logic started in village @ " + s.getVillagePos());
                        }
                        return;
                    }
                    case 2: {
                        if (this.world.func_175659_aa() == EnumDifficulty.PEACEFUL || !s.isForced() && !s.checkDaytime(false) || !s.decTickCount()) {
                            s.setActive(3);
                        } else {
                            s.tick();
                            if (s.getTickCount() <= 0) {
                                s.setActive(3);
                            }
                        }
                        this.tick = 2 + s.getRNG().nextInt(3);
                        return;
                    }
                }
                s.onStop();
                if (MicSiegeMod.LOG.isTraceEnabled()) {
                    MicSiegeMod.LOG.trace("Siege [" + s.getClass().getName() + "] spawn logic finished" + (s.isSiegeAverted() ? " (siege averted)." : " (mobs spawned: " + s.getSpawnCount() + ")."));
                }
            }
            catch (Exception e) {
                MicSiegeMod.LOG.error("Siege [" + s.getClass().getName() + "] spawn logic terminated because of an exception.", (Throwable)e);
            }
            s.setActive(0);
            s.resetTick();
            this.active = null;
            this.tick = 100 + this.world.field_73012_v.nextInt(150);
        } else if (this.triggerSiege(null) == 0) {
            this.tick = 91 + this.world.field_73012_v.nextInt(10);
        }
    }

    int triggerSiege(Village forceVillage) {
        if (this.active != null) {
            return -2;
        }
        if (this.world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return -3;
        }
        if (forceVillage != null || Config.chancesPerNight > 0) {
            for (SiegeAIBase s : this.sieges) {
                if (s.getActive() != 0) continue;
                s.setWorld(this.world);
                if (forceVillage != null) {
                    s.setVillage(forceVillage);
                    s.setForced(true);
                }
                if (s.startTick()) {
                    s.setActive(1);
                    this.active = s;
                    this.tick = 3;
                    return 1;
                }
                s.setWorld(null);
            }
        }
        return -4;
    }
}

