/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon;

import com.raz.howlingmoon.HMPotions;
import com.raz.howlingmoon.HowlingMoon;
import com.raz.howlingmoon.IWerewolfCapability;
import com.raz.howlingmoon.WereList;
import com.raz.howlingmoon.entities.EntityWere;
import com.raz.howlingmoon.entities.EntityWerewolf;
import com.raz.howlingmoon.items.HMItems;
import com.raz.howlingmoon.items.ItemSilverSword;
import com.raz.howlingmoon.packets.PacketDispatcher;
import com.raz.howlingmoon.packets.SyncExpLevelClient;
import com.raz.howlingmoon.packets.SyncWereCapsMessage;
import com.raz.howlingmoon.packets.TrackingMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WereEventHandler {
    public static List<String> transformedPlayers = new ArrayList<String>();
    @CapabilityInject(value=IWerewolfCapability.class)
    public static final Capability<IWerewolfCapability> WERE_CAP = null;

    @SubscribeEvent
    public void onEntityConstruct(AttachCapabilitiesEvent.Entity evt) {
        if (evt.getEntity() instanceof EntityPlayer) {
            evt.addCapability(new ResourceLocation("howlingmoon", "IWerewolfCapability"), (ICapabilityProvider)new ICapabilitySerializable<NBTBase>(){
                IWerewolfCapability inst = (IWerewolfCapability)WERE_CAP.getDefaultInstance();

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == WERE_CAP;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == WERE_CAP ? WERE_CAP.cast((Object)this.inst) : null);
                }

                public NBTBase serializeNBT() {
                    return WERE_CAP.getStorage().writeNBT(WERE_CAP, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTBase nbt) {
                    WERE_CAP.getStorage().readNBT(WERE_CAP, (Object)this.inst, null, nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().field_70170_p.field_72995_K) {
            PacketDispatcher.sendTo(new SyncWereCapsMessage((EntityPlayer)event.getEntity()), (EntityPlayerMP)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        ((IWerewolfCapability)event.getEntityPlayer().getCapability(WERE_CAP, null)).copy((IWerewolfCapability)event.getOriginal().getCapability(WERE_CAP, null));
    }

    @SubscribeEvent
    public void TrackHandler(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayer && !event.getEntityPlayer().field_70170_p.field_72995_K && ((IWerewolfCapability)((EntityPlayer)event.getTarget()).getCapability(WERE_CAP, null)).isWerewolf()) {
            PacketDispatcher.sendTo(new TrackingMessage((EntityPlayer)event.getTarget()), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void jumpHeight(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IWerewolfCapability wolf = (IWerewolfCapability)player.getCapability(WERE_CAP, null);
            if (wolf.isTransformed()) {
                double i = (double)wolf.getAttributeTreeAbility(WereList.JUMP.getKey()) / 10.0;
                i += 0.2;
                if (wolf.getModel() == 2) {
                    i *= 1.5;
                }
                if (this.wearingArmor(player)) {
                    // empty if block
                }
                event.getEntityLiving().field_70181_x += i;
            }
            if (player.field_70170_p.field_72995_K) {
                if (this.canLeap(player)) {
                    float speed = 1.5f + 0.1f * (float)wolf.getLevel();
                    if (!player.field_70122_E) {
                        speed -= 0.3f;
                    }
                    if (wolf.getLeapState() == 0) {
                        player.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * speed;
                        player.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * speed;
                    } else {
                        if (player.field_70127_C < 0.0f) {
                            player.field_70181_x += (double)(-MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * speed / 5.0f);
                        }
                        player.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * speed;
                        player.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * speed;
                    }
                }
                wolf.setLeap(false);
            }
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        EntityPlayer player;
        IWerewolfCapability wolf;
        if (event.getEntityLiving() instanceof EntityPlayer && (wolf = (IWerewolfCapability)(player = (EntityPlayer)event.getEntityLiving()).getCapability(WERE_CAP, null)).isTransformed()) {
            float reduceby = 2.0f * (float)Math.pow(2.0, wolf.getAttributeTreeAbility(WereList.FALL.getKey()));
            if (wolf.getModel() == 2) {
                reduceby *= 2.0f;
            }
            event.setDistance(event.getDistance() - reduceby);
        }
    }

    @SubscribeEvent
    public void updateStep(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().func_70644_a((Potion)HMPotions.BLEEDING) && event.getEntityLiving().func_70660_b((Potion)HMPotions.BLEEDING).func_76459_b() % 40 == 0) {
            event.getEntityLiving().func_70097_a(DamageSource.field_76376_m.func_151518_m(), 1.0f);
        }
        if (event.getEntityLiving().func_70644_a((Potion)HMPotions.WOLFSBANE)) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                IWerewolfCapability wolfP = (IWerewolfCapability)((EntityPlayer)event.getEntityLiving()).getCapability(WERE_CAP, null);
                if (wolfP.isWerewolf()) {
                    if (event.getEntityLiving().func_70660_b((Potion)HMPotions.WOLFSBANE).func_76459_b() % 20 == 0) {
                        event.getEntityLiving().func_70097_a(DamageSource.field_76376_m.func_151518_m(), 1.0f);
                    }
                } else {
                    event.getEntityLiving().func_184596_c((Potion)HMPotions.WOLFSBANE);
                }
            } else if (event.getEntityLiving() instanceof EntityWerewolf) {
                if (event.getEntityLiving().func_70660_b((Potion)HMPotions.WOLFSBANE).func_76459_b() % 20 == 0) {
                    event.getEntityLiving().func_70097_a(DamageSource.field_76376_m.func_151518_m(), 1.0f);
                }
            } else {
                event.getEntityLiving().func_184596_c((Potion)HMPotions.WOLFSBANE);
            }
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            String s = player.func_146103_bH().getName() + ":" + player.field_70170_p.field_72995_K;
            IWerewolfCapability wolf = (IWerewolfCapability)((EntityPlayer)event.getEntityLiving()).getCapability(WERE_CAP, null);
            if (transformedPlayers.contains(s)) {
                if (wolf.isTransformed()) {
                    if ((player.field_70122_E || player.field_71075_bZ.field_75100_b) && player.field_70701_bs > 0.0f && !player.func_70055_a(Material.field_151586_h)) {
                        float additional = 0.004f * (float)wolf.getLevel();
                        additional += 0.01f * (float)wolf.getAttributeTreeAbility(WereList.MOVEMENT.getKey());
                        if (player.func_70051_ag()) {
                            additional = wolf.getModel() == 0 ? (additional *= 1.5f) : (additional *= 2.0f);
                        }
                        if (wolf.getModel() == 1) {
                            additional *= 1.5f;
                        }
                        if (this.wearingArmor(player)) {
                            additional *= 0.25f;
                        }
                        if (player.func_70644_a((Potion)HMPotions.WOLFSBANE)) {
                            additional *= 0.6f;
                        }
                        player.func_70060_a(0.0f, 1.0f, additional);
                    }
                    player.field_70138_W = player.func_70093_af() ? 0.60001f : 1.1f;
                    if (wolf.getAttributeTreeAbility(WereList.KNOCKRESIST.getKey()) == 0) {
                        if (wolf.getKnockbackResist()) {
                            player.func_110140_aT().func_111148_a(wolf.getAttributeKBResist());
                            wolf.setKnockbackResist(false);
                        }
                    } else if (!wolf.getKnockbackResist()) {
                        player.func_110140_aT().func_111147_b(wolf.getAttributeKBResist());
                        wolf.setKnockbackResist(true);
                    }
                    if (wolf.getLevel() > 9 && wolf.getNightVision()) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 310, 0, false, false));
                    }
                } else {
                    player.field_70138_W = 0.6f;
                    transformedPlayers.remove(s);
                    player.func_110140_aT().func_111148_a(wolf.getAttributeKBResist());
                    wolf.setKnockbackResist(false);
                }
            } else if (wolf.isTransformed()) {
                transformedPlayers.add(s);
                player.field_70138_W = 1.1f;
                if (wolf.getAttributeTreeAbility(WereList.KNOCKRESIST.getKey()) > 0) {
                    player.func_110140_aT().func_111147_b(wolf.getAttributeKBResist());
                    wolf.setKnockbackResist(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void clawAttack(LivingHurtEvent event) {
        if (event.getEntityLiving() != null) {
            float damage;
            IWerewolfCapability wolf;
            EntityPlayer player;
            boolean isSilver = false;
            if (event.getSource().func_76346_g() instanceof EntityLivingBase && ((EntityLivingBase)event.getSource().func_76346_g()).func_184614_ca() != null && ((EntityLivingBase)event.getSource().func_76346_g()).func_184614_ca().func_77973_b() instanceof ItemSilverSword) {
                isSilver = true;
                if (event.getEntityLiving() instanceof EntityPlayer) {
                    player = (EntityPlayer)event.getEntityLiving();
                    wolf = (IWerewolfCapability)player.getCapability(WERE_CAP, null);
                    if (wolf.isTransformed()) {
                        event.setAmount(event.getAmount() * 3.0f);
                    } else if (wolf.isWerewolf()) {
                        event.setAmount(event.getAmount() * 2.0f);
                    }
                } else if (event.getEntityLiving() instanceof EntityWerewolf) {
                    event.setAmount(event.getAmount() * 3.0f);
                } else if (event.getEntityLiving().func_70662_br()) {
                    event.setAmount(event.getAmount() * 2.0f);
                }
            }
            if (event.getSource().func_76346_g() instanceof EntityPlayer && (wolf = (IWerewolfCapability)(player = (EntityPlayer)event.getSource().func_76346_g()).getCapability(WERE_CAP, null)).isTransformed()) {
                if (player.func_184614_ca() == null) {
                    if (wolf.getAbilityTreeAbility(WereList.SHRED.getKey())) {
                        event.getEntityLiving().func_70690_d(new PotionEffect((Potion)HMPotions.BLEEDING, 300, 0, false, true));
                    }
                    damage = 4.0f + (float)Math.floor((double)wolf.getLevel() / 5.0);
                    damage *= 1.0f + 0.15f * (float)wolf.getAttributeTreeAbility(WereList.STRENGTH.getKey());
                    if (wolf.getModel() == 2) {
                        damage *= 1.25f;
                    }
                    int armorIgnore = wolf.getAttributeTreeAbility(WereList.REND.getKey()) * 2;
                    int armor = event.getEntityLiving().func_70658_aO();
                    if (armorIgnore > 0 && armor > 0) {
                        if ((armor -= armorIgnore) < 0) {
                            armor = 0;
                        }
                        event.getSource().func_76348_h();
                        damage = CombatRules.func_189427_a((float)damage, (float)armor, (float)((float)event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
                    }
                    event.setAmount(damage);
                    int kbAmount = wolf.getAttributeTreeAbility(WereList.KNOCKBACK.getKey());
                    if (kbAmount > 0) {
                        event.getEntityLiving().func_70653_a((Entity)event.getEntityLiving(), 2.0f * (float)kbAmount, event.getSource().func_76364_f().field_70165_t - event.getEntityLiving().field_70165_t, event.getSource().func_76364_f().field_70161_v - event.getEntityLiving().field_70161_v);
                    }
                } else {
                    event.setAmount(event.getAmount() * 0.6f);
                }
            }
            if (event.getEntity() instanceof EntityPlayer) {
                player = (EntityPlayer)event.getEntity();
                wolf = (IWerewolfCapability)player.getCapability(WERE_CAP, null);
                if (wolf.isTransformed()) {
                    if (this.wearingArmor(player)) {
                        Iterator armor = player.func_184193_aE().iterator();
                        int slot = 0;
                        while (armor.hasNext()) {
                            ItemStack piece = (ItemStack)armor.next();
                            if (piece != null) {
                                if (piece.func_77973_b() instanceof ISpecialArmor) {
                                    ((ISpecialArmor)piece.func_77973_b()).damageArmor((EntityLivingBase)player, piece, event.getSource(), 2, slot);
                                } else {
                                    piece.func_77972_a(2, (EntityLivingBase)player);
                                }
                            }
                            ++slot;
                        }
                    } else if (!event.getSource().func_76347_k() && !event.getSource().func_151517_h()) {
                        damage = isSilver ? 1.0f - ((float)wolf.getLevel() * 0.01f + (float)wolf.getAttributeTreeAbility(WereList.PROTECTION.getKey()) * 0.04f) : 1.0f - ((float)wolf.getLevel() * 0.02f + (float)wolf.getAttributeTreeAbility(WereList.PROTECTION.getKey()) * 0.08f);
                        if (damage < 0.2f) {
                            damage = 0.2f;
                        }
                        event.setAmount(event.getAmount() * damage);
                    }
                }
            } else if (event.getEntity() instanceof EntityWere) {
                EntityWere wolf2 = (EntityWere)event.getEntity();
                if (!event.getSource().func_76347_k() && !event.getSource().func_151517_h()) {
                    float damage2 = isSilver ? 1.0f - (float)wolf2.getSavageryLevel() * 0.08f : 1.0f - (float)wolf2.getSavageryLevel() * 0.16f;
                    if (damage2 < 0.2f) {
                        damage2 = 0.2f;
                    }
                    event.setAmount(event.getAmount() * damage2);
                }
            }
        }
    }

    @SubscribeEvent
    public void onWerewolfKill(LivingDeathEvent event) {
        EntityPlayer player;
        IWerewolfCapability wolf;
        if (event.getSource().func_76364_f() instanceof EntityPlayer && (wolf = (IWerewolfCapability)(player = (EntityPlayer)event.getSource().func_76364_f()).getCapability(WERE_CAP, null)).isWerewolf() && wolf.isTransformed()) {
            player.func_71024_bL().func_75122_a(1, 2.0f);
            if (event.getEntityLiving().func_110138_aP() > 2.0f) {
                wolf.addExp(Math.max(1, (int)event.getEntityLiving().func_110138_aP() / 10));
                PacketDispatcher.sendTo(new SyncExpLevelClient(player), (EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent
    public void onWerewolfStartEat(LivingEntityUseItemEvent.Start event) {
        IWerewolfCapability wolf;
        if (event.getEntityLiving() instanceof EntityPlayer && event.getItem().func_77973_b() instanceof ItemFood && (wolf = (IWerewolfCapability)((EntityPlayer)event.getEntityLiving()).getCapability(WERE_CAP, null)).getAttributeTreeAbility(WereList.HUNGER.getKey()) < 3) {
            ItemFood itemfood = (ItemFood)event.getItem().func_77973_b();
            if (wolf.isWerewolf() && wolf.isTransformed() && !itemfood.func_77845_h()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void werewolfBreakBlock(PlayerEvent.BreakSpeed event) {
        IWerewolfCapability wolf = (IWerewolfCapability)event.getEntityPlayer().getCapability(WERE_CAP, null);
        if (wolf.isTransformed()) {
            if (event.getEntityPlayer().func_184614_ca() != null) {
                event.setNewSpeed(event.getNewSpeed() * 0.4f);
            }
            if (event.getEntityPlayer().func_184614_ca() == null) {
                event.setNewSpeed(event.getNewSpeed() + event.getNewSpeed() * (float)wolf.getAttributeTreeAbility(WereList.DIG.getKey()));
            }
        }
    }

    @SubscribeEvent
    public void werewolfSleepEvent(PlayerSleepInBedEvent event) {
        IWerewolfCapability wolf;
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && (wolf = (IWerewolfCapability)event.getEntityPlayer().getCapability(WERE_CAP, null)).isTransformed()) {
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("werewolf.message.sleep", new Object[0]));
        }
    }

    @SubscribeEvent
    public void werewolfWakeup(PlayerWakeUpEvent event) {
        IWerewolfCapability wolf;
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && (wolf = (IWerewolfCapability)event.getEntityPlayer().getCapability(WERE_CAP, null)).isWerewolf() && event.getEntityPlayer().field_71071_by.func_70431_c(new ItemStack((Item)HMItems.moonstone))) {
            Random rand = new Random();
            if (rand.nextBoolean()) {
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("werewolf.message.wake", new Object[0]));
            } else {
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("werewolf.message.wake2", new Object[0]));
            }
            event.getEntityPlayer().field_70170_p.func_184148_a(null, event.getEntityPlayer().field_70165_t, event.getEntityPlayer().field_70163_u, event.getEntityPlayer().field_70161_v, HowlingMoon.howl, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private boolean canLeap(EntityPlayer player) {
        IWerewolfCapability wolf = (IWerewolfCapability)player.getCapability(WERE_CAP, null);
        if (wolf.getAbilityTreeAbility(WereList.LEAP.getKey())) {
            if (Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d() && wolf.getSprintJump() > 1) {
                return true;
            }
            if (player.func_70093_af() && wolf.getSneakJump() > 1) {
                return true;
            }
            return wolf.getLeap();
        }
        return false;
    }

    private boolean wearingArmor(EntityPlayer player) {
        Iterator armor = player.func_184193_aE().iterator();
        while (armor.hasNext()) {
            if (armor.next() == null) continue;
            return true;
        }
        return false;
    }
}

