/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.entities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityStun
extends Entity {
    public float riderHeight;
    public float renderYawOffset;
    public float prevRenderYawOffset;
    public float rotationYawHead;
    public float prevRotationYawHead;
    protected float prevOnGroundSpeedFactor;
    protected float onGroundSpeedFactor;
    protected float movedDistance;
    protected float prevMovedDistance;
    public float moveStrafing;
    public float moveForward;
    public float randomYawVelocity;
    protected int newPosRotationIncrements;
    protected double interpTargetX;
    protected double interpTargetY;
    protected double interpTargetZ;
    protected double interpTargetYaw;
    protected double interpTargetPitch;
    private boolean potionsNeedUpdate = true;
    private float landMovementFactor;

    public EntityStun(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.1f);
    }

    protected void func_70088_a() {
    }

    public void changeSize(float width, float height) {
        this.riderHeight = height;
        this.func_70105_a(width, 0.1f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.onLivingUpdate();
        if (!this.func_184207_aI()) {
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 6) {
                this.func_70106_y();
            }
        } else if (this.field_70173_aa > 60) {
            this.func_70106_y();
        } else {
            for (Entity entity : this.func_184188_bt()) {
                if (entity instanceof EntityCreeper && ((EntityCreeper)entity).func_70832_p() != -1) {
                    ((EntityCreeper)entity).func_70829_a(-1);
                }
                if (!(entity instanceof EntityLiving) || ((EntityLiving)entity).func_70638_az() == null) continue;
                ((EntityLiving)entity).func_70624_b(null);
            }
        }
        double d0 = this.field_70165_t - this.field_70169_q;
        double d1 = this.field_70161_v - this.field_70166_s;
        float f1 = (float)(d0 * d0 + d1 * d1);
        float f2 = this.renderYawOffset;
        float f3 = 0.0f;
        this.prevOnGroundSpeedFactor = this.onGroundSpeedFactor;
        float f = 0.0f;
        if (f1 > 0.0025000002f) {
            f = 1.0f;
            f3 = (float)Math.sqrt(f1) * 3.0f;
            f2 = (float)MathHelper.func_181159_b((double)d1, (double)d0) * 57.295776f - 90.0f;
        }
        if (!this.field_70122_E) {
            f = 0.0f;
        }
        this.onGroundSpeedFactor += (f - this.onGroundSpeedFactor) * 0.3f;
        this.field_70170_p.field_72984_F.func_76320_a("headTurn");
        f3 = this.updateDistance(f2, f3);
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("rangeChecks");
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset < -180.0f) {
            this.prevRenderYawOffset -= 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset >= 180.0f) {
            this.prevRenderYawOffset += 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.rotationYawHead - this.prevRotationYawHead < -180.0f) {
            this.prevRotationYawHead -= 360.0f;
        }
        while (this.rotationYawHead - this.prevRotationYawHead >= 180.0f) {
            this.prevRotationYawHead += 360.0f;
        }
        this.field_70170_p.field_72984_F.func_76319_b();
        this.movedDistance += f3;
    }

    protected float updateDistance(float p_110146_1_, float p_110146_2_) {
        boolean flag;
        float f = MathHelper.func_76142_g((float)(p_110146_1_ - this.renderYawOffset));
        this.renderYawOffset += f * 0.3f;
        float f1 = MathHelper.func_76142_g((float)(this.field_70177_z - this.renderYawOffset));
        boolean bl = flag = f1 < -90.0f || f1 >= 90.0f;
        if (f1 < -75.0f) {
            f1 = -75.0f;
        }
        if (f1 >= 75.0f) {
            f1 = 75.0f;
        }
        this.renderYawOffset = this.field_70177_z - f1;
        if (f1 * f1 > 2500.0f) {
            this.renderYawOffset += f1 * 0.2f;
        }
        if (flag) {
            p_110146_2_ *= -1.0f;
        }
        return p_110146_2_;
    }

    public void onLivingUpdate() {
        if (this.newPosRotationIncrements > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.interpTargetX - this.field_70165_t) / (double)this.newPosRotationIncrements;
            double d1 = this.field_70163_u + (this.interpTargetY - this.field_70163_u) / (double)this.newPosRotationIncrements;
            double d2 = this.field_70161_v + (this.interpTargetZ - this.field_70161_v) / (double)this.newPosRotationIncrements;
            double d3 = MathHelper.func_76138_g((double)(this.interpTargetYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.newPosRotationIncrements);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.interpTargetPitch - (double)this.field_70125_A) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else if (!this.isServerWorld()) {
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
        }
        if (Math.abs(this.field_70159_w) < 0.003) {
            this.field_70159_w = 0.0;
        }
        if (Math.abs(this.field_70181_x) < 0.003) {
            this.field_70181_x = 0.0;
        }
        if (Math.abs(this.field_70179_y) < 0.003) {
            this.field_70179_y = 0.0;
        }
        this.field_70170_p.field_72984_F.func_76320_a("travel");
        this.moveStrafing *= 0.98f;
        this.moveForward *= 0.98f;
        this.randomYawVelocity *= 0.9f;
        this.moveEntityWithHeading(this.moveStrafing, this.moveForward);
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("push");
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    public void knockBack(Entity entityIn, float strenght, double xRatio, double zRatio) {
        this.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
        this.field_70159_w /= 2.0;
        this.field_70179_y /= 2.0;
        this.field_70159_w -= xRatio / (double)f * (double)strenght;
        this.field_70179_y -= zRatio / (double)f * (double)strenght;
        this.field_70181_x /= 2.0;
        this.field_70181_x += (double)strenght;
        if (this.field_70181_x > (double)0.4f) {
            this.field_70181_x = 0.4f;
        }
    }

    public double func_70042_X() {
        return -0.3;
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public boolean isServerWorld() {
        return !this.field_70170_p.field_72995_K;
    }

    public void func_70098_U() {
        super.func_70098_U();
        this.prevOnGroundSpeedFactor = this.onGroundSpeedFactor;
        this.onGroundSpeedFactor = 0.0f;
        this.field_70143_R = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.interpTargetX = x;
        this.interpTargetY = y;
        this.interpTargetZ = z;
        this.interpTargetYaw = yaw;
        this.interpTargetPitch = pitch;
        this.newPosRotationIncrements = posRotationIncrements;
    }

    public void moveEntityWithHeading(float strafe, float forward) {
        if (this.isServerWorld() || this.func_184186_bw()) {
            if (!this.func_70090_H()) {
                if (!this.func_180799_ab()) {
                    float f6 = 0.91f;
                    BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)this.field_70165_t, (double)(this.func_174813_aQ().field_72338_b - 1.0), (double)this.field_70161_v);
                    if (this.field_70122_E) {
                        f6 = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_177230_c().field_149765_K * 0.91f;
                    }
                    float f7 = 0.16277136f / (f6 * f6 * f6);
                    float f8 = this.getAIMoveSpeed() * f7;
                    this.func_70060_a(strafe, forward, f8);
                    f6 = 0.91f;
                    if (this.field_70122_E) {
                        f6 = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_189532_c((double)this.field_70165_t, (double)(this.func_174813_aQ().field_72338_b - 1.0), (double)this.field_70161_v)).func_177230_c().field_149765_K * 0.91f;
                    }
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    blockpos$pooledmutableblockpos.func_189532_c(this.field_70165_t, 0.0, this.field_70161_v);
                    if (!this.field_70170_p.field_72995_K || this.field_70170_p.func_175667_e((BlockPos)blockpos$pooledmutableblockpos) && this.field_70170_p.func_175726_f((BlockPos)blockpos$pooledmutableblockpos).func_177410_o()) {
                        if (!this.func_189652_ae()) {
                            this.field_70181_x -= 0.08;
                        }
                    } else {
                        this.field_70181_x = this.field_70163_u > 0.0 ? -0.1 : 0.0;
                    }
                    this.field_70181_x *= (double)0.98f;
                    this.field_70159_w *= (double)f6;
                    this.field_70179_y *= (double)f6;
                    blockpos$pooledmutableblockpos.func_185344_t();
                } else {
                    double d4 = this.field_70163_u;
                    this.func_70060_a(strafe, forward, 0.02f);
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                    if (!this.func_189652_ae()) {
                        this.field_70181_x -= 0.02;
                    }
                    if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d4, this.field_70179_y)) {
                        this.field_70181_x = 0.3f;
                    }
                }
            } else {
                double d0 = this.field_70163_u;
                float f1 = this.getWaterSlowDown();
                float f2 = 0.02f;
                float f3 = 0.0f;
                if (f3 > 3.0f) {
                    f3 = 3.0f;
                }
                if (!this.field_70122_E) {
                    f3 *= 0.5f;
                }
                if (f3 > 0.0f) {
                    f1 += (0.54600006f - f1) * f3 / 3.0f;
                    f2 += (this.getAIMoveSpeed() - f2) * f3 / 3.0f;
                }
                this.func_70060_a(strafe, forward, f2);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f1;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)f1;
                if (!this.func_189652_ae()) {
                    this.field_70181_x -= 0.02;
                }
                if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d0, this.field_70179_y)) {
                    this.field_70181_x = 0.3f;
                }
            }
        }
    }

    public float getAIMoveSpeed() {
        return this.landMovementFactor;
    }

    protected float getWaterSlowDown() {
        return 0.8f;
    }
}

