/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon;

import com.raz.howlingmoon.IWerewolfCapability;
import com.raz.howlingmoon.WereBase;
import com.raz.howlingmoon.WereList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class WereAbility
extends WereBase {
    private final String key;
    private boolean unlockable;
    public final List<WereAbility> parentAbilities;
    private final ResourceLocation texture;

    public WereAbility(String key, String unlocalizedName, ResourceLocation texture, boolean unlockable) {
        this(key, unlocalizedName, (WereAbility)null, texture, unlockable);
    }

    public WereAbility(String key, String unlocalizedName, WereAbility parent, ResourceLocation texture, boolean unlockable) {
        this(key, unlocalizedName, Arrays.asList(parent), texture, unlockable);
    }

    public WereAbility(String key, String unlocalizedName, List<WereAbility> parents, ResourceLocation texture, boolean unlockable) {
        super(unlocalizedName);
        this.key = key;
        this.parentAbilities = parents;
        this.texture = texture;
        this.unlockable = unlockable;
    }

    public WereAbility registerStat() {
        WereList.ABILITIES.add(this);
        if (this.unlockable) {
            WereList.UNLOCKABILITIES.add(this);
        } else {
            WereList.QUESTABILITIES.add(this);
        }
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public boolean canUnlock(IWerewolfCapability wolf) {
        if (!this.unlockable || wolf.getAbilityTreeAbility(this.getKey())) {
            return false;
        }
        if (this.parentAbilities == null) {
            return true;
        }
        for (int i = 0; i < this.parentAbilities.size(); ++i) {
            if (this.parentAbilities.get(i) == null || wolf.getAbilityTreeAbility(this.parentAbilities.get(i).getKey())) continue;
            return false;
        }
        return true;
    }

    public boolean havePointsFor(IWerewolfCapability wolf) {
        return wolf.getUsuableAbilityPoints() > 0;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }
}

