/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.entities;

import com.raz.howlingmoon.HMPotions;
import com.raz.howlingmoon.IWerewolfCapability;
import com.raz.howlingmoon.WereEventHandler;
import com.raz.howlingmoon.ai.EntityAIAttackWerewolf;
import com.raz.howlingmoon.ai.EntityAIHunterRanged;
import com.raz.howlingmoon.entities.EntityWere;
import com.raz.howlingmoon.entities.EntityWerewolf;
import com.raz.howlingmoon.items.HMItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityHunter
extends EntityCreature
implements IRangedAttackMob {
    private static final DataParameter<Integer> HUNTER_TYPE = EntityDataManager.func_187226_a(EntityHunter.class, (DataSerializer)DataSerializers.field_187192_b);
    private final EntityAIHunterRanged aiArrowAttack = new EntityAIHunterRanged(this, 1.0, 20, 15.0f);
    private final EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.2, false);

    public EntityHunter(World worldIn) {
        super(worldIn);
        this.setCombatTask();
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HUNTER_TYPE, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        Random rnd = new Random();
        this.field_70180_af.func_187227_b(HUNTER_TYPE, (Object)rnd.nextInt(2));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("HUNTER_TYPE", ((Integer)this.func_184212_Q().func_187225_a(HUNTER_TYPE)).intValue());
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.field_70180_af.func_187227_b(HUNTER_TYPE, (Object)tagCompound.func_74762_e("HUNTER_TYPE"));
        this.setCombatTask();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWerewolf.class, true));
        this.field_70715_bh.func_75776_a(2, new EntityAIAttackWerewolf<EntityPlayer>(this, EntityPlayer.class, true));
    }

    protected void clearAITasks() {
        this.field_70714_bg.field_75782_a.clear();
        this.field_70715_bh.field_75782_a.clear();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
                if (((IWerewolfCapability)((EntityPlayer)entityIn).getCapability(WereEventHandler.WERE_CAP, null)).isWerewolf() && this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    ((EntityPlayer)entityIn).func_70690_d(new PotionEffect((Potion)HMPotions.WOLFSBANE, 200, 0, false, true));
                }
            } else if (entityIn instanceof EntityWere && this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                ((EntityWere)entityIn).func_70690_d(new PotionEffect((Potion)HMPotions.WOLFSBANE, 200, 0, false, true));
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean func_70601_bi() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && (this.field_70163_u > 60.0 || this.field_70170_p.func_175678_i(blockpos)) && super.func_70601_bi();
    }

    protected boolean func_146066_aG() {
        return true;
    }

    protected boolean func_70692_ba() {
        return this.field_70173_aa > 5000;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if ((Integer)this.field_70180_af.func_187225_a(HUNTER_TYPE) == 0) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)HMItems.silverSword));
            Random rand = new Random();
            if (rand.nextBoolean()) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack((Item)HMItems.moonstone));
            }
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
            this.func_180481_a(difficulty);
            this.func_180483_b(difficulty);
        }
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficulty.func_180170_c());
        return livingdata;
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            ItemStack itemstack = this.func_184614_ca();
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151031_f) {
                int i = 20;
                if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD) {
                    i = 40;
                }
                this.aiArrowAttack.setAttackCooldown(i);
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
            }
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityArrow entityarrow = this.getArrow(distanceFactor);
        if (target instanceof EntityPlayer && ((IWerewolfCapability)((EntityPlayer)target).getCapability(WereEventHandler.WERE_CAP, null)).isWerewolf()) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + 2.0);
        }
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    protected EntityArrow getArrow(float p_190726_1_) {
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        entitytippedarrow.func_190547_a((EntityLivingBase)this, p_190726_1_);
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
            entitytippedarrow.func_184558_a(new PotionEffect((Potion)HMPotions.WOLFSBANE, 200));
        }
        return entitytippedarrow;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (!this.func_184592_cb().func_190926_b() && this.func_184592_cb().func_77973_b() == HMItems.moonstone) {
            this.func_145779_a(HMItems.moonstone, 1);
        }
    }
}

