/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon;

import com.google.common.collect.Sets;
import com.raz.howlingmoon.IWerewolfCapability;
import com.raz.howlingmoon.WereEventHandler;
import com.raz.howlingmoon.WereLevelCommand;
import com.raz.howlingmoon.WereProgressCommand;
import com.raz.howlingmoon.WerewolfCapability;
import com.raz.howlingmoon.WerewolfClientEventHandler;
import com.raz.howlingmoon.WerewolfCommand;
import com.raz.howlingmoon.WerewolfStorage;
import com.raz.howlingmoon.WorldGenWolf;
import com.raz.howlingmoon.blocks.HMBlocks;
import com.raz.howlingmoon.client.CustomWerewolfResourcePack;
import com.raz.howlingmoon.client.CustomWerewolfTextures;
import com.raz.howlingmoon.client.FXScent;
import com.raz.howlingmoon.client.FXSparkle;
import com.raz.howlingmoon.client.KeyBindings;
import com.raz.howlingmoon.client.KeyHandler;
import com.raz.howlingmoon.client.ParticleHandler;
import com.raz.howlingmoon.client.RenderHunter;
import com.raz.howlingmoon.client.RenderStun;
import com.raz.howlingmoon.client.RenderWerewolf;
import com.raz.howlingmoon.client.RenderWerewolfGuide;
import com.raz.howlingmoon.client.RenderWolfGuide;
import com.raz.howlingmoon.client.RenderWolfSpirit;
import com.raz.howlingmoon.client.gui.GuiBeastPulse;
import com.raz.howlingmoon.dimension.HMDimension;
import com.raz.howlingmoon.entities.EntityCarry;
import com.raz.howlingmoon.entities.EntityHunter;
import com.raz.howlingmoon.entities.EntityStun;
import com.raz.howlingmoon.entities.EntityWerewolf;
import com.raz.howlingmoon.entities.EntityWerewolfGuide;
import com.raz.howlingmoon.entities.EntityWolfGuide;
import com.raz.howlingmoon.entities.EntityWolfSpirit;
import com.raz.howlingmoon.entities.TileEntityHunterBanner;
import com.raz.howlingmoon.handler.ConfigHandler;
import com.raz.howlingmoon.handler.GuiHandler;
import com.raz.howlingmoon.handler.WerewolfTick;
import com.raz.howlingmoon.items.HMItems;
import com.raz.howlingmoon.packets.PacketDispatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="howlingmoon", name="Howling Moon", version="0.9", acceptedMinecraftVersions="[1.12.2]")
public class HowlingMoon {
    @Mod.Instance(value="howlingmoon")
    public static HowlingMoon instance;
    @SidedProxy
    public static CommonProxy proxy;
    public static final int GUI = 0;
    public static final int GUISKILL = 1;
    public static final int GUISCENT = 2;
    public static final int GUIBOOK = 3;
    public static final int GUITAME = 4;
    public static final int GUIWMERCHANT = 5;
    public static Set<Item> silverTools;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenWolf(), (int)5);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        OreDictionary.registerOre((String)"oreSilver", (ItemStack)new ItemStack((Block)HMBlocks.silverOre));
        OreDictionary.registerOre((String)"ingotSilver", (ItemStack)new ItemStack(HMItems.silverIngot));
        BrewingRecipeRegistry.addRecipe((ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn, 1), (PotionType)PotionTypes.field_185233_e), (ItemStack)new ItemStack((Block)HMBlocks.wolfsbane, 1), (ItemStack)new ItemStack(HMItems.potionWolfsbane));
        GameRegistry.addSmelting((Block)HMBlocks.silverOre, (ItemStack)new ItemStack(HMItems.silverIngot), (float)1.0f);
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        for (IRecipe irecipe : CraftingManager.field_193380_a) {
            if (!(irecipe instanceof ShapelessOreRecipe) && !(irecipe instanceof ShapedOreRecipe) || !proxy.hasSilver(irecipe)) continue;
            silverTools.add(irecipe.func_77571_b().func_77973_b());
        }
        Collection biomes = ForgeRegistries.BIOMES.getValuesCollection();
        ArrayList<Biome> forest = new ArrayList<Biome>();
        for (Biome b : biomes) {
            if (!BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) continue;
            forest.add(b);
        }
        Biome.SpawnListEntry werewolfSpawn = new Biome.SpawnListEntry(EntityWerewolf.class, 25, 1, 2);
        Biome.SpawnListEntry hunterSpawn = new Biome.SpawnListEntry(EntityHunter.class, 10, 1, 2);
        Biome.SpawnListEntry hunterSpawnDay = new Biome.SpawnListEntry(EntityHunter.class, 1, 1, 3);
        for (Biome b : forest) {
            b.func_76747_a(EnumCreatureType.MONSTER).add(werewolfSpawn);
            b.func_76747_a(EnumCreatureType.MONSTER).add(hunterSpawn);
            b.func_76747_a(EnumCreatureType.CREATURE).add(hunterSpawnDay);
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new WerewolfCommand());
        event.registerServerCommand((ICommand)new WereLevelCommand());
        event.registerServerCommand((ICommand)new WereProgressCommand());
    }

    static {
        silverTools = Sets.newHashSet((Object[])new Item[0]);
    }

    public static class ServerProxy
    extends CommonProxy {
    }

    public static class ClientProxy
    extends CommonProxy {
        @Override
        public void preInit(FMLPreInitializationEvent event) {
            super.preInit(event);
            CustomWerewolfTextures.setCacheFile(new File(Minecraft.func_71410_x().field_71412_D, "config/HowlingMoonTextures"));
            MinecraftForge.EVENT_BUS.register((Object)new WerewolfClientEventHandler());
            MinecraftForge.EVENT_BUS.register((Object)new GuiBeastPulse(Minecraft.func_71410_x()));
            RenderingRegistry.registerEntityRenderingHandler(EntityWerewolf.class, (IRenderFactory)new IRenderFactory<EntityWerewolf>(){

                public Render<? super EntityWerewolf> createRenderFor(RenderManager manager) {
                    return new RenderWerewolf(manager);
                }
            });
            RenderingRegistry.registerEntityRenderingHandler(EntityHunter.class, (IRenderFactory)new IRenderFactory<EntityHunter>(){

                public Render<? super EntityHunter> createRenderFor(RenderManager manager) {
                    return new RenderHunter(manager);
                }
            });
            RenderingRegistry.registerEntityRenderingHandler(EntityStun.class, (IRenderFactory)new IRenderFactory<EntityStun>(){

                public Render<? super EntityStun> createRenderFor(RenderManager manager) {
                    return new RenderStun(manager);
                }
            });
            RenderingRegistry.registerEntityRenderingHandler(EntityWerewolfGuide.class, (IRenderFactory)new IRenderFactory<EntityWerewolfGuide>(){

                public Render<? super EntityWerewolfGuide> createRenderFor(RenderManager manager) {
                    return new RenderWerewolfGuide(manager);
                }
            });
            RenderingRegistry.registerEntityRenderingHandler(EntityWolfGuide.class, (IRenderFactory)new IRenderFactory<EntityWolfGuide>(){

                public Render<? super EntityWolfGuide> createRenderFor(RenderManager manager) {
                    return new RenderWolfGuide(manager);
                }
            });
            RenderingRegistry.registerEntityRenderingHandler(EntityWolfSpirit.class, (IRenderFactory)new IRenderFactory<EntityWolfSpirit>(){

                public Render<? super EntityWolfSpirit> createRenderFor(RenderManager manager) {
                    return new RenderWolfSpirit(manager);
                }
            });
        }

        @Override
        public void init(FMLInitializationEvent event) {
            super.init(event);
            List defaultResourcePacks = (List)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao"});
            defaultResourcePacks.add(new CustomWerewolfResourcePack());
            MinecraftForge.EVENT_BUS.register((Object)new KeyHandler());
            MinecraftForge.EVENT_BUS.register(ParticleHandler.class);
            ClientRegistry.registerKeyBinding((KeyBinding)KeyBindings.menu);
            ClientRegistry.registerKeyBinding((KeyBinding)KeyBindings.transform);
            ClientRegistry.registerKeyBinding((KeyBinding)KeyBindings.ability1);
            ClientRegistry.registerKeyBinding((KeyBinding)KeyBindings.ability2);
        }

        @Override
        public void postInit(FMLPostInitializationEvent event) {
            super.postInit(event);
        }

        @Override
        public void registerItemRenderer(Item item, int meta, String id) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), id));
        }

        @Override
        public World getClientWorld() {
            return FMLClientHandler.instance().getClient().field_71441_e;
        }

        @Override
        public EntityPlayer getPlayerEntity(MessageContext ctx) {
            return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
        }

        @Override
        public void generateScentParticles(Entity theEntity, int color) {
            float r = color >> 16 & 0xFF;
            float g = color >> 8 & 0xFF;
            float b = color >> 0 & 0xFF;
            this.generateScentParticles(theEntity, r / 255.0f, g / 255.0f, b / 255.0f);
        }

        @Override
        public void generateScentParticles(Entity theEntity, float red, float green, float blue) {
            double motionX = theEntity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double motionY = theEntity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double motionZ = theEntity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            FXScent scent = new FXScent(theEntity.field_70170_p, theEntity.field_70165_t + (double)(theEntity.field_70170_p.field_73012_v.nextFloat() * theEntity.field_70130_N * 2.0f) - (double)theEntity.field_70130_N, theEntity.field_70163_u + (double)(theEntity.field_70170_p.field_73012_v.nextFloat() * theEntity.field_70131_O), theEntity.field_70161_v + (double)(theEntity.field_70170_p.field_73012_v.nextFloat() * theEntity.field_70130_N * 2.0f) - (double)theEntity.field_70130_N, red, green, blue, motionX, motionY, motionZ);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)scent);
        }

        @Override
        public void generateMoonPearlParticles(double x, double y, double z, float r, float g, float b, float size, float motionx, float motiony, float motionz, int maxAge) {
            FXSparkle wisp = new FXSparkle((World)Minecraft.func_71410_x().field_71441_e, x, y, z, size, r, g, b, maxAge);
            wisp.setSpeed(motionx, motiony, motionz);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)wisp);
        }
    }

    public static class CommonProxy {
        public void registerRenderers() {
        }

        public EntityPlayer getPlayerEntity(MessageContext ctx) {
            return ctx.getServerHandler().field_147369_b;
        }

        public void preInit(FMLPreInitializationEvent event) {
            MinecraftForge.EVENT_BUS.register((Object)new WereEventHandler());
            MinecraftForge.EVENT_BUS.register((Object)new WerewolfTick());
            MinecraftForge.EVENT_BUS.register((Object)new ConfigHandler());
            this.registerEntities();
            HMDimension.init();
            PacketDispatcher.registerPackets();
        }

        public void init(FMLInitializationEvent event) {
            CapabilityManager.INSTANCE.register(IWerewolfCapability.class, (Capability.IStorage)new WerewolfStorage(), WerewolfCapability::new);
        }

        public void postInit(FMLPostInitializationEvent event) {
        }

        public void registerItemRenderer(Item item, int meta, String id) {
        }

        public boolean hasSilver(IRecipe irecipe) {
            for (Ingredient stack : irecipe.func_192400_c()) {
                if (stack == null) continue;
                for (ItemStack item : stack.func_193365_a()) {
                    if (!OreDictionary.getOres((String)"ingotSilver").contains((Object)item)) continue;
                    return true;
                }
            }
            return false;
        }

        public void registerEntities() {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("howlingmoon", "EntityWerewolf"), EntityWerewolf.class, (String)"Werewolf", (int)0, (Object)instance, (int)80, (int)3, (boolean)true, (int)0xE2E2E2, (int)10420283);
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("howlingmoon", "EntityHunter"), EntityHunter.class, (String)"Hunter", (int)1, (Object)instance, (int)80, (int)3, (boolean)true, (int)0xE2E2E2, (int)10420283);
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("howlingmoon", "EntityCarry"), EntityCarry.class, (String)"carry", (int)3, (Object)instance, (int)80, (int)3, (boolean)true);
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("howlingmoon", "EntityStun"), EntityStun.class, (String)"stun", (int)4, (Object)instance, (int)80, (int)3, (boolean)true);
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("howlingmoon", "EntityWerewolfGuide"), EntityWerewolfGuide.class, (String)"Werewolf Guide", (int)5, (Object)instance, (int)80, (int)3, (boolean)true);
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("howlingmoon", "EntityWolfGuide"), EntityWolfGuide.class, (String)"Wolf Guide", (int)6, (Object)instance, (int)80, (int)3, (boolean)true);
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("howlingmoon", "EntityWolfSpirit"), EntityWolfSpirit.class, (String)"Wolf Spirit", (int)7, (Object)instance, (int)80, (int)3, (boolean)true);
            GameRegistry.registerTileEntity(TileEntityHunterBanner.class, (String)"howlingmoon:hunter_banner");
        }

        public World getClientWorld() {
            return null;
        }

        public void generateScentParticles(Entity theEntity, int color) {
        }

        public void generateScentParticles(Entity theEntity, float red, float green, float blue) {
        }

        public void generateMoonPearlParticles(double x, double y, double z, float r, float g, float b, float size) {
            this.generateMoonPearlParticles(x, y, z, r, g, b, size, 5);
        }

        public void generateMoonPearlParticles(double x, double y, double z, float r, float g, float b, float size, int maxAge) {
            this.generateMoonPearlParticles(x, y, z, r, g, b, size, 0.0f, 0.0f, 0.0f, maxAge);
        }

        public void generateMoonPearlParticles(double x, double y, double z, float r, float g, float b, float size, float motionx, float motiony, float motionz, int maxAge) {
        }
    }
}

