/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon;

import com.google.common.collect.Lists;
import com.raz.howlingmoon.blocks.HMBlocks;
import com.raz.howlingmoon.handler.ConfigHandler;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenWolf
implements IWorldGenerator {
    private final WorldGenBush gen_wolfsbane = new WorldGenBush((BlockBush)HMBlocks.wolfsbane);
    private final WorldGenMinable gen_silverOre = new WorldGenMinable(HMBlocks.silverOre.func_176223_P(), 4);
    protected StructureBoundingBox boundingBox;
    private List<Village> villageLodge = Lists.newArrayList();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.runGenerator((WorldGenerator)this.gen_wolfsbane, world, random, chunkX, chunkZ, 1, 1, 255);
                if (ConfigHandler.spawnSilverOre) {
                    this.runGeneratorOre((WorldGenerator)this.gen_silverOre, world, random, chunkX, chunkZ, 6, 0, 40);
                }
                this.runGeneratorLodge(world, random, chunkX, chunkZ, 1);
                break;
            }
            case -1: {
                break;
            }
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16) + 8;
            int z = chunk_Z * 16 + rand.nextInt(16) + 8;
            int y = minHeight + rand.nextInt(heightDiff);
            BlockPos blockPos = new BlockPos(x, y, z);
            generator.func_180709_b(world, rand, blockPos);
        }
    }

    private void runGeneratorOre(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int z = chunk_Z * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            BlockPos blockPos = new BlockPos(x, y, z);
            generator.func_180709_b(world, rand, blockPos);
        }
    }

    private void runGeneratorLodge(World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn) {
        Village village;
        BlockPos blockPos2;
        int x = chunk_X * 16 + 2;
        int z = chunk_Z * 16 + 2;
        int y = 64;
        BlockPos blockPos = new BlockPos(x, y, z);
        y = world.func_175672_r(blockPos).func_177956_o();
        if (!world.func_180495_p(blockPos = new BlockPos(x, y, z)).func_177230_c().equals(Blocks.field_150355_j) && (world.func_180495_p(blockPos2 = new BlockPos(x, y - 1, z)).func_177230_c().equals(Blocks.field_150349_c) || world.func_180495_p(blockPos2).func_177230_c().equals(Blocks.field_150354_m)) && (village = world.func_175714_ae().func_176056_a(blockPos, 20)) != null && !this.villageLodge.contains(village)) {
            blockPos2 = new BlockPos(x + 11, y, z + 8);
            this.boundingBox = new StructureBoundingBox(new int[]{x, y - 5, z, x + 22, y + 5, z + 17});
            y = this.getAverageGroundLevel(world, this.boundingBox);
            if (y > 0) {
                blockPos = new BlockPos(x, y, z);
                this.villageLodge.add(village);
                this.spawnHunterLodge(world, blockPos);
            }
        }
    }

    private void spawnHunterLodge(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            ResourceLocation loc;
            WorldServer worldserver = (WorldServer)world;
            MinecraftServer minecraftserver = world.func_73046_m();
            TemplateManager templatemanager = worldserver.func_184163_y();
            Template template = templatemanager.func_186237_a(minecraftserver, loc = new ResourceLocation("howlingmoon", "hunter_lodge"));
            if (template != null) {
                IBlockState iblockstate = world.func_180495_p(pos);
                world.func_184138_a(pos, iblockstate, iblockstate, 3);
                PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null).func_186225_a((Block)null).func_186226_b(false);
                template.func_186253_b(world, pos, placementsettings);
            }
        }
    }

    protected int getAverageGroundLevel(World world, StructureBoundingBox box) {
        int i = 0;
        int j = 0;
        for (int k = box.field_78896_c; k <= box.field_78892_f; ++k) {
            for (int l = box.field_78897_a; l <= box.field_78893_d; ++l) {
                BlockPos blockpos = new BlockPos(l, 64, k);
                blockpos = world.func_175672_r(blockpos);
                while (blockpos.func_177956_o() > world.field_73011_w.func_76557_i() - 1) {
                    if (world.func_180495_p(blockpos).func_177230_c() instanceof BlockAir || world.func_180495_p(blockpos).func_177230_c() instanceof BlockLeaves || world.func_180495_p(blockpos).func_177230_c() instanceof BlockLog || world.func_180495_p(blockpos).func_177230_c() instanceof BlockFlower) {
                        blockpos = new BlockPos(blockpos.func_177958_n(), blockpos.func_177956_o() - 1, blockpos.func_177952_p());
                        continue;
                    }
                    if (!(world.func_180495_p(blockpos).func_177230_c() instanceof BlockPlanks) && !(world.func_180495_p(blockpos).func_177230_c() instanceof BlockStairs) && !world.func_180495_p(blockpos).func_177230_c().equals(Blocks.field_150347_e)) break;
                    return -1;
                }
                i += Math.max(blockpos.func_177956_o() + 1, world.field_73011_w.func_76557_i() - 1);
                ++j;
            }
        }
        if (j == 0) {
            return -1;
        }
        return i / j;
    }
}

