/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.ai;

import com.raz.howlingmoon.entities.EntityHunter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.Village;

public class EntityAIMoveAroundLodge
extends EntityAIBase {
    private final EntityHunter hunter;
    private double movePosX;
    private double movePosY;
    private double movePosZ;
    private final double movementSpeed;
    protected int executionChance;
    private boolean ignoreVillage;

    public EntityAIMoveAroundLodge(EntityHunter creatureIn, double speedIn, boolean ignore) {
        this(creatureIn, speedIn, 120, ignore);
    }

    public EntityAIMoveAroundLodge(EntityHunter creatureIn, double speedIn, int chance, boolean ignore) {
        this.hunter = creatureIn;
        this.movementSpeed = speedIn;
        this.executionChance = chance;
        this.ignoreVillage = ignore;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.hunter.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        Village village = this.hunter.field_70170_p.func_175714_ae().func_176056_a(new BlockPos((Entity)this.hunter), 0);
        if (!this.ignoreVillage && !this.hunter.field_70170_p.func_72935_r() && village != null) {
            return false;
        }
        boolean lodge = this.getIsNearRadius(3);
        if (!lodge) {
            return false;
        }
        Vec3d vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.hunter, (int)10, (int)8, (Vec3d)new Vec3d((double)this.hunter.getSpawn().func_177958_n() + 0.5, (double)this.hunter.getSpawn().func_177956_o() + 1.0, (double)this.hunter.getSpawn().func_177952_p() + 0.5));
        if (vec3d == null) {
            return false;
        }
        this.movePosX = vec3d.field_72450_a;
        this.movePosY = vec3d.field_72448_b;
        this.movePosZ = vec3d.field_72449_c;
        return true;
    }

    public boolean func_75253_b() {
        return !this.hunter.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.hunter.func_70661_as().func_75492_a(this.movePosX, this.movePosY, this.movePosZ, this.movementSpeed);
    }

    public boolean getIsNearRadius(int radius) {
        float f;
        double d1 = this.hunter.distanceFromSpawn();
        return d1 <= (double)((f = (float)(radius + 9)) * f);
    }
}

