/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.ai;

import com.raz.howlingmoon.entities.EntityHunter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.Village;

public class EntityAIMoveToLodge
extends EntityAIBase {
    private final EntityHunter hunter;
    private double movePosX;
    private double movePosY;
    private double movePosZ;
    private final double movementSpeed;
    protected int executionChance;
    protected BlockPos destinationBlock = BlockPos.field_177992_a;
    private int timeoutCounter;
    private int maxStayTicks;
    private boolean vec;

    public EntityAIMoveToLodge(EntityHunter creatureIn, double speedIn) {
        this(creatureIn, speedIn, 30);
    }

    public EntityAIMoveToLodge(EntityHunter creatureIn, double speedIn, int chance) {
        this.hunter = creatureIn;
        this.movementSpeed = speedIn;
        this.executionChance = chance;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.hunter.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        Village village = this.hunter.field_70170_p.func_175714_ae().func_176056_a(new BlockPos((Entity)this.hunter), 1);
        if (this.hunter.field_70170_p.func_72935_r() || village == null) {
            boolean atLodge = this.getIsNearRadius(3);
            if (!atLodge) {
                return false;
            }
            boolean lodge = this.getIsNearRadius(71);
            if (!lodge) {
                return false;
            }
            this.destinationBlock = new BlockPos((double)this.hunter.getSpawn().func_177958_n() + 0.5, (double)this.hunter.getSpawn().func_177956_o() + 1.0, (double)this.hunter.getSpawn().func_177952_p() + 0.5);
            Vec3d vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.hunter, (int)10, (int)8, (Vec3d)new Vec3d((double)this.hunter.getSpawn().func_177958_n() + 0.5, (double)this.hunter.getSpawn().func_177956_o() + 1.0, (double)this.hunter.getSpawn().func_177952_p() + 0.5));
            if (vec3d == null) {
                this.vec = false;
            } else {
                this.movePosX = vec3d.field_72450_a;
                this.movePosY = vec3d.field_72448_b;
                this.movePosZ = vec3d.field_72449_c;
                this.vec = true;
            }
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.hunter.func_70661_as().func_75500_f() && this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200;
    }

    public void func_75249_e() {
        if (!this.hunter.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed) && this.vec) {
            this.hunter.func_70661_as().func_75492_a(this.movePosX, this.movePosY, this.movePosZ, this.movementSpeed);
        }
        this.timeoutCounter = 0;
        this.maxStayTicks = this.hunter.func_70681_au().nextInt(this.hunter.func_70681_au().nextInt(1200) + 1200) + 1200;
    }

    public void func_75246_d() {
        if (this.hunter.func_174831_c(this.destinationBlock.func_177984_a()) > 1.0) {
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.hunter.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
            }
        } else {
            --this.timeoutCounter;
        }
    }

    public boolean getIsNearRadius(int radius) {
        float f;
        double d1 = this.hunter.distanceFromSpawn();
        return d1 <= (double)((f = (float)(radius + 9)) * f);
    }
}

