/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.client;

import com.google.common.base.MoreObjects;
import com.raz.howlingmoon.IWerewolfCapability;
import com.raz.howlingmoon.WereEventHandler;
import com.raz.howlingmoon.client.CustomWerewolfTextures;
import com.raz.howlingmoon.client.RenderWerewolfPlayer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ItemRendererWerewolf {
    private static final ResourceLocation wolfTexture = new ResourceLocation("howlingmoon:textures/mob/werewolf_white.png");
    private static final ResourceLocation textureBlack = new ResourceLocation("howlingmoon:textures/mob/werewolf_black.png");
    private static final ResourceLocation textureTimber = new ResourceLocation("howlingmoon:textures/mob/werewolf_timber.png");
    private static final ResourceLocation textureKillerwolf = new ResourceLocation("howlingmoon:textures/mob/werewolf_killerwolf.png");
    private static final ResourceLocation RES_MAP_BACKGROUND = new ResourceLocation("textures/map/map_background.png");
    private static final ResourceLocation RES_UNDERWATER_OVERLAY = new ResourceLocation("textures/misc/underwater.png");
    private final Minecraft mc;
    private ItemStack itemStackMainHand = ItemStack.field_190927_a;
    private ItemStack itemStackOffHand = ItemStack.field_190927_a;
    private float equippedProgressMainHand;
    private float prevEquippedProgressMainHand;
    private float equippedProgressOffHand;
    private float prevEquippedProgressOffHand;
    private RenderManager renderManager;
    private RenderItem itemRenderer;
    private RenderWerewolfPlayer renderHand;

    public ItemRendererWerewolf(Minecraft mcIn) {
        this.mc = mcIn;
        this.renderManager = mcIn.func_175598_ae();
        this.itemRenderer = mcIn.func_175599_af();
    }

    public void renderItem(EntityLivingBase entityIn, ItemStack heldStack, ItemCameraTransforms.TransformType transform) {
        this.renderItemSide(entityIn, heldStack, transform, false);
    }

    public void renderItemSide(EntityLivingBase entitylivingbaseIn, ItemStack heldStack, ItemCameraTransforms.TransformType transform, boolean p_187462_4_) {
        if (heldStack != null) {
            boolean flag;
            Item item = heldStack.func_77973_b();
            Block block = Block.func_149634_a((Item)item);
            GlStateManager.func_179094_E();
            if (this.itemRenderer == null) {
                this.itemRenderer = Minecraft.func_71410_x().func_175599_af();
            }
            boolean bl = flag = this.itemRenderer.func_175050_a(heldStack) && this.isBlockTranslucent(block);
            if (flag) {
                GlStateManager.func_179132_a((boolean)false);
            }
            this.itemRenderer.func_184392_a(heldStack, entitylivingbaseIn, transform, p_187462_4_);
            if (flag) {
                GlStateManager.func_179132_a((boolean)true);
            }
            GlStateManager.func_179121_F();
        }
    }

    private boolean isBlockTranslucent(@Nullable Block blockIn) {
        return blockIn != null && blockIn.func_180664_k() == BlockRenderLayer.TRANSLUCENT;
    }

    private void rotateArroundXAndY(float angle, float angleY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private void setLightmap() {
        EntityPlayerSP abstractclientplayer = this.mc.field_71439_g;
        int i = this.mc.field_71441_e.func_175626_b(new BlockPos(abstractclientplayer.field_70165_t, abstractclientplayer.field_70163_u + (double)abstractclientplayer.func_70047_e(), abstractclientplayer.field_70161_v), 0);
        float f = i & 0xFFFF;
        float f1 = i >> 16;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)f, (float)f1);
    }

    private void rotateArm(float p_187458_1_) {
        EntityPlayerSP entityplayersp = this.mc.field_71439_g;
        float f = entityplayersp.field_71164_i + (entityplayersp.field_71155_g - entityplayersp.field_71164_i) * p_187458_1_;
        float f1 = entityplayersp.field_71163_h + (entityplayersp.field_71154_f - entityplayersp.field_71163_h) * p_187458_1_;
        GlStateManager.func_179114_b((float)((entityplayersp.field_70125_A - f) * 0.1f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((entityplayersp.field_70177_z - f1) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private float getMapAngleFromPitch(float pitch) {
        float f = 1.0f - pitch / 45.0f + 0.1f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f = -MathHelper.func_76134_b((float)(f * (float)Math.PI)) * 0.5f + 0.5f;
        return f;
    }

    private void renderArms() {
        if (!this.mc.field_71439_g.func_82150_aj()) {
            GlStateManager.func_179129_p();
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderArm(EnumHandSide.RIGHT);
            this.renderArm(EnumHandSide.LEFT);
            GlStateManager.func_179121_F();
            GlStateManager.func_179089_o();
        }
    }

    private void renderArm(EnumHandSide p_187455_1_) {
        this.mc.func_110434_K().func_110577_a(this.mc.field_71439_g.func_110306_p());
        Render render = this.renderManager.func_78713_a((Entity)this.mc.field_71439_g);
        RenderPlayer renderplayer = (RenderPlayer)render;
        GlStateManager.func_179094_E();
        float f = p_187455_1_ == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.func_179114_b((float)92.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * -41.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(f * 0.3f), (float)-1.1f, (float)0.45f);
        if (p_187455_1_ == EnumHandSide.RIGHT) {
            renderplayer.func_177138_b((AbstractClientPlayer)this.mc.field_71439_g);
        } else {
            renderplayer.func_177139_c((AbstractClientPlayer)this.mc.field_71439_g);
        }
        GlStateManager.func_179121_F();
    }

    private void renderMapFirstPersonSide(float p_187465_1_, EnumHandSide p_187465_2_, float p_187465_3_, ItemStack p_187465_4_) {
        float f = p_187465_2_ == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.func_179109_b((float)(f * 0.125f), (float)-0.125f, (float)0.0f);
        if (!this.mc.field_71439_g.func_82150_aj()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)(f * 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            this.renderArmFirstPerson(p_187465_1_, p_187465_3_, p_187465_2_);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(f * 0.51f), (float)(-0.08f + p_187465_1_ * -1.2f), (float)-0.75f);
        float f1 = MathHelper.func_76129_c((float)p_187465_3_);
        float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * MathHelper.func_76126_a((float)(p_187465_3_ * (float)Math.PI));
        GlStateManager.func_179109_b((float)(f * f3), (float)(f4 - 0.3f * f2), (float)f5);
        GlStateManager.func_179114_b((float)(f2 * -45.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * f2 * -30.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderMapFirstPerson(p_187465_4_);
        GlStateManager.func_179121_F();
    }

    private void renderMapFirstPerson(float p_187463_1_, float p_187463_2_, float p_187463_3_) {
        float f = MathHelper.func_76129_c((float)p_187463_3_);
        float f1 = -0.2f * MathHelper.func_76126_a((float)(p_187463_3_ * (float)Math.PI));
        float f2 = -0.4f * MathHelper.func_76126_a((float)(f * (float)Math.PI));
        GlStateManager.func_179109_b((float)0.0f, (float)(-f1 / 2.0f), (float)f2);
        float f3 = this.getMapAngleFromPitch(p_187463_1_);
        GlStateManager.func_179109_b((float)0.0f, (float)(0.04f + p_187463_2_ * -1.2f + f3 * -0.5f), (float)-0.72f);
        GlStateManager.func_179114_b((float)(f3 * -85.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderArms();
        float f4 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
        GlStateManager.func_179114_b((float)(f4 * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        this.renderMapFirstPerson(this.itemStackMainHand);
    }

    private void renderMapFirstPerson(ItemStack stack) {
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.38f, (float)0.38f, (float)0.38f);
        GlStateManager.func_179140_f();
        this.mc.func_110434_K().func_110577_a(RES_MAP_BACKGROUND);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(-7.0, 135.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b(135.0, 135.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b(135.0, -7.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b(-7.0, -7.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        MapData mapdata = Items.field_151098_aY.func_77873_a(stack, (World)this.mc.field_71441_e);
        if (mapdata != null) {
            this.mc.field_71460_t.func_147701_i().func_148250_a(mapdata, false);
        }
        GlStateManager.func_179145_e();
    }

    private void renderArmFirstPerson(float p_187456_1_, float p_187456_2_, EnumHandSide p_187456_3_) {
        boolean flag = p_187456_3_ != EnumHandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)p_187456_2_);
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(p_187456_2_ * (float)Math.PI));
        GlStateManager.func_179109_b((float)(f * (f2 + 0.64000005f)), (float)(f3 + -0.6f + p_187456_1_ * -0.6f), (float)(f4 + -0.71999997f));
        GlStateManager.func_179114_b((float)(f * 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float f5 = MathHelper.func_76126_a((float)(p_187456_2_ * p_187456_2_ * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        GlStateManager.func_179114_b((float)(f * f6 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * f5 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        EntityPlayerSP abstractclientplayer = this.mc.field_71439_g;
        this.mc.func_110434_K().func_110577_a(abstractclientplayer.func_110306_p());
        GlStateManager.func_179109_b((float)(f * -1.0f), (float)3.6f, (float)3.5f);
        GlStateManager.func_179114_b((float)(f * 120.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(f * 5.6f), (float)0.0f, (float)0.0f);
        int temp = ((IWerewolfCapability)abstractclientplayer.getCapability(WereEventHandler.WERE_CAP, null)).getTexture();
        switch (temp) {
            case 0: {
                this.mc.field_71446_o.func_110577_a(wolfTexture);
                break;
            }
            case 1: {
                this.mc.field_71446_o.func_110577_a(textureBlack);
                break;
            }
            case 2: {
                this.mc.field_71446_o.func_110577_a(textureTimber);
                break;
            }
            case 3: {
                this.mc.field_71446_o.func_110577_a(textureKillerwolf);
                break;
            }
            default: {
                if (CustomWerewolfTextures.textureCount >= temp - 3) {
                    this.mc.field_71446_o.func_110577_a(CustomWerewolfTextures.customTextures.get(temp - 4));
                    break;
                }
                this.mc.field_71446_o.func_110577_a(wolfTexture);
            }
        }
        if (this.renderManager == null) {
            this.renderManager = this.mc.func_175598_ae();
        }
        if (this.renderHand == null) {
            this.renderHand = new RenderWerewolfPlayer(Minecraft.func_71410_x().func_175598_ae());
        }
        RenderWerewolfPlayer renderplayer = this.renderHand;
        GlStateManager.func_179129_p();
        if (flag) {
            renderplayer.renderRightArm((AbstractClientPlayer)abstractclientplayer);
        } else {
            renderplayer.renderLeftArm((AbstractClientPlayer)abstractclientplayer);
        }
        GlStateManager.func_179089_o();
    }

    private void transformEatFirstPerson(float p_187454_1_, EnumHandSide p_187454_2_, ItemStack p_187454_3_) {
        float f = (float)this.mc.field_71439_g.func_184605_cv() - p_187454_1_ + 1.0f;
        float f1 = f / (float)p_187454_3_.func_77988_m();
        if (f1 < 0.8f) {
            float f2 = MathHelper.func_76135_e((float)(MathHelper.func_76134_b((float)(f / 4.0f * (float)Math.PI)) * 0.1f));
            GlStateManager.func_179109_b((float)0.0f, (float)f2, (float)0.0f);
        }
        float f3 = 1.0f - (float)Math.pow(f1, 27.0);
        int i = p_187454_2_ == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.func_179109_b((float)(f3 * 0.6f * (float)i), (float)(f3 * -0.5f), (float)(f3 * 0.0f));
        GlStateManager.func_179114_b((float)((float)i * f3 * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f3 * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)i * f3 * 30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void transformFirstPerson(EnumHandSide p_187453_1_, float p_187453_2_) {
        int i = p_187453_1_ == EnumHandSide.RIGHT ? 1 : -1;
        float f = MathHelper.func_76126_a((float)(p_187453_2_ * p_187453_2_ * (float)Math.PI));
        GlStateManager.func_179114_b((float)((float)i * (45.0f + f * -20.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)p_187453_2_) * (float)Math.PI));
        GlStateManager.func_179114_b((float)((float)i * f1 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(f1 * -80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)i * -45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void transformSideFirstPerson(EnumHandSide p_187459_1_, float p_187459_2_) {
        int i = p_187459_1_ == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.func_179109_b((float)((float)i * 0.56f), (float)(-0.52f + p_187459_2_ * -0.6f), (float)-0.72f);
    }

    public void renderItemInFirstPerson(float partialTicks) {
        ItemStack itemstack;
        EntityPlayerSP abstractclientplayer = this.mc.field_71439_g;
        float f = abstractclientplayer.func_70678_g(partialTicks);
        EnumHand enumhand = (EnumHand)MoreObjects.firstNonNull((Object)abstractclientplayer.field_184622_au, (Object)EnumHand.MAIN_HAND);
        float f1 = abstractclientplayer.field_70127_C + (abstractclientplayer.field_70125_A - abstractclientplayer.field_70127_C) * partialTicks;
        float f2 = abstractclientplayer.field_70126_B + (abstractclientplayer.field_70177_z - abstractclientplayer.field_70126_B) * partialTicks;
        boolean flag = true;
        boolean flag1 = true;
        if (abstractclientplayer.func_184587_cr() && (itemstack = abstractclientplayer.func_184607_cu()) != null && itemstack.func_77973_b() == Items.field_151031_f) {
            EnumHand enumhand1 = abstractclientplayer.func_184600_cs();
            flag = enumhand1 == EnumHand.MAIN_HAND;
            flag1 = !flag;
        }
        this.rotateArroundXAndY(f1, f2);
        this.setLightmap();
        this.rotateArm(partialTicks);
        GlStateManager.func_179091_B();
        if (flag) {
            float f3 = enumhand == EnumHand.MAIN_HAND ? f : 0.0f;
            float f5 = 1.0f - (this.prevEquippedProgressMainHand + (this.equippedProgressMainHand - this.prevEquippedProgressMainHand) * partialTicks);
            this.renderItemInFirstPerson((AbstractClientPlayer)abstractclientplayer, partialTicks, f1, EnumHand.MAIN_HAND, f3, this.itemStackMainHand, f5);
        }
        if (flag1) {
            float f4 = enumhand == EnumHand.OFF_HAND ? f : 0.0f;
            float f6 = 1.0f - (this.prevEquippedProgressOffHand + (this.equippedProgressOffHand - this.prevEquippedProgressOffHand) * partialTicks);
            this.renderItemInFirstPerson((AbstractClientPlayer)abstractclientplayer, partialTicks, f1, EnumHand.OFF_HAND, f4, this.itemStackOffHand, f6);
        }
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
    }

    public void renderItemInFirstPerson(AbstractClientPlayer p_187457_1_, float p_187457_2_, float p_187457_3_, EnumHand p_187457_4_, float p_187457_5_, ItemStack p_187457_6_, float p_187457_7_) {
        boolean flag = p_187457_4_ == EnumHand.MAIN_HAND;
        EnumHandSide enumhandside = flag ? p_187457_1_.func_184591_cq() : p_187457_1_.func_184591_cq().func_188468_a();
        GlStateManager.func_179094_E();
        if (p_187457_6_.func_190926_b()) {
            if (flag && !p_187457_1_.func_82150_aj()) {
                this.renderArmFirstPerson(p_187457_7_, p_187457_5_, enumhandside);
            }
        } else if (p_187457_6_.func_77973_b() instanceof ItemMap) {
            if (flag && this.itemStackOffHand.func_190926_b()) {
                this.renderMapFirstPerson(p_187457_3_, p_187457_7_, p_187457_5_);
            } else {
                this.renderMapFirstPersonSide(p_187457_7_, enumhandside, p_187457_5_, p_187457_6_);
            }
        } else {
            boolean flag1;
            boolean bl = flag1 = enumhandside == EnumHandSide.RIGHT;
            if (p_187457_1_.func_184587_cr() && p_187457_1_.func_184605_cv() > 0 && p_187457_1_.func_184600_cs() == p_187457_4_) {
                int j = flag1 ? 1 : -1;
                switch (p_187457_6_.func_77975_n()) {
                    case NONE: {
                        this.transformSideFirstPerson(enumhandside, p_187457_7_);
                        break;
                    }
                    case EAT: 
                    case DRINK: {
                        this.transformEatFirstPerson(p_187457_2_, enumhandside, p_187457_6_);
                        this.transformSideFirstPerson(enumhandside, p_187457_7_);
                        break;
                    }
                    case BLOCK: {
                        this.transformSideFirstPerson(enumhandside, p_187457_7_);
                        break;
                    }
                    case BOW: {
                        this.transformSideFirstPerson(enumhandside, p_187457_7_);
                        GlStateManager.func_179109_b((float)((float)j * -0.2785682f), (float)0.18344387f, (float)0.15731531f);
                        GlStateManager.func_179114_b((float)-13.935f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)((float)j * 35.3f), (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)((float)j * -9.785f), (float)0.0f, (float)0.0f, (float)1.0f);
                        float f5 = (float)p_187457_6_.func_77988_m() - ((float)this.mc.field_71439_g.func_184605_cv() - p_187457_2_ + 1.0f);
                        float f6 = f5 / 20.0f;
                        f6 = (f6 * f6 + f6 * 2.0f) / 3.0f;
                        if (f6 > 1.0f) {
                            f6 = 1.0f;
                        }
                        if (f6 > 0.1f) {
                            float f7 = MathHelper.func_76126_a((float)((f5 - 0.1f) * 1.3f));
                            float f3 = f6 - 0.1f;
                            float f4 = f7 * f3;
                            GlStateManager.func_179109_b((float)(f4 * 0.0f), (float)(f4 * 0.004f), (float)(f4 * 0.0f));
                        }
                        GlStateManager.func_179109_b((float)(f6 * 0.0f), (float)(f6 * 0.0f), (float)(f6 * 0.04f));
                        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)(1.0f + f6 * 0.2f));
                        GlStateManager.func_179114_b((float)((float)j * 45.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
                    }
                }
            } else {
                float f = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)p_187457_5_) * (float)Math.PI));
                float f1 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)p_187457_5_) * ((float)Math.PI * 2)));
                float f2 = -0.2f * MathHelper.func_76126_a((float)(p_187457_5_ * (float)Math.PI));
                int i = flag1 ? 1 : -1;
                GlStateManager.func_179109_b((float)((float)i * f), (float)f1, (float)f2);
                this.transformSideFirstPerson(enumhandside, p_187457_7_);
                this.transformFirstPerson(enumhandside, p_187457_5_);
            }
            this.renderItemSide((EntityLivingBase)p_187457_1_, p_187457_6_, flag1 ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !flag1);
        }
        GlStateManager.func_179121_F();
    }

    public void renderOverlays(float partialTicks) {
        GlStateManager.func_179118_c();
        if (this.mc.field_71439_g.func_70094_T()) {
            IBlockState iblockstate = this.mc.field_71441_e.func_180495_p(new BlockPos((Entity)this.mc.field_71439_g));
            BlockPos overlayPos = new BlockPos((Entity)this.mc.field_71439_g);
            EntityPlayerSP entityplayer = this.mc.field_71439_g;
            for (int i = 0; i < 8; ++i) {
                double d0 = entityplayer.field_70165_t + (double)(((float)((i >> 0) % 2) - 0.5f) * entityplayer.field_70130_N * 0.8f);
                double d1 = entityplayer.field_70163_u + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
                double d2 = entityplayer.field_70161_v + (double)(((float)((i >> 2) % 2) - 0.5f) * entityplayer.field_70130_N * 0.8f);
                BlockPos blockpos = new BlockPos(d0, d1 + (double)entityplayer.func_70047_e(), d2);
                IBlockState iblockstate1 = this.mc.field_71441_e.func_180495_p(blockpos);
                if (!iblockstate1.func_191058_s()) continue;
                iblockstate = iblockstate1;
                overlayPos = blockpos;
            }
            if (iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE && !ForgeEventFactory.renderBlockOverlay((EntityPlayer)this.mc.field_71439_g, (float)partialTicks, (RenderBlockOverlayEvent.OverlayType)RenderBlockOverlayEvent.OverlayType.BLOCK, (IBlockState)iblockstate, (BlockPos)overlayPos)) {
                this.renderBlockInHand(partialTicks, this.mc.func_175602_ab().func_175023_a().func_178122_a(iblockstate));
            }
        }
        if (!this.mc.field_71439_g.func_175149_v()) {
            if (this.mc.field_71439_g.func_70055_a(Material.field_151586_h) && !ForgeEventFactory.renderWaterOverlay((EntityPlayer)this.mc.field_71439_g, (float)partialTicks)) {
                this.renderWaterOverlayTexture(partialTicks);
            }
            if (this.mc.field_71439_g.func_70027_ad() && !ForgeEventFactory.renderFireOverlay((EntityPlayer)this.mc.field_71439_g, (float)partialTicks)) {
                this.renderFireInFirstPerson(partialTicks);
            }
        }
        GlStateManager.func_179141_d();
    }

    private void renderBlockInHand(float partialTicks, TextureAtlasSprite atlas) {
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        float f = 0.1f;
        GlStateManager.func_179131_c((float)0.1f, (float)0.1f, (float)0.1f, (float)0.5f);
        GlStateManager.func_179094_E();
        float f1 = -1.0f;
        float f2 = 1.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -0.5f;
        float f6 = atlas.func_94209_e();
        float f7 = atlas.func_94212_f();
        float f8 = atlas.func_94206_g();
        float f9 = atlas.func_94210_h();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)f7, (double)f9).func_181675_d();
        vertexbuffer.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)f6, (double)f9).func_181675_d();
        vertexbuffer.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)f6, (double)f8).func_181675_d();
        vertexbuffer.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)f7, (double)f8).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderWaterOverlayTexture(float partialTicks) {
        this.mc.func_110434_K().func_110577_a(RES_UNDERWATER_OVERLAY);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        float f = this.mc.field_71439_g.func_70013_c();
        GlStateManager.func_179131_c((float)f, (float)f, (float)f, (float)0.5f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        float f1 = 4.0f;
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = -this.mc.field_71439_g.field_70177_z / 64.0f;
        float f8 = this.mc.field_71439_g.field_70125_A / 64.0f;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(4.0f + f8)).func_181675_d();
        vertexbuffer.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(4.0f + f8)).func_181675_d();
        vertexbuffer.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(0.0f + f8)).func_181675_d();
        vertexbuffer.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(0.0f + f8)).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    private void renderFireInFirstPerson(float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        GlStateManager.func_179143_c((int)519);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float f = 1.0f;
        for (int i = 0; i < 2; ++i) {
            GlStateManager.func_179094_E();
            TextureAtlasSprite textureatlassprite = this.mc.func_147117_R().func_110572_b("minecraft:blocks/fire_layer_1");
            this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            float f1 = textureatlassprite.func_94209_e();
            float f2 = textureatlassprite.func_94212_f();
            float f3 = textureatlassprite.func_94206_g();
            float f4 = textureatlassprite.func_94210_h();
            float f5 = -0.5f;
            float f6 = 0.5f;
            float f7 = -0.5f;
            float f8 = 0.5f;
            float f9 = -0.5f;
            GlStateManager.func_179109_b((float)((float)(-(i * 2 - 1)) * 0.24f), (float)-0.3f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(i * 2 - 1) * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)f2, (double)f4).func_181675_d();
            vertexbuffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a((double)f1, (double)f4).func_181675_d();
            vertexbuffer.func_181662_b(0.5, 0.5, -0.5).func_187315_a((double)f1, (double)f3).func_181675_d();
            vertexbuffer.func_181662_b(-0.5, 0.5, -0.5).func_187315_a((double)f2, (double)f3).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)515);
    }

    public void updateEquippedItem() {
        this.prevEquippedProgressMainHand = this.equippedProgressMainHand;
        this.prevEquippedProgressOffHand = this.equippedProgressOffHand;
        EntityPlayerSP entityplayersp = this.mc.field_71439_g;
        ItemStack itemstack = entityplayersp.func_184614_ca();
        ItemStack itemstack1 = entityplayersp.func_184592_cb();
        if (entityplayersp.func_184838_M()) {
            this.equippedProgressMainHand = MathHelper.func_76131_a((float)(this.equippedProgressMainHand - 0.4f), (float)0.0f, (float)1.0f);
            this.equippedProgressOffHand = MathHelper.func_76131_a((float)(this.equippedProgressOffHand - 0.4f), (float)0.0f, (float)1.0f);
        } else {
            float f = entityplayersp.func_184825_o(1.0f);
            this.equippedProgressMainHand += MathHelper.func_76131_a((float)((!ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.itemStackMainHand, (ItemStack)itemstack, (int)entityplayersp.field_71071_by.field_70461_c) ? f * f * f : 0.0f) - this.equippedProgressMainHand), (float)-0.4f, (float)0.4f);
            this.equippedProgressOffHand += MathHelper.func_76131_a((float)((float)(!ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.itemStackOffHand, (ItemStack)itemstack1, (int)-1) ? 1 : 0) - this.equippedProgressOffHand), (float)-0.4f, (float)0.4f);
        }
        if (this.equippedProgressMainHand < 0.1f) {
            this.itemStackMainHand = itemstack;
        }
        if (this.equippedProgressOffHand < 0.1f) {
            this.itemStackOffHand = itemstack1;
        }
    }

    public void resetEquippedProgress(EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            this.equippedProgressMainHand = 0.0f;
        } else {
            this.equippedProgressOffHand = 0.0f;
        }
    }
}

