/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.entities;

import com.raz.howlingmoon.IWerewolfCapability;
import com.raz.howlingmoon.WereEventHandler;
import com.raz.howlingmoon.ai.EntityAIMoveToSpawn;
import com.raz.howlingmoon.handler.ConfigHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityWerewolfGuide
extends EntityCreature {
    private static final DataParameter<Integer> FUR_COLOR = EntityDataManager.func_187226_a(EntityWerewolfGuide.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(EntityWerewolfGuide.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> INCLINATION = EntityDataManager.func_187226_a(EntityWerewolfGuide.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MODEL = EntityDataManager.func_187226_a(EntityWerewolfGuide.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> PROMOTE = EntityDataManager.func_187226_a(EntityWerewolfGuide.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<BlockPos> SPAWN = EntityDataManager.func_187226_a(EntityWerewolfGuide.class, (DataSerializer)DataSerializers.field_187200_j);
    private long nextKeyTriggerTime = 0L;

    public EntityWerewolfGuide(World worldIn) {
        super(worldIn);
    }

    public EntityWerewolfGuide(World worldIn, int color, int level, int inclination, int model, boolean promote, BlockPos spawn) {
        super(worldIn);
        this.setFurColor(color);
        this.setLevel(level);
        this.setInclination(inclination);
        this.setModel(model);
        this.setPromote(promote);
        this.setSpawn(spawn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FUR_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(INCLINATION, (Object)0);
        this.field_70180_af.func_187214_a(MODEL, (Object)0);
        this.field_70180_af.func_187214_a(PROMOTE, (Object)false);
        this.field_70180_af.func_187214_a(SPAWN, (Object)BlockPos.field_177992_a);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveToSpawn(this, 2, 0.5, 81));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        IWerewolfCapability wolf = (IWerewolfCapability)player.getCapability(WereEventHandler.WERE_CAP, null);
        if (wolf.isWerewolf()) {
            if (wolf.getQuestsDone() == this.getLevel() - 1 && wolf.getQuestsDone() < wolf.getLevel() / 5 * 2) {
                wolf.setQuestsDone(this.getLevel());
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("guide.message.level" + this.getLevel(), new Object[0]));
                }
            }
            if (this.getPromote() && wolf.getInclinationType() != this.getInclination()) {
                wolf.setInclinationType(this.getInclination());
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("guide.message.inclination", new Object[]{wolf.getInclinationTitle()}));
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("FurColor", this.getFurColor());
        tagCompound.func_74768_a("Level", this.getLevel());
        tagCompound.func_74768_a("Model", this.getModel());
        tagCompound.func_74768_a("Inclination", this.getInclination());
        tagCompound.func_74757_a("Promote", this.getPromote());
        tagCompound.func_74768_a("XPos", this.getSpawn().func_177958_n());
        tagCompound.func_74768_a("YPos", this.getSpawn().func_177956_o());
        tagCompound.func_74768_a("ZPos", this.getSpawn().func_177952_p());
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setFurColor(tagCompound.func_74762_e("FurColor"));
        this.setLevel(tagCompound.func_74762_e("Level"));
        this.setModel(tagCompound.func_74762_e("Model"));
        this.setInclination(tagCompound.func_74762_e("Inclination"));
        this.setPromote(tagCompound.func_74767_n("Promote"));
        this.setSpawn(new BlockPos(tagCompound.func_74762_e("XPos"), tagCompound.func_74762_e("YPos"), tagCompound.func_74762_e("ZPos")));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_71093_bK != ConfigHandler.dimID) {
                this.func_70106_y();
            } else if (this.func_180425_c().func_177951_i((Vec3i)this.getSpawn()) > 36.0) {
                this.func_70012_b(this.getSpawn().func_177958_n(), (double)this.getSpawn().func_177956_o() + 0.1, this.getSpawn().func_177952_p(), 180.0f, 0.0f);
            }
        } else if (System.currentTimeMillis() >= this.nextKeyTriggerTime) {
            this.nextKeyTriggerTime = System.currentTimeMillis() + 10000L;
            this.field_70170_p.func_180500_c(EnumSkyBlock.BLOCK, this.func_180425_c());
            this.field_70170_p.func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v - 1.0));
            this.field_70170_p.func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v));
            this.field_70170_p.func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v - 1.0));
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public void setFurColor(int color) {
        this.field_70180_af.func_187227_b(FUR_COLOR, (Object)color);
    }

    public int getFurColor() {
        return (Integer)this.field_70180_af.func_187225_a(FUR_COLOR);
    }

    public void setLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)level);
    }

    public int getLevel() {
        return (Integer)this.field_70180_af.func_187225_a(LEVEL);
    }

    public void setModel(int model) {
        this.field_70180_af.func_187227_b(MODEL, (Object)model);
    }

    public int getModel() {
        return (Integer)this.field_70180_af.func_187225_a(MODEL);
    }

    public void setInclination(int inclination) {
        this.field_70180_af.func_187227_b(INCLINATION, (Object)inclination);
    }

    public int getInclination() {
        return (Integer)this.field_70180_af.func_187225_a(INCLINATION);
    }

    public void setPromote(boolean promote) {
        this.field_70180_af.func_187227_b(PROMOTE, (Object)promote);
    }

    public boolean getPromote() {
        return (Boolean)this.field_70180_af.func_187225_a(PROMOTE);
    }

    public void setSpawn(BlockPos spawn) {
        this.field_70180_af.func_187227_b(SPAWN, (Object)spawn);
    }

    public BlockPos getSpawn() {
        return (BlockPos)this.field_70180_af.func_187225_a(SPAWN);
    }
}

