/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.entities;

import com.google.common.base.Optional;
import com.raz.howlingmoon.ai.EntityAIFollowOwnerHM;
import com.raz.howlingmoon.ai.EntityAIOwnerHurtByTargetHM;
import com.raz.howlingmoon.ai.EntityAIOwnerHurtTargetHM;
import com.raz.howlingmoon.entities.EntityWerewolfGuide;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityWolfSpirit
extends EntityCreature
implements IEntityOwnable {
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityTameable.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> FUR_COLOR = EntityDataManager.func_187226_a(EntityWerewolfGuide.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(EntityWerewolfGuide.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> INCLINATION = EntityDataManager.func_187226_a(EntityWerewolfGuide.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityWolfSpirit(World worldIn) {
        super(worldIn);
    }

    public EntityWolfSpirit(World worldIn, EntityPlayer player, int color, int level, int inclination) {
        super(worldIn);
        this.setOwner(player);
        this.setFurColor(color);
        this.setLevel(level);
        this.setInclination(inclination);
        this.applyAdditionalAttributes();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(FUR_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(INCLINATION, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
    }

    protected void applyAdditionalAttributes() {
        if (this.getInclination() == 1) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(this.getLevel() / 2 + this.getLevel() / 4));
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(this.getLevel() / 2));
        }
        this.func_70606_j(this.func_110138_aP());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4 + (double)this.getLevel() / 100.0);
        if (this.getInclination() == -1) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0 + (double)(this.getLevel() / 2));
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)(this.getLevel() / 2));
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwnerHM(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTargetHM(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTargetHM(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 60 * this.getLevel()) {
            this.func_70106_y();
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("FurColor", this.getFurColor());
        tagCompound.func_74768_a("Level", this.getLevel());
        tagCompound.func_74768_a("Inclination", this.getInclination());
        if (this.func_184753_b() == null) {
            tagCompound.func_74778_a("OwnerUUID", "");
        } else {
            tagCompound.func_74778_a("OwnerUUID", this.func_184753_b().toString());
        }
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        String s;
        super.func_70037_a(tagCompound);
        this.setFurColor(tagCompound.func_74762_e("FurColor"));
        this.setLevel(tagCompound.func_74762_e("Level"));
        this.setInclination(tagCompound.func_74762_e("Inclination"));
        if (tagCompound.func_150297_b("OwnerUUID", 8)) {
            s = tagCompound.func_74779_i("OwnerUUID");
        } else {
            String s1 = tagCompound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setFurColor(int color) {
        this.field_70180_af.func_187227_b(FUR_COLOR, (Object)color);
    }

    public int getFurColor() {
        return (Integer)this.field_70180_af.func_187225_a(FUR_COLOR);
    }

    public void setLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)level);
    }

    public int getLevel() {
        return (Integer)this.field_70180_af.func_187225_a(LEVEL);
    }

    public void setInclination(int inclination) {
        this.field_70180_af.func_187227_b(INCLINATION, (Object)inclination);
    }

    public int getInclination() {
        return (Integer)this.field_70180_af.func_187225_a(INCLINATION);
    }

    public void setOwner(EntityPlayer player) {
        this.setOwnerId(player.func_110124_au());
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    @Nullable
    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.func_184753_b();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }
}

