/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.entities;

import com.raz.howlingmoon.entities.EntityHunter;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class TileEntityHunterBanner
extends TileEntity
implements ITickable {
    private int lodgeRadius = 36;
    private int tickCounter = 0;
    private int numHunters = 0;
    private boolean isGuild = true;

    public TileEntityHunterBanner() {
    }

    public TileEntityHunterBanner(BlockPos pos) {
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.isGuild) {
            Vec3d vec3d;
            ++this.tickCounter;
            if (this.tickCounter % 30 == 0) {
                this.updateNumHunters();
            }
            if (this.field_145850_b.func_72935_r() && this.numHunters < 3 && this.field_145850_b.field_73012_v.nextInt(7000) == 0 && (vec3d = this.findRandomSpawnPos(this.func_174877_v(), 2, 4, 2)) != null) {
                EntityHunter hunter = new EntityHunter(this.field_145850_b, true, this.func_174877_v());
                hunter.func_70107_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                hunter.func_180482_a(this.field_145850_b.func_175649_E(new BlockPos((Entity)hunter)), null);
                this.field_145850_b.func_72838_d((Entity)hunter);
                ++this.numHunters;
            }
        }
    }

    private void updateNumHunters() {
        List list = this.field_145850_b.func_72872_a(EntityHunter.class, new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - this.lodgeRadius), (double)(this.func_174877_v().func_177956_o() - 2), (double)(this.func_174877_v().func_177952_p() - this.lodgeRadius), (double)(this.func_174877_v().func_177958_n() + this.lodgeRadius), (double)(this.func_174877_v().func_177956_o() + 8), (double)(this.func_174877_v().func_177952_p() + this.lodgeRadius)));
        this.numHunters = list.size();
    }

    private Vec3d findRandomSpawnPos(BlockPos pos, int x, int y, int z) {
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos = pos.func_177982_a(this.field_145850_b.field_73012_v.nextInt(10) - 5, this.field_145850_b.field_73012_v.nextInt(6) - 3, this.field_145850_b.field_73012_v.nextInt(10) - 5);
            if (!this.isBlockPosWithinSqLodgeRadius(blockpos) || !this.isAreaClearAround(new BlockPos(x, y, z), blockpos)) continue;
            return new Vec3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
        }
        return null;
    }

    public boolean isBlockPosWithinSqLodgeRadius(BlockPos pos) {
        return this.func_174877_v().func_177951_i((Vec3i)pos) < (double)(this.lodgeRadius * this.lodgeRadius);
    }

    private boolean isAreaClearAround(BlockPos blockSize, BlockPos blockLocation) {
        if (!this.field_145850_b.func_180495_p(blockLocation.func_177977_b()).func_185896_q()) {
            return false;
        }
        int i = blockLocation.func_177958_n() - blockSize.func_177958_n() / 2;
        int j = blockLocation.func_177952_p() - blockSize.func_177952_p() / 2;
        for (int k = i; k < i + blockSize.func_177958_n(); ++k) {
            for (int l = blockLocation.func_177956_o(); l < blockLocation.func_177956_o() + blockSize.func_177956_o(); ++l) {
                for (int i1 = j; i1 < j + blockSize.func_177952_p(); ++i1) {
                    if (!this.field_145850_b.func_180495_p(new BlockPos(k, l, i1)).func_185915_l()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("Guild", this.isGuild);
        compound.func_74768_a("Radius", this.lodgeRadius);
        compound.func_74768_a("Hunters", this.numHunters);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.isGuild = compound.func_74767_n("Guild");
        this.lodgeRadius = compound.func_74762_e("Radius");
        this.numHunters = compound.func_74762_e("Hunters");
    }

    public int getLodgeRadius() {
        return this.lodgeRadius;
    }

    public int getNumHunters() {
        return this.numHunters;
    }

    public boolean isGuild() {
        return this.isGuild;
    }

    public void setIsGuild(boolean guild) {
        this.isGuild = guild;
    }
}

