/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon;

import com.raz.howlingmoon.WereVillage;
import com.raz.howlingmoon.WerewolfPlayer;
import com.raz.howlingmoon.packets.ClientPackInfo;
import com.raz.howlingmoon.packets.ClientPackNumbers;
import com.raz.howlingmoon.packets.PacketDispatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;

public class HowlingWorldData
extends WorldSavedData {
    static final String key = "howlingMoonData";
    public List<Integer> packID2 = new ArrayList<Integer>();
    public List<String> packName = new ArrayList<String>();
    public List<Integer> packNumbers = new ArrayList<Integer>();
    public List<Integer> packPlayerNumbers = new ArrayList<Integer>();
    public List villagePackList = new ArrayList();
    private int tickCounter;

    public HowlingWorldData() {
        super(key);
    }

    public HowlingWorldData(String name) {
        super(name);
    }

    public static HowlingWorldData forWorld(World world) {
        MapStorage storage = world.field_72988_C;
        HowlingWorldData result = (HowlingWorldData)storage.func_75742_a(HowlingWorldData.class, key);
        if (result == null) {
            result = new HowlingWorldData(key);
            storage.func_75745_a(key, (WorldSavedData)result);
        }
        if (!world.field_72995_K) {
            if (result.villagePackList.isEmpty()) {
                result.initVillagePacks(world);
            } else {
                result.resetWorlds(world);
            }
        }
        return result;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList tagListID = nbt.func_150295_c("PackID", 10);
        for (int i = 0; i < tagListID.func_74745_c(); ++i) {
            NBTTagCompound tag = tagListID.func_150305_b(i);
            int n = tag.func_74762_e("Pack" + i);
            this.packID2.add(i, n);
        }
        NBTTagList tagListName = nbt.func_150295_c("PackName", 10);
        for (int i = 0; i < tagListName.func_74745_c(); ++i) {
            NBTTagCompound tag = tagListName.func_150305_b(i);
            String s = tag.func_74779_i("PackN" + i);
            this.packName.add(i, s);
        }
        NBTTagList tagListNum = nbt.func_150295_c("PackNumbers", 10);
        for (int i = 0; i < tagListNum.func_74745_c(); ++i) {
            NBTTagCompound tag = tagListNum.func_150305_b(i);
            int n = tag.func_74762_e("PackNum" + i);
            this.packNumbers.add(i, n);
        }
        NBTTagList tagListPlayerNum = nbt.func_150295_c("PackPlayerNumbers", 10);
        for (int i = 0; i < tagListPlayerNum.func_74745_c(); ++i) {
            NBTTagCompound tag = tagListPlayerNum.func_150305_b(i);
            int n = tag.func_74762_e("PackPlayerNum" + i);
            this.packPlayerNumbers.add(i, n);
        }
        NBTTagList nbttaglist = nbt.func_150295_c("Villages", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            WereVillage village = new WereVillage();
            village.readWereVillageDataFromNBT(nbttagcompound1);
            this.villagePackList.add(village);
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        NBTTagCompound tag;
        NBTTagList tagListID = new NBTTagList();
        for (int i = 0; i < this.packID2.size(); ++i) {
            NBTTagCompound tag2 = new NBTTagCompound();
            tag2.func_74768_a("Pack" + i, this.packID2.get(i).intValue());
            tagListID.func_74742_a((NBTBase)tag2);
        }
        nbt.func_74782_a("PackID", (NBTBase)tagListID);
        NBTTagList tagListName = new NBTTagList();
        for (int i = 0; i < this.packName.size(); ++i) {
            String s = this.packName.get(i);
            if (s == null) continue;
            tag = new NBTTagCompound();
            tag.func_74778_a("PackN" + i, s);
            tagListName.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("PackName", (NBTBase)tagListName);
        NBTTagList tagListNum = new NBTTagList();
        for (int i = 0; i < this.packNumbers.size(); ++i) {
            tag = new NBTTagCompound();
            tag.func_74768_a("PackNum" + i, this.packNumbers.get(i).intValue());
            tagListNum.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("PackNumbers", (NBTBase)tagListNum);
        NBTTagList tagListPlayerNum = new NBTTagList();
        for (int i = 0; i < this.packPlayerNumbers.size(); ++i) {
            NBTTagCompound tag3 = new NBTTagCompound();
            tag3.func_74768_a("PackPlayerNum" + i, this.packPlayerNumbers.get(i).intValue());
            tagListPlayerNum.func_74742_a((NBTBase)tag3);
        }
        nbt.func_74782_a("PackPlayerNumbers", (NBTBase)tagListPlayerNum);
        NBTTagList nbttaglist = new NBTTagList();
        for (WereVillage village : this.villagePackList) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            village.writeWereVillageDataToNBT(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Villages", (NBTBase)nbttaglist);
    }

    public void readNumbers(NBTTagCompound nbt) {
        NBTTagList tagListNum = nbt.func_150295_c("PackNumbers", 10);
        for (int i = 0; i < tagListNum.func_74745_c(); ++i) {
            NBTTagCompound tag = tagListNum.func_150305_b(i);
            int n = tag.func_74762_e("PackNum" + i);
            this.packNumbers.add(i, n);
        }
        NBTTagList tagListPlayerNum = nbt.func_150295_c("PackPlayerNumbers", 10);
        for (int i = 0; i < tagListPlayerNum.func_74745_c(); ++i) {
            NBTTagCompound tag = tagListPlayerNum.func_150305_b(i);
            int n = tag.func_74762_e("PackPlayerNum" + i);
            this.packPlayerNumbers.add(i, n);
        }
    }

    public void writeNumbers(NBTTagCompound nbt) {
        NBTTagList tagListNum = new NBTTagList();
        for (int i = 0; i < this.packNumbers.size(); ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("PackNum" + i, this.packNumbers.get(i).intValue());
            tagListNum.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("PackNumbers", (NBTBase)tagListNum);
        NBTTagList tagListPlayerNum = new NBTTagList();
        for (int i = 0; i < this.packPlayerNumbers.size(); ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("PackPlayerNum" + i, this.packPlayerNumbers.get(i).intValue());
            tagListPlayerNum.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("PackPlayerNumbers", (NBTBase)tagListPlayerNum);
    }

    public void readVillages(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.func_150295_c("Villages", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            WereVillage village = new WereVillage();
            village.readWereVillageDataFromNBT(nbttagcompound1);
            this.villagePackList.add(village);
        }
    }

    public void writeVillages(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (WereVillage village : this.villagePackList) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            village.writeWereVillageDataToNBT(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Villages", (NBTBase)nbttaglist);
    }

    public void tick() {
        ++this.tickCounter;
        for (WereVillage village : this.villagePackList) {
            village.tick(this.tickCounter);
            if (!village.dirty) continue;
            village.dirty = false;
            this.func_76185_a();
        }
    }

    public void initVillagePacks(World world) {
        for (int i = 0; i < 4; ++i) {
            WereVillage village = new WereVillage(world, i);
            this.villagePackList.add(village);
        }
        this.func_76185_a();
        PacketDispatcher.sendToAll(new ClientPackInfo(this));
    }

    public void resetWorlds(World world) {
        for (WereVillage village : this.villagePackList) {
            village.setWorld(world);
        }
    }

    public boolean addPack(EntityPlayer player, int id) {
        if (this.packID2.contains(id)) {
            return false;
        }
        this.packID2.add(id);
        this.packName.add(player.func_70005_c_() + StatCollector.func_74838_a((String)"werewolf.tame.pack.default"));
        this.packNumbers.add(0);
        this.packPlayerNumbers.add(1);
        this.func_76185_a();
        PacketDispatcher.sendToAll(new ClientPackInfo(this));
        return true;
    }

    public boolean renamePack(int id, String newName) {
        newName = newName.trim();
        if (this.packID2.contains(id) && !this.packName.contains(newName) && !newName.equals("") && !newName.endsWith(StatCollector.func_74838_a((String)"werewolf.tame.pack.default"))) {
            int i = this.packID2.indexOf(id);
            this.packName.set(i, newName);
            this.func_76185_a();
            PacketDispatcher.sendToAll(new ClientPackInfo(this));
            return true;
        }
        return false;
    }

    public boolean setDefaultPackName(EntityPlayer player) {
        int id = WerewolfPlayer.get(player).getWolfID();
        if (this.packID2.contains(id)) {
            String defaultName = player.func_70005_c_() + StatCollector.func_74838_a((String)"werewolf.tame.pack.default");
            int i = this.packID2.indexOf(id);
            this.packName.set(i, defaultName);
            this.func_76185_a();
            PacketDispatcher.sendToAll(new ClientPackInfo(this));
            return true;
        }
        return false;
    }

    public void addMember(EntityPlayer player) {
        WerewolfPlayer props = WerewolfPlayer.get(player);
        if (this.packID2.contains(props.getPackID())) {
            int i = this.packID2.indexOf(props.getWolfID());
            this.packNumbers.set(i, this.packNumbers.get(i) + 1);
            this.func_76185_a();
            PacketDispatcher.sendToAll(new ClientPackNumbers(this));
        }
    }

    public void addMember(int id) {
        if (this.packID2.contains(id)) {
            int i = this.packID2.indexOf(id);
            this.packNumbers.set(i, this.packNumbers.get(i) + 1);
            this.func_76185_a();
            PacketDispatcher.sendToAll(new ClientPackNumbers(this));
        }
    }

    public void removeMember(int id) {
        if (this.packID2.contains(id)) {
            int i = this.packID2.indexOf(id);
            this.packNumbers.set(i, this.packNumbers.get(i) - 1);
            this.func_76185_a();
            PacketDispatcher.sendToAll(new ClientPackNumbers(this));
        }
    }

    public void addMemberPlayer(int id) {
        if (this.packID2.contains(id)) {
            int i = this.packID2.indexOf(id);
            this.packPlayerNumbers.set(i, this.packPlayerNumbers.get(i) + 1);
            this.func_76185_a();
            PacketDispatcher.sendToAll(new ClientPackNumbers(this));
        }
    }

    public void removeMemberPlayer(int id) {
        if (this.packID2.contains(id)) {
            int i = this.packID2.indexOf(id);
            this.packPlayerNumbers.set(i, this.packPlayerNumbers.get(i) - 1);
            this.func_76185_a();
            PacketDispatcher.sendToAll(new ClientPackNumbers(this));
        }
    }

    public void movePlayer(int from, int to) {
        if (this.packID2.contains(from) && this.packID2.contains(to)) {
            int i = this.packID2.indexOf(from);
            this.packPlayerNumbers.set(i, this.packPlayerNumbers.get(i) - 1);
            int j = this.packID2.indexOf(to);
            this.packPlayerNumbers.set(j, this.packPlayerNumbers.get(j) + 1);
            this.func_76185_a();
            PacketDispatcher.sendToAll(new ClientPackNumbers(this));
        }
    }

    public String getPackName(EntityPlayer player) {
        WerewolfPlayer props = WerewolfPlayer.get(player);
        int i = this.packID2.indexOf(props.getPackID());
        if (i != -1) {
            return this.packName.get(i);
        }
        return null;
    }

    public String getPackName(int id) {
        int i = this.packID2.indexOf(id);
        if (i != -1) {
            return this.packName.get(i);
        }
        return null;
    }

    public int getPackNumbers(int id) {
        int i = this.packID2.indexOf(id);
        if (i != -1) {
            return this.packNumbers.get(i);
        }
        return -1;
    }

    public int getPackPlayerNumbers(int id) {
        int i = this.packID2.indexOf(id);
        if (i != -1) {
            return this.packPlayerNumbers.get(i);
        }
        return -1;
    }
}

