/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon;

import com.raz.howlingmoon.WerewolfPlayer;
import com.raz.howlingmoon.entities.EntityWerewolf;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;

public class TileEntityBlockWard
extends TileEntity
implements IInventory {
    private ItemStack[] wardItemStacks = new ItemStack[2];
    private int tickTime;
    public boolean hasGlow;
    public boolean hasRedstone;
    public int targetType;
    public boolean triggerLight;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            Vec3 normal;
            double force;
            double distToOrigin;
            Vec3 directionVec;
            if (!this.hasGlow && this.wardItemStacks[0] != null) {
                this.hasGlow = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else if (this.hasGlow && this.wardItemStacks[0] == null) {
                this.hasGlow = false;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (!this.hasRedstone && this.wardItemStacks[1] != null) {
                this.hasRedstone = true;
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.func_145838_q());
            } else if (this.hasRedstone && this.wardItemStacks[1] == null) {
                this.hasRedstone = false;
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.func_145838_q());
            }
            AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 8.0), (double)((double)this.field_145848_d - 8.0), (double)((double)this.field_145849_e - 8.0), (double)(this.field_145851_c + 9), (double)(this.field_145848_d + 9), (double)(this.field_145849_e + 9));
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, axisalignedbb);
            Iterator iterator = list.iterator();
            if (this.targetType != 1) {
                while (iterator.hasNext()) {
                    EntityPlayer entityplayer = (EntityPlayer)iterator.next();
                    WerewolfPlayer props = WerewolfPlayer.get(entityplayer);
                    if (props.getTransformed()) {
                        switch (this.func_145832_p()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                directionVec = Vec3.func_72443_a((double)(entityplayer.field_70165_t - (double)this.field_145851_c - 0.5), (double)(entityplayer.field_70163_u - (double)this.field_145848_d), (double)(entityplayer.field_70161_v - (double)this.field_145849_e - 0.5));
                                distToOrigin = directionVec.func_72433_c();
                                force = 1.0 - distToOrigin / 8.0;
                                if (force <= 0.0) break;
                                normal = directionVec.func_72432_b();
                                entityplayer.field_70159_w += force * normal.field_72450_a;
                                entityplayer.field_70179_y += force * normal.field_72449_c;
                                ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity((Entity)entityplayer));
                                break;
                            }
                            case 2: {
                                entityplayer.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 10, 1, true));
                                break;
                            }
                            case 3: {
                                entityplayer.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 10, 1, true));
                                break;
                            }
                        }
                    }
                }
            }
            if (this.targetType != 2) {
                list = this.field_145850_b.func_72872_a(EntityWerewolf.class, axisalignedbb);
                block13: for (EntityWerewolf werewolf : list) {
                    switch (this.func_145832_p()) {
                        case 0: {
                            continue block13;
                        }
                        case 1: {
                            directionVec = Vec3.func_72443_a((double)(werewolf.field_70165_t - (double)this.field_145851_c), (double)(werewolf.field_70163_u - (double)this.field_145848_d), (double)(werewolf.field_70161_v - (double)this.field_145849_e));
                            distToOrigin = directionVec.func_72433_c();
                            force = 1.0 - distToOrigin / 8.0;
                            if (force <= 0.0) continue block13;
                            normal = directionVec.func_72432_b();
                            werewolf.field_70159_w += force * normal.field_72450_a;
                            werewolf.field_70179_y += force * normal.field_72449_c;
                            continue block13;
                        }
                        case 2: {
                            werewolf.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 10, 1, true));
                            continue block13;
                        }
                        case 3: {
                            werewolf.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 10, 1, true));
                            continue block13;
                        }
                    }
                }
            }
        } else if (this.hasGlow != this.triggerLight) {
            this.triggerLight = this.hasGlow;
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.hasGlow = nbtTagCompound.func_74767_n("hasGlow");
        this.hasRedstone = nbtTagCompound.func_74767_n("hasRedstone");
        this.targetType = nbtTagCompound.func_74762_e("targetType");
        NBTTagList tagList = nbtTagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound1 = tagList.func_150305_b(i);
            byte slot = nbtTagCompound1.func_74771_c("Slot");
            if (slot < 0 || slot >= this.wardItemStacks.length) continue;
            this.wardItemStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound1);
        }
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("hasGlow", this.hasGlow());
        nbtTagCompound.func_74757_a("hasRedstone", this.hasRedstone());
        nbtTagCompound.func_74768_a("targetType", this.getTargetType());
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.wardItemStacks.length; ++i) {
            ItemStack itemStack = this.wardItemStacks[i];
            if (itemStack == null) continue;
            NBTTagCompound nbtTagCompound1 = new NBTTagCompound();
            nbtTagCompound1.func_74774_a("Slot", (byte)i);
            itemStack.func_77955_b(nbtTagCompound1);
            tagList.func_74742_a((NBTBase)nbtTagCompound1);
        }
        nbtTagCompound.func_74782_a("Inventory", (NBTBase)tagList);
    }

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.func_145841_b(syncData);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int func_70302_i_() {
        return this.wardItemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.wardItemStacks[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        return this.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.wardItemStacks[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "wardContainer";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        if (WerewolfPlayer.get(p_70300_1_).getTransformed()) {
            return false;
        }
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : p_70300_1_.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    public void setGlow(boolean glow) {
        this.hasGlow = glow;
    }

    public void setRedstone(boolean redstone) {
        this.hasRedstone = redstone;
    }

    public boolean hasGlow() {
        return this.hasGlow;
    }

    public boolean hasRedstone() {
        return this.hasRedstone;
    }

    public void changeType() {
        this.targetType = this.targetType > 1 ? 0 : ++this.targetType;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public String getTargetTypeName() {
        switch (this.targetType) {
            case 0: {
                return StatCollector.func_74838_a((String)"werewolf.message.mode.All");
            }
            case 1: {
                return StatCollector.func_74838_a((String)"werewolf.message.mode.Mob");
            }
            case 2: {
                return StatCollector.func_74838_a((String)"werewolf.message.mode.Player");
            }
        }
        return "Error";
    }

    public int getLight() {
        if (this.hasGlow) {
            return 14;
        }
        return 0;
    }

    public int getRedstone() {
        if (this.hasRedstone) {
            return 15;
        }
        return 0;
    }
}

