/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.client.gui;

import com.raz.howlingmoon.HowlingWorldData;
import com.raz.howlingmoon.WerewolfPlayer;
import com.raz.howlingmoon.client.KeyBindings;
import com.raz.howlingmoon.client.gui.GuiButtonAbility;
import com.raz.howlingmoon.client.gui.GuiButtonTab;
import com.raz.howlingmoon.entities.EntityTameWere;
import com.raz.howlingmoon.packets.PacketDispatcher;
import com.raz.howlingmoon.packets.SetSittingServerMessage;
import com.raz.howlingmoon.packets.SyncHowlSummon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiTame
extends GuiScreen {
    private static final ResourceLocation background = new ResourceLocation("howlingmoon", "textures/gui/werewolf_menu2.png");
    public static final ResourceLocation bars = new ResourceLocation("howlingmoon", "textures/gui/bars.png");
    private EntityTameWere entity;
    private int behaviorNumber;
    private List<String> behaviors;
    private int startAt;
    private float xSizeFloat;
    private float ySizeFloat;
    protected int xSize = 176;
    protected int ySize = 166;
    private int guiLeft;
    private int guiTop;
    private GuiButton buttonScrollUp;
    private GuiButton buttonScrollDown;
    private GuiButton buttonFollow;
    private GuiButtonAbility buttonHowl;
    private GuiButtonTab buttonGeneral;
    private GuiButtonTab buttonAbility;
    private int state;

    public GuiTame(Entity id) {
        if (id != null && id instanceof EntityTameWere) {
            this.entity = (EntityTameWere)id;
            this.startAt = 0;
            this.behaviorNumber = this.entity.numberOfSetBits(this.entity.getStaticBehaviors());
            this.behaviorNumber += this.entity.numberOfSetBits(this.entity.getDynamicBehaviors());
            this.behaviors = new ArrayList<String>();
            if (this.entity.doesAttackPlayers()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.playerAttack"));
            }
            if (this.entity.doesAttackAnimals()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.animalAttack"));
            }
            if (this.entity.doesAttackVillagers()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.villagerAttack"));
            }
            if (this.entity.doesAttackBones()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.bonesAttack"));
            }
            if (this.entity.doesLeap()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.leap"));
            }
            if (this.entity.getAvoidWater()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.water"));
            }
            if (this.entity.getAvoidFire()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.fire"));
            }
            if (this.entity.getBreakDoors()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.doors"));
            }
            if (this.entity.getLikesMusic()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.music"));
            }
            if (this.entity.getLovesCake()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.lovesCake"));
            }
            if (this.entity.getLikesCake()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.likesCake"));
            }
            if (this.entity.hasKnockback()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.knockback"));
            }
            if (this.entity.hasKnockbackResistance()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.knockbackResist"));
            }
            if (this.entity.hasAgile()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.agile"));
            }
            if (this.entity.isSubmissve()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.submissive"));
            }
            if (this.entity.isWild()) {
                this.behaviors.add(StatCollector.func_74838_a((String)"werewolf.tame.wild"));
            }
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.buttonGeneral = new GuiButtonTab(0, this.guiLeft, this.guiTop - 28, 0);
        this.field_146292_n.add(this.buttonGeneral);
        this.buttonAbility = new GuiButtonTab(1, this.guiLeft + 28, this.guiTop - 28, 1);
        this.field_146292_n.add(this.buttonAbility);
        this.buttonFollow = new GuiButton(2, this.guiLeft + 63, this.guiTop + 110, 50, 20, "" + this.entity.getSittingName());
        this.field_146292_n.add(this.buttonFollow);
        this.buttonHowl = new GuiButtonAbility(3, this.guiLeft + 78, this.guiTop + 135, 10, 0, false);
        this.field_146292_n.add(this.buttonHowl);
        this.buttonScrollUp = new GuiButton(11, this.guiLeft + 150, this.guiTop + 45, 15, 15, "^");
        this.field_146292_n.add(this.buttonScrollUp);
        this.buttonScrollDown = new GuiButton(12, this.guiLeft + 150, this.guiTop + 135, 15, 15, "v");
        this.field_146292_n.add(this.buttonScrollDown);
        this.state = 0;
        this.buttonGeneral.active = 1;
        this.buttonFollow.field_146125_m = this.entity.getPlayerWolfID() == WerewolfPlayer.get((EntityPlayer)this.field_146297_k.field_71439_g).getWolfID();
        this.buttonHowl.field_146125_m = this.entity.getPlayerWolfID() == WerewolfPlayer.get((EntityPlayer)this.field_146297_k.field_71439_g).getWolfID();
        this.buttonHowl.active = 2;
        if (this.buttonHowl.field_146125_m && WerewolfPlayer.get((EntityPlayer)this.field_146297_k.field_71439_g).packFollowers.contains(this.entity.func_145782_y())) {
            this.buttonHowl.active = 3;
        }
        this.buttonScrollUp.field_146125_m = false;
        this.buttonScrollDown.field_146125_m = false;
    }

    public void func_73876_c() {
        this.buttonGeneral.active = this.state == 0 ? 1 : 0;
        this.buttonAbility.active = this.state == 1 ? 1 : 0;
        this.buttonFollow.field_146125_m = this.state == 0 && this.entity.getPlayerWolfID() == WerewolfPlayer.get((EntityPlayer)this.field_146297_k.field_71439_g).getWolfID();
        this.buttonScrollUp.field_146125_m = this.state == 1 && this.startAt > 0;
        this.buttonScrollDown.field_146125_m = this.state == 1 && this.behaviors.size() > 7 && this.startAt < this.behaviors.size() - 7;
        boolean bl = this.buttonHowl.field_146125_m = this.state == 0 && this.entity.getPlayerWolfID() == WerewolfPlayer.get((EntityPlayer)this.field_146297_k.field_71439_g).getWolfID();
        if (this.buttonHowl.field_146125_m) {
            this.buttonHowl.active = WerewolfPlayer.get((EntityPlayer)this.field_146297_k.field_71439_g).packFollowers.contains(this.entity.func_145782_y()) ? 3 : 2;
        }
        this.buttonFollow.field_146126_j = "" + this.entity.getSittingName();
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char c, int keyCode) {
        super.func_73869_a(c, keyCode);
        if (keyCode == KeyBindings.menu.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_146284_a(GuiButton b) {
        if (this.entity != null) {
            switch (b.field_146127_k) {
                case 0: {
                    this.state = 0;
                    break;
                }
                case 1: {
                    this.state = 1;
                    break;
                }
                case 2: {
                    PacketDispatcher.sendToServer(new SetSittingServerMessage(this.entity));
                    break;
                }
                case 3: {
                    WerewolfPlayer props = WerewolfPlayer.get((EntityPlayer)this.field_146297_k.field_71439_g);
                    if (props.packFollowers.contains(this.entity.func_145782_y())) {
                        props.packFollowers.remove((Object)this.entity.func_145782_y());
                        PacketDispatcher.sendToServer(new SyncHowlSummon((EntityPlayer)this.field_146297_k.field_71439_g));
                        break;
                    }
                    if (props.packFollowers.size() < 5) {
                        props.packFollowers.add(this.entity.func_145782_y());
                        PacketDispatcher.sendToServer(new SyncHowlSummon((EntityPlayer)this.field_146297_k.field_71439_g));
                        break;
                    }
                    this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.howlFull")));
                    break;
                }
                case 11: {
                    if (this.startAt <= 0) break;
                    --this.startAt;
                    break;
                }
                case 12: {
                    if (this.startAt >= this.behaviors.size() - 7) break;
                    ++this.startAt;
                }
            }
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.xSizeFloat = par1;
        this.ySizeFloat = par2;
        if (this.entity != null) {
            if (this.state == 0) {
                this.drawGuiContainerBackgroundLayer();
            } else if (this.state == 1) {
                this.drawGuiAbilityLayer();
            }
        }
        super.func_73863_a(par1, par2, par3);
    }

    protected void drawGuiContainerBackgroundLayer() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        int k = this.guiLeft;
        int l = this.guiTop;
        this.func_73729_b(k, l, 0, 0, this.xSize, this.ySize);
        this.drawTameInfo(k, l);
    }

    protected void drawGuiAbilityLayer() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        int k = this.guiLeft;
        int l = this.guiTop;
        this.func_73729_b(k, l, 0, 0, this.xSize, this.ySize);
        this.drawAbilityInfo(k, l);
    }

    public void drawTameInfo(int x, int y) {
        if (this.entity != null) {
            HowlingWorldData data = HowlingWorldData.forWorld(this.entity.field_70170_p);
            if (this.entity.isDire()) {
                this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"werewolf.menu.direwolf"), x + (this.xSize - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"werewolf.menu.werewolf"))) / 2, y + 10, 0);
            } else {
                this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"werewolf.menu.werewolf"), x + (this.xSize - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"werewolf.menu.werewolf"))) / 2, y + 10, 0);
            }
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"werewolf.tame.savagery") + ": " + this.entity.getSavageryLevel(), x + 10, y + 40, 0);
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"werewolf.tame.health") + ": " + (int)this.entity.func_110143_aJ() + "/" + (int)this.entity.func_110138_aP(), x + 10, y + 55, 0);
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"werewolf.tame.pack.name") + ": " + data.getPackName(this.entity.getPackID()), x + 10, y + 70, 0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(field_110324_m);
            int level = this.entity.getHunger();
            for (int i = 0; i < 10; ++i) {
                int idx = i * 2 + 1;
                int x2 = x + 128 - i * 8 - 9;
                int y2 = y + 25;
                int icon = 16;
                int backgound = 0;
                this.func_73729_b(x2, y2, 16 + backgound * 9, 27, 9, 9);
                if (idx < level) {
                    this.func_73729_b(x2, y2, icon + 36, 27, 9, 9);
                    continue;
                }
                if (idx != level) continue;
                this.func_73729_b(x2, y2, icon + 45, 27, 9, 9);
            }
        }
    }

    public void drawAbilityInfo(int x, int y) {
        if (this.entity != null) {
            if (this.entity.isDire()) {
                this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"werewolf.menu.direwolf"), x + (this.xSize - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"werewolf.menu.werewolf"))) / 2, y + 10, 0);
            } else {
                this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"werewolf.menu.werewolf"), x + (this.xSize - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"werewolf.menu.werewolf"))) / 2, y + 10, 0);
            }
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"werewolf.tame.behavior"), x + (this.xSize - this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"werewolf.tame.behavior"))) / 2, y + 30, 0);
            int heightY = 45;
            int endAt = this.behaviors.size();
            if (endAt - this.startAt > 7) {
                endAt = this.startAt + 7;
            }
            for (String i : this.behaviors.subList(this.startAt, endAt)) {
                this.field_146289_q.func_78276_b(i, x + 10, y + heightY, 0);
                heightY += 15;
            }
        }
    }
}

