/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.entities;

import com.raz.howlingmoon.HowlingWorldData;
import com.raz.howlingmoon.Werewolf;
import com.raz.howlingmoon.WerewolfPlayer;
import com.raz.howlingmoon.entities.EntityAlphaWolf;
import com.raz.howlingmoon.entities.EntityWere;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public abstract class EntityTameWere
extends EntityWere
implements IEntityOwnable {
    private int tickTimer = 0;

    public EntityTameWere(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)"");
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.getOwnerId() == null) {
            tagCompound.func_74778_a("OwnerUUID", "");
        } else {
            tagCompound.func_74778_a("OwnerUUID", this.getOwnerId());
        }
        tagCompound.func_74757_a("Sitting", this.isSitting());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        String s = "";
        if (tagCompound.func_150297_b("OwnerUUID", 8)) {
            s = tagCompound.func_74779_i("OwnerUUID");
        } else {
            String s1 = tagCompound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_152719_a((String)s1);
        }
        if (s.length() > 0) {
            this.setOwnerId(s);
            this.setTamed(true);
            if (tagCompound.func_74764_b("aiswim") && this.getOwnerEntity() != null) {
                this.field_70180_af.func_75692_b(18, (Object)WerewolfPlayer.get((EntityPlayer)this.getOwnerEntity()).getWolfID());
            }
        }
        this.setSitting(tagCompound.func_74767_n("Sitting"));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() == null && this.isAngry()) {
                this.setAngry(false);
            } else if (this.func_70638_az() instanceof EntityTameWere && this.getPackID() == ((EntityTameWere)this.func_70638_az()).getPackID()) {
                this.func_70624_b(null);
                this.setAngry(false);
            }
            if (this.isTamed()) {
                ++this.tickTimer;
                if (this.tickTimer % 100 == 0) {
                    if (this.getOwnerEntity() instanceof EntityPlayer) {
                        if (!WerewolfPlayer.get((EntityPlayer)this.getOwnerEntity()).getWerewolf() || WerewolfPlayer.get((EntityPlayer)this.getOwnerEntity()).getTierInt() + 3 < this.getSavageryLevel() && !this.isSubmissve()) {
                            this.setTamed(false);
                            HowlingWorldData.forWorld(this.field_70170_p).removeMember(this.getPlayerWolfID());
                        } else if (WerewolfPlayer.get((EntityPlayer)this.getOwnerEntity()).getPackID() != this.getPackID()) {
                            this.setPackID(WerewolfPlayer.get((EntityPlayer)this.getOwnerEntity()).getPackID());
                        }
                    }
                    if (this.func_70638_az() instanceof EntityPlayer && this.getPackID() == WerewolfPlayer.get((EntityPlayer)this.func_70638_az()).getPackID()) {
                        this.func_70624_b(null);
                        this.setAngry(false);
                    }
                }
                if (this.tickTimer > 2400) {
                    this.tickTimer = this.getHunger() - 1;
                    if (this.tickTimer < 0) {
                        this.tickTimer = 0;
                    }
                    this.field_70180_af.func_75692_b(27, (Object)this.tickTimer);
                    this.tickTimer = 0;
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.isTamed() && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    protected String func_145776_H() {
        return "game.hostile.swim";
    }

    protected String func_145777_O() {
        return "game.hostile.swim.splash";
    }

    protected Entity func_70782_k() {
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        return entityplayer != null && this.func_70685_l((Entity)entityplayer) ? entityplayer : null;
    }

    protected String func_70621_aR() {
        return "mob.wolf.hurt";
    }

    protected String func_70673_aS() {
        return "mob.wolf.death";
    }

    protected String func_146067_o(int p_146067_1_) {
        return p_146067_1_ > 4 ? "game.hostile.hurt.fall.big" : "game.hostile.hurt.fall.small";
    }

    protected void func_70785_a(Entity p_70785_1_, float p_70785_2_) {
        if (this.field_70724_aR <= 0 && p_70785_2_ < 2.0f && p_70785_1_.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && p_70785_1_.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            this.func_70652_k(p_70785_1_);
        }
    }

    protected boolean isValidLightLevel() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72972_b(EnumSkyBlock.Sky, i, j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v)) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int l = this.field_70170_p.func_72957_l(i, j, k);
        if (this.field_70170_p.func_72911_I()) {
            int i1 = this.field_70170_p.field_73008_k;
            this.field_70170_p.field_73008_k = 10;
            l = this.field_70170_p.func_72957_l(i, j, k);
            this.field_70170_p.field_73008_k = i1;
        }
        return l <= this.field_70146_Z.nextInt(8);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.isValidLightLevel() && super.func_70601_bi();
    }

    protected void playTameEffect(boolean p_70908_1_) {
        String s = "heart";
        if (!p_70908_1_) {
            s = "smoke";
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(s, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 7) {
            this.playTameEffect(true);
        } else if (p_70103_1_ == 6) {
            this.playTameEffect(false);
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public boolean isAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public void setAngry(boolean angry) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        if (angry) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    public boolean isTamed() {
        return (this.field_70180_af.func_75683_a(16) & 4) != 0;
    }

    public void setTamed(boolean tamed) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        if (tamed) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 | 4)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 & 0xFFFFFFFB)));
            this.setPlayerWolfID(0);
            this.setPackID(0);
        }
    }

    protected void setupTamedAI() {
    }

    public boolean isSitting() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setSitting(boolean p_70904_1_) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        if (p_70904_1_) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public String getSittingName() {
        if (this.isSitting()) {
            return StatCollector.func_74838_a((String)"werewolf.tame.wander");
        }
        return StatCollector.func_74838_a((String)"werewolf.tame.follow");
    }

    public String getOwnerId() {
        return this.field_70180_af.func_75681_e(17);
    }

    public void setOwnerId(String ownerUuid) {
        this.field_70180_af.func_75692_b(17, (Object)ownerUuid);
    }

    public EntityLivingBase getOwnerEntity() {
        try {
            UUID uuid = UUID.fromString(this.getOwnerId());
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        return entityIn == this.getOwnerEntity();
    }

    public boolean func_142018_a(EntityLivingBase p_142018_1_, EntityLivingBase p_142018_2_) {
        return true;
    }

    public Team func_96124_cp() {
        EntityLivingBase entitylivingbase;
        if (this.isTamed() && (entitylivingbase = this.getOwnerEntity()) != null) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_142014_c(EntityLivingBase otherEntity) {
        if (this.isTamed()) {
            EntityLivingBase entitylivingbase1 = this.getOwnerEntity();
            if (otherEntity == entitylivingbase1) {
                return true;
            }
            if (entitylivingbase1 != null) {
                return entitylivingbase1.func_142014_c(otherEntity);
            }
        }
        return super.func_142014_c(otherEntity);
    }

    public Entity func_70902_q() {
        return this.getOwnerEntity();
    }

    public boolean isDire() {
        return this instanceof EntityAlphaWolf;
    }

    protected Item func_146068_u() {
        return Werewolf.wolfFangs;
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            HowlingWorldData.forWorld(this.field_70170_p).removeMember(this.getPlayerWolfID());
        }
        super.func_70645_a(cause);
    }
}

