/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.handler;

import com.raz.howlingmoon.Werewolf;
import com.raz.howlingmoon.WerewolfPlayer;
import com.raz.howlingmoon.client.EntityParticleFXInfrared;
import com.raz.howlingmoon.client.EntityParticleFXScent;
import com.raz.howlingmoon.client.EntityRenderBeast;
import com.raz.howlingmoon.client.ItemRendererWerewolf;
import com.raz.howlingmoon.client.RenderBeastPlayer;
import com.raz.howlingmoon.client.RenderDireWolf;
import com.raz.howlingmoon.client.RenderWerewolfPlayer;
import com.raz.howlingmoon.handler.ConfigHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

public class WerewolfClientEventHandler {
    private Render renderCustomModel;
    private static final ResourceLocation guiBar = new ResourceLocation("howlingmoon:textures/gui/bars.png");
    private Minecraft mc = Minecraft.func_71410_x();
    public final ItemRendererWerewolf itemRendererWerewolf;
    private EntityRenderer rendererBeast;
    private EntityRenderer rendererDire;
    private EntityRenderer prevRenderer;
    private float ySize = -1.0f;
    private int curModel = 0;

    public WerewolfClientEventHandler() {
        this.renderCustomModel = new RenderWerewolfPlayer();
        this.itemRendererWerewolf = new ItemRendererWerewolf(this.mc);
    }

    @SubscribeEvent
    public void onRenderPlayerPre(RenderPlayerEvent.Pre pre) {
        EntityPlayer player;
        WerewolfPlayer props;
        if (!ConfigHandler.disableRender && (props = WerewolfPlayer.get(player = pre.entityPlayer)).getTransformed() && !(pre.renderer instanceof RenderWerewolfPlayer)) {
            pre.setCanceled(true);
            if (this.curModel != props.getModel()) {
                this.curModel = props.getModel();
                if (this.curModel < 2) {
                    this.renderCustomModel = new RenderWerewolfPlayer();
                } else if (this.curModel == 2) {
                    this.renderCustomModel = new RenderBeastPlayer();
                } else if (this.curModel == 3) {
                    this.renderCustomModel = new RenderDireWolf();
                }
            }
            if (player != this.mc.field_71439_g) {
                double d0 = pre.entityPlayer.field_70142_S + (pre.entityPlayer.field_70165_t - pre.entityPlayer.field_70142_S) * (double)pre.partialRenderTick;
                double d1 = pre.entityPlayer.field_70137_T + (pre.entityPlayer.field_70163_u - pre.entityPlayer.field_70137_T) * (double)pre.partialRenderTick;
                double d2 = pre.entityPlayer.field_70136_U + (pre.entityPlayer.field_70161_v - pre.entityPlayer.field_70136_U) * (double)pre.partialRenderTick;
                double d3 = this.mc.field_71439_g.field_70142_S + (this.mc.field_71439_g.field_70165_t - this.mc.field_71439_g.field_70142_S) * (double)pre.partialRenderTick;
                double d4 = this.mc.field_71439_g.field_70137_T + (this.mc.field_71439_g.field_70163_u - this.mc.field_71439_g.field_70137_T) * (double)pre.partialRenderTick;
                double d5 = this.mc.field_71439_g.field_70136_U + (this.mc.field_71439_g.field_70161_v - this.mc.field_71439_g.field_70136_U) * (double)pre.partialRenderTick;
                this.renderCustomModel.func_76986_a(pre.entity, d0 - d3, d1 - d4, d2 - d5, 0.0f, pre.partialRenderTick);
            } else {
                this.renderCustomModel.func_76986_a(pre.entity, 0.0, 0.0, 0.0, 0.0f, pre.partialRenderTick);
            }
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (this.mc.field_71441_e != null) {
            EntityClientPlayerMP player = this.mc.field_71439_g;
            WerewolfPlayer props = WerewolfPlayer.get((EntityPlayer)player);
            if (props.getModel() == 2 && props.getTransformed()) {
                if (this.rendererBeast == null) {
                    this.rendererBeast = new EntityRenderBeast(this.mc);
                }
                if (this.mc.field_71460_t != this.rendererBeast) {
                    if (this.prevRenderer == null) {
                        this.prevRenderer = this.mc.field_71460_t;
                    }
                    this.mc.field_71460_t = this.rendererBeast;
                }
            } else if (props.getModel() == 3 && props.getTransformed()) {
                if (this.rendererDire == null) {
                    this.rendererDire = new EntityRenderBeast(this.mc, -0.8f);
                }
                if (this.mc.field_71460_t != this.rendererDire) {
                    if (this.prevRenderer == null) {
                        this.prevRenderer = this.mc.field_71460_t;
                    }
                    this.mc.field_71460_t = this.rendererDire;
                }
            } else if (this.prevRenderer != null && this.mc.field_71460_t != this.prevRenderer) {
                this.mc.field_71460_t = this.prevRenderer;
            }
        }
    }

    @SubscribeEvent
    public void onRenderWerewolfPaw(RenderHandEvent event) {
        if (WerewolfPlayer.get((EntityPlayer)this.mc.field_71439_g).getTransformed() && !ConfigHandler.disableRender) {
            event.setCanceled(true);
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            EntityRenderer playerRender = Minecraft.func_71410_x().field_71460_t;
            GL11.glClear((int)256);
            float p_78476_1_ = event.partialTicks;
            int p_78476_2_ = event.renderPass;
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            float f1 = 0.07f;
            if (this.mc.field_71474_y.field_74337_g) {
                GL11.glTranslatef((float)((float)(-(p_78476_2_ * 2 - 1)) * f1), (float)0.0f, (float)0.0f);
            }
            float farPlaneDistance = this.mc.field_71474_y.field_151451_c * 16;
            Project.gluPerspective((float)this.getFOVModifier(p_78476_1_, false), (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)(farPlaneDistance * 2.0f));
            if (this.mc.field_71442_b.func_78747_a()) {
                float f2 = 0.6666667f;
                GL11.glScalef((float)1.0f, (float)f2, (float)1.0f);
            }
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            if (this.mc.field_71474_y.field_74337_g) {
                GL11.glTranslatef((float)((float)(p_78476_2_ * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
            }
            GL11.glPushMatrix();
            if (this.mc.field_71474_y.field_74336_f) {
                this.setupViewBobbing(p_78476_1_);
            }
            if (!(this.mc.field_71474_y.field_74320_O != 0 || this.mc.field_71451_h.func_70608_bn() || this.mc.field_71474_y.field_74319_N || this.mc.field_71442_b.func_78747_a())) {
                playerRender.func_78463_b((double)p_78476_1_);
                this.itemRendererWerewolf.updateEquippedItem();
                this.itemRendererWerewolf.renderItemInFirstPerson(p_78476_1_);
                playerRender.func_78483_a((double)p_78476_1_);
            }
            GL11.glPopMatrix();
            if (this.mc.field_71474_y.field_74320_O == 0 && !this.mc.field_71451_h.func_70608_bn()) {
                playerRender.field_78516_c.func_78447_b(p_78476_1_);
            }
            if (this.mc.field_71474_y.field_74336_f) {
                this.setupViewBobbing(p_78476_1_);
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingFinished(RenderLivingEvent.Post e) {
        WerewolfPlayer props = WerewolfPlayer.get((EntityPlayer)this.mc.field_71439_g);
        if (props.getTransformed() && props.getTierAbility() > 2 && props.getVisionState() == 2 && e.entity.field_70173_aa % 5 == 0) {
            if (e.entity instanceof EntityAnimal) {
                Werewolf.proxy.generateInfraredParticles((Entity)e.entity, 1.0f, 0.5f, 0.0f);
            } else if (e.entity instanceof EntityCreeper) {
                Werewolf.proxy.generateInfraredParticles((Entity)e.entity, 0.0f, 1.0f, 0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE || this.mc.field_71439_g.func_70055_a(Material.field_151586_h) || !ConfigHandler.secondaryHunger || this.mc.field_71439_g.field_71075_bZ.field_75098_d) {
            return;
        }
        WerewolfPlayer props = WerewolfPlayer.get((EntityPlayer)this.mc.field_71439_g);
        if (props.getWerewolf() && props.getHungerState() != 0 && props.getTierInt() > 0 && (props.getTransformed() || props.getHungerState() == 2)) {
            ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
            int k = scaledresolution.func_78326_a();
            int l = scaledresolution.func_78328_b();
            this.mc.func_110434_K().func_110577_a(guiBar);
            GL11.glBlendFunc((int)770, (int)771);
            int rallyColor = 0;
            if (props.rally > 300) {
                rallyColor = 164;
            } else if (props.rally > 0) {
                rallyColor = 82;
            }
            if (props.isFat()) {
                this.mc.field_71456_v.func_73729_b(k / 2 + 10, l - 53, rallyColor, 65, 81, 14);
                int widthP = (int)((float)props.transformedHunger / (float)props.getMaxHunger() * 79.0f);
                widthP = widthP < 0 ? 0 : widthP;
                this.mc.field_71456_v.func_73729_b(k / 2 + 11, l - 53, 1, 80, widthP, 14);
            } else {
                this.mc.field_71456_v.func_73729_b(k / 2 + 10, l - 49, rallyColor, 20, 81, 9);
                int widthP = (int)((float)props.transformedHunger / (float)props.getMaxHunger() * 79.0f);
                widthP = widthP < 0 ? 0 : widthP;
                this.mc.field_71456_v.func_73729_b(k / 2 + 11, l - 48, 1, 31, widthP, 7);
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Tessellator tessellator = Tessellator.field_78398_a;
        boolean isLightingEnabled = GL11.glGetBoolean((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        if (isLightingEnabled) {
            GL11.glDisable((int)2896);
        }
        EntityParticleFXScent.dispatchQueuedRenders(tessellator);
        EntityParticleFXInfrared.dispatchQueuedRenders(tessellator);
        if (isLightingEnabled) {
            GL11.glEnable((int)2896);
        }
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    private void setupViewBobbing(float p_78475_1_) {
        if (this.mc.field_71451_h instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this.mc.field_71451_h;
            float f1 = entityplayer.field_70140_Q - entityplayer.field_70141_P;
            float f2 = -(entityplayer.field_70140_Q + f1 * p_78475_1_);
            float f3 = entityplayer.field_71107_bF + (entityplayer.field_71109_bG - entityplayer.field_71107_bF) * p_78475_1_;
            float f4 = entityplayer.field_70727_aS + (entityplayer.field_70726_aT - entityplayer.field_70727_aS) * p_78475_1_;
            GL11.glTranslatef((float)(MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 0.5f), (float)(-Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI)) * f3)), (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI - 0.2f)) * f3) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)f4, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private float getFOVModifier(float p_78481_1_, boolean p_78481_2_) {
        Block block;
        EntityLivingBase entityplayer = this.mc.field_71451_h;
        float f1 = 70.0f;
        if (entityplayer.func_110143_aJ() <= 0.0f) {
            float f2 = (float)entityplayer.field_70725_aQ + p_78481_1_;
            f1 /= (1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f;
        }
        if ((block = ActiveRenderInfo.func_151460_a((World)this.mc.field_71441_e, (EntityLivingBase)entityplayer, (float)p_78481_1_)).func_149688_o() == Material.field_151586_h) {
            f1 = f1 * 60.0f / 70.0f;
        }
        return f1;
    }
}

