/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.packets;

import com.google.common.collect.Maps;
import com.raz.howlingmoon.HowlingWorldData;
import com.raz.howlingmoon.WerewolfPlayer;
import com.raz.howlingmoon.packets.AbstractMessage;
import com.raz.howlingmoon.packets.PackInviteMessage;
import com.raz.howlingmoon.packets.PackJoinMessage;
import com.raz.howlingmoon.packets.PacketDispatcher;
import com.raz.howlingmoon.packets.WerewolfIDsMessage;
import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.UsernameCache;

public class SendPackMessage
extends AbstractMessage.AbstractServerMessage<SendPackMessage> {
    private String name;
    private int type;

    public SendPackMessage() {
    }

    public SendPackMessage(String playerName, int which) {
        this.name = playerName;
        this.type = which;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.name = buffer.func_150789_c(18);
        this.type = buffer.readInt();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.func_150785_a(this.name);
        buffer.writeInt(this.type);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        Map map = UsernameCache.getMap();
        HashMap players = Maps.newHashMap();
        for (Map.Entry entry : map.entrySet()) {
            players.put(entry.getValue(), entry.getKey());
        }
        UUID uuid = (UUID)players.get(this.name);
        if (uuid != null) {
            EntityPlayer target = player.field_70170_p.func_152378_a(uuid);
            if (target != null) {
                if (target == player) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.self")));
                } else {
                    WerewolfPlayer props = WerewolfPlayer.get(player);
                    WerewolfPlayer targetProps = WerewolfPlayer.get(target);
                    HowlingWorldData howlingData = HowlingWorldData.forWorld(player.field_70170_p);
                    if (targetProps.getWerewolf()) {
                        if (this.type == 1) {
                            if (targetProps.getWolfID() == targetProps.getPackID()) {
                                if (targetProps.getInvitedID() == 0 && howlingData.getPackPlayerNumbers(targetProps.getPackID()) == 1) {
                                    targetProps.setInvitedID(props.getWolfID());
                                    PacketDispatcher.sendTo(new PackInviteMessage(target), (EntityPlayerMP)target);
                                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.invited") + " " + target.func_70005_c_() + " " + StatCollector.func_74838_a((String)"werewolf.message.invited2")));
                                    target.func_145747_a((IChatComponent)new ChatComponentText(player.func_70005_c_() + " " + StatCollector.func_74838_a((String)"werewolf.message.invitedRec")));
                                } else if (targetProps.getInvitedID() > 0) {
                                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.alreadyInvite")));
                                } else {
                                    player.func_145747_a((IChatComponent)new ChatComponentText(target.func_70005_c_() + " " + StatCollector.func_74838_a((String)"werewolf.message.isLeader")));
                                }
                            } else {
                                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.alreadyPack")));
                            }
                        } else if (this.type == 2) {
                            if (targetProps.getPackID() == props.getPackID()) {
                                targetProps.setPackID(targetProps.getWolfID());
                                PacketDispatcher.sendTo(new WerewolfIDsMessage(target), (EntityPlayerMP)target);
                                howlingData.movePlayer(props.getPackID(), targetProps.getWolfID());
                                target.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.removedPersonal")));
                                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.removed")));
                            } else {
                                player.func_145747_a((IChatComponent)new ChatComponentText(target.func_70005_c_() + " " + StatCollector.func_74838_a((String)"werewolf.message.notIn")));
                            }
                        } else if (this.type == 3) {
                            if (targetProps.getWolfID() == targetProps.getPackID()) {
                                if (targetProps.getInvitedID() == 0) {
                                    if (targetProps.getJoiningPlayer().equals("")) {
                                        targetProps.setJoiningPlayer(player.func_110124_au().toString());
                                        PacketDispatcher.sendTo(new PackJoinMessage(target), (EntityPlayerMP)target);
                                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.sentJoin") + " " + target.func_70005_c_() + StatCollector.func_74838_a((String)"werewolf.message.sentJoin2")));
                                        target.func_145747_a((IChatComponent)new ChatComponentText(player.func_70005_c_() + " " + StatCollector.func_74838_a((String)"werewolf.message.recievedJoin")));
                                    } else {
                                        player.func_145747_a((IChatComponent)new ChatComponentText(target.func_70005_c_() + " " + StatCollector.func_74838_a((String)"werewolf.message.leaderDeciding")));
                                    }
                                } else {
                                    player.func_145747_a((IChatComponent)new ChatComponentText(target.func_70005_c_() + " " + StatCollector.func_74838_a((String)"werewolf.message.alreadyInvite")));
                                }
                            } else {
                                player.func_145747_a((IChatComponent)new ChatComponentText(target.func_70005_c_() + " " + StatCollector.func_74838_a((String)"werewolf.message.notLeader")));
                            }
                        }
                    } else {
                        player.func_145747_a((IChatComponent)new ChatComponentText(target.func_70005_c_() + " " + StatCollector.func_74838_a((String)"werewolf.message.notWolf")));
                    }
                }
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.notOnline")));
            }
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.notFound")));
        }
    }
}

