/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class WereVillage {
    private World worldObj;
    private int tickCounter;
    private int lowerNegative;
    private int packID;
    public boolean dirty;
    private TreeMap playerReputation = new TreeMap();
    private List villageAgressors = new ArrayList();

    public WereVillage() {
    }

    public WereVillage(World world) {
        this.worldObj = world;
    }

    public WereVillage(World world, int num) {
        this.worldObj = world;
        this.packID = num;
        this.lowerNegative = 0;
    }

    public void setWorld(World p_82691_1_) {
        this.worldObj = p_82691_1_;
    }

    public void tick(int ticker) {
        this.tickCounter = ticker;
        if (Math.abs(this.tickCounter - this.lowerNegative) > 1200) {
            this.lowerNegative = this.tickCounter;
            for (String s : this.playerReputation.keySet()) {
                if ((Integer)this.playerReputation.get(s) >= 0) continue;
                this.setReputationForPlayer(s, 1);
            }
        }
        this.removeDeadAndOldAgressors();
    }

    public void addOrRenewAgressor(EntityLivingBase p_75575_1_) {
        WereVillageAgressor villageagressor;
        Iterator iterator = this.villageAgressors.iterator();
        do {
            if (!iterator.hasNext()) {
                this.villageAgressors.add(new WereVillageAgressor(p_75575_1_, this.tickCounter));
                return;
            }
            villageagressor = (WereVillageAgressor)iterator.next();
        } while (villageagressor.agressor != p_75575_1_);
        villageagressor.agressionTime = this.tickCounter;
    }

    public EntityLivingBase findNearestVillageAggressor(EntityLivingBase p_75571_1_) {
        double d0 = Double.MAX_VALUE;
        WereVillageAgressor villageagressor = null;
        for (int i = 0; i < this.villageAgressors.size(); ++i) {
            WereVillageAgressor villageagressor1 = (WereVillageAgressor)this.villageAgressors.get(i);
            double d1 = villageagressor1.agressor.func_70068_e((Entity)p_75571_1_);
            if (!(d1 <= d0)) continue;
            villageagressor = villageagressor1;
            d0 = d1;
        }
        return villageagressor != null ? villageagressor.agressor : null;
    }

    public EntityPlayer attackPlayer(EntityLivingBase p_82685_1_) {
        double d0 = Double.MAX_VALUE;
        EntityPlayer entityplayer = null;
        for (String s : this.playerReputation.keySet()) {
            double d1;
            EntityPlayer entityplayer1;
            if (!this.isPlayerReputationTooLow(s) || (entityplayer1 = this.worldObj.func_72924_a(s)) == null || !((d1 = entityplayer1.func_70068_e((Entity)p_82685_1_)) <= d0)) continue;
            entityplayer = entityplayer1;
            d0 = d1;
        }
        return entityplayer;
    }

    private void removeDeadAndOldAgressors() {
        Iterator iterator = this.villageAgressors.iterator();
        while (iterator.hasNext()) {
            WereVillageAgressor villageagressor = (WereVillageAgressor)iterator.next();
            if (villageagressor.agressor.func_70089_S() && Math.abs(this.tickCounter - villageagressor.agressionTime) <= 300) continue;
            iterator.remove();
        }
    }

    public int getReputationForPlayer(String p_82684_1_) {
        Integer integer = (Integer)this.playerReputation.get(p_82684_1_);
        return integer != null ? integer : 0;
    }

    public int setReputationForPlayer(String p_82688_1_, int p_82688_2_) {
        int j = this.getReputationForPlayer(p_82688_1_);
        int k = MathHelper.func_76125_a((int)(j + p_82688_2_), (int)-50, (int)100);
        this.playerReputation.put(p_82688_1_, k);
        this.dirty = true;
        return k;
    }

    public boolean isPlayerReputationTooLow(String p_82687_1_) {
        return this.getReputationForPlayer(p_82687_1_) <= -15;
    }

    public void readWereVillageDataFromNBT(NBTTagCompound p_82690_1_) {
        this.tickCounter = p_82690_1_.func_74762_e("Tick");
        this.packID = p_82690_1_.func_74762_e("PackID");
        NBTTagList nbttaglist1 = p_82690_1_.func_150295_c("Players", 10);
        for (int j = 0; j < nbttaglist1.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound2 = nbttaglist1.func_150305_b(j);
            this.playerReputation.put(nbttagcompound2.func_74779_i("Name"), nbttagcompound2.func_74762_e("S"));
        }
    }

    public void writeWereVillageDataToNBT(NBTTagCompound p_82689_1_) {
        p_82689_1_.func_74768_a("Tick", this.tickCounter);
        p_82689_1_.func_74768_a("PackID", this.packID);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (String s : this.playerReputation.keySet()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.func_74778_a("Name", s);
            nbttagcompound2.func_74768_a("S", ((Integer)this.playerReputation.get(s)).intValue());
            nbttaglist1.func_74742_a((NBTBase)nbttagcompound2);
        }
        p_82689_1_.func_74782_a("Players", (NBTBase)nbttaglist1);
    }

    public void setDefaultPlayerReputation(int p_82683_1_) {
        for (String s : this.playerReputation.keySet()) {
            this.setReputationForPlayer(s, p_82683_1_);
        }
    }

    class WereVillageAgressor {
        public EntityLivingBase agressor;
        public int agressionTime;

        WereVillageAgressor(EntityLivingBase p_i1674_2_, int p_i1674_3_) {
            this.agressor = p_i1674_2_;
            this.agressionTime = p_i1674_3_;
        }
    }
}

