/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.raz.howlingmoon.handler.ConfigHandler;
import com.raz.howlingmoon.packets.PacketDispatcher;
import com.raz.howlingmoon.packets.SetPlayerHitBox;
import com.raz.howlingmoon.packets.SyncHungerMessage;
import com.raz.howlingmoon.packets.SyncSavageryMessage;
import com.raz.howlingmoon.packets.SyncTransformMessage;
import com.raz.howlingmoon.packets.SyncWerewolfPropsMessage;
import com.raz.howlingmoon.packets.TrackingMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.fml.relauncher.Side;

public class WerewolfPlayer
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "WerewolfPlayer";
    private final EntityPlayer player;
    public Multimap<String, AttributeModifier> attributes = HashMultimap.create();
    public AttributeModifier t2Modifier;
    private int savagery;
    private boolean isWerewolf;
    private boolean isTransformed;
    private boolean nightVisionOn;
    private boolean wolfPickupOn;
    private int werewolfTexture;
    private int werewolfModel;
    private int howlState;
    private int leapState;
    private int climbState;
    private int visionState;
    private int hungerState;
    private int sneakJump;
    private int sprintJump;
    private int sprintClimb;
    private int fatLevel;
    private boolean climb;
    private int wolfID;
    private int packID;
    private int invitedID;
    private String joiningPlayer;
    private int updatedSavA;
    private int updatedSavT;
    private boolean peaceful;
    private boolean preventTransform;
    public int transformedHunger;
    public int infected;
    public int werewolfHunger;
    public boolean displayRage;
    public ItemStack equippedItem;
    public boolean gotBook;
    public boolean packFF;
    public int howlCooldown;
    public Entity target;
    public int targetID;
    public boolean trackAll;
    public boolean howlAttention;
    public int howlTick;
    public int hungerTick;
    public boolean t2Knockback;
    public int rally;
    public int berserkLevel;
    public boolean repelEntities;
    public boolean leap;
    public int berserkTime;
    public int abilitySlot1;
    public int abilitySlot2;
    public List<Integer> packFollowers;

    public WerewolfPlayer(EntityPlayer player) {
        this.player = player;
        this.isWerewolf = false;
        this.isTransformed = false;
        this.nightVisionOn = false;
        this.wolfPickupOn = false;
        this.displayRage = false;
        this.gotBook = false;
        this.howlState = 1;
        this.leapState = 1;
        this.climbState = 2;
        this.visionState = 0;
        this.sneakJump = 2;
        this.sprintJump = 2;
        this.sprintClimb = 0;
        this.transformedHunger = 0;
        this.werewolfHunger = 0;
        this.savagery = 0;
        this.infected = 0;
        this.werewolfTexture = 0;
        this.werewolfModel = 1;
        this.hungerState = 1;
        this.climb = false;
        this.packFF = false;
        this.wolfID = 0;
        this.packID = 0;
        this.invitedID = 0;
        this.joiningPlayer = "";
        this.updatedSavA = 0;
        this.updatedSavT = 0;
        this.peaceful = false;
        this.preventTransform = false;
        this.howlCooldown = 0;
        this.target = null;
        this.targetID = 0;
        this.trackAll = true;
        this.fatLevel = 0;
        this.howlAttention = false;
        this.howlTick = 0;
        this.hungerTick = 0;
        this.rally = 0;
        this.berserkTime = 0;
        this.berserkLevel = 0;
        this.leap = false;
        this.abilitySlot1 = 1;
        this.abilitySlot2 = 0;
        this.repelEntities = false;
        this.packFollowers = new ArrayList<Integer>();
        this.t2Knockback = false;
        this.t2Modifier = new AttributeModifier(UUID.fromString("fc1af77f-2c52-4ba6-b722-7d3097162cf9"), "Tier2 modifier", 1.0, 0);
        this.attributes.clear();
        this.attributes.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)this.t2Modifier);
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new WerewolfPlayer(player));
    }

    public static final WerewolfPlayer get(EntityPlayer player) {
        return (WerewolfPlayer)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void copy(WerewolfPlayer props) {
        this.isWerewolf = props.isWerewolf;
        this.isTransformed = false;
        this.nightVisionOn = props.nightVisionOn;
        this.wolfPickupOn = props.wolfPickupOn;
        this.savagery = props.savagery;
        this.werewolfTexture = props.werewolfTexture;
        this.werewolfModel = props.werewolfModel;
        this.infected = props.infected;
        this.leapState = props.leapState;
        this.climbState = props.climbState;
        this.visionState = props.visionState;
        this.hungerState = props.hungerState;
        this.gotBook = props.gotBook;
        this.trackAll = props.trackAll;
        this.packFF = props.packFF;
        this.wolfID = props.wolfID;
        this.packID = props.packID;
        this.invitedID = props.invitedID;
        this.joiningPlayer = props.joiningPlayer;
        this.updatedSavT = 0;
        this.abilitySlot1 = props.abilitySlot1;
        this.abilitySlot2 = props.abilitySlot2;
        if (ConfigHandler.extraMechanics) {
            this.fatLevel = props.fatLevel;
        }
        this.packFollowers = props.packFollowers;
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74757_a("IsWerewolf", this.isWerewolf);
        properties.func_74757_a("IsTransformed", this.isTransformed);
        properties.func_74757_a("NightVisionOn", this.nightVisionOn);
        properties.func_74757_a("WolfPickupOn", this.wolfPickupOn);
        properties.func_74757_a("GotBook", this.gotBook);
        properties.func_74768_a("Savagery", this.savagery);
        properties.func_74768_a("WerewolfTexture", this.werewolfTexture);
        properties.func_74768_a("WerewolfModel", this.werewolfModel);
        properties.func_74768_a("Infected", this.infected);
        properties.func_74768_a("TransformedHunger", this.transformedHunger);
        properties.func_74768_a("HowlState", this.howlState);
        properties.func_74768_a("LeapState", this.leapState);
        properties.func_74768_a("ClimbState", this.climbState);
        properties.func_74768_a("VisionState", this.visionState);
        properties.func_74768_a("HungerState", this.hungerState);
        properties.func_74768_a("SneakJump", this.sneakJump);
        properties.func_74768_a("SprintJump", this.sprintJump);
        properties.func_74768_a("SprintClimb", this.sprintClimb);
        properties.func_74757_a("PackFF", this.packFF);
        properties.func_74768_a("WolfID", this.wolfID);
        properties.func_74768_a("PackID", this.packID);
        properties.func_74768_a("InvitedID", this.invitedID);
        if (ConfigHandler.extraMechanics) {
            properties.func_74768_a("FatLevel", this.fatLevel);
        }
        properties.func_74757_a("TrackAll", this.trackAll);
        properties.func_74768_a("BeserkTime", this.berserkTime);
        properties.func_74768_a("AbilitySlot1", this.abilitySlot1);
        properties.func_74768_a("AbilitySlot2", this.abilitySlot2);
        compound.func_74782_a(EXT_PROP_NAME, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(EXT_PROP_NAME);
        this.savagery = properties.func_74762_e("Savagery");
        this.isWerewolf = properties.func_74767_n("IsWerewolf");
        this.isTransformed = properties.func_74767_n("IsTransformed");
        this.nightVisionOn = properties.func_74767_n("NightVisionOn");
        this.wolfPickupOn = properties.func_74767_n("WolfPickupOn");
        this.gotBook = properties.func_74767_n("GotBook");
        this.werewolfTexture = properties.func_74762_e("WerewolfTexture");
        this.werewolfModel = properties.func_74762_e("WerewolfModel");
        this.infected = properties.func_74762_e("Infected");
        this.transformedHunger = properties.func_74762_e("TransformedHunger");
        this.howlState = properties.func_74762_e("HowlState");
        this.leapState = properties.func_74762_e("LeapState");
        this.climbState = properties.func_74762_e("ClimbState");
        this.visionState = properties.func_74762_e("VisionState");
        this.hungerState = properties.func_74762_e("HungerState");
        this.sneakJump = properties.func_74762_e("SneakJump");
        this.sprintJump = properties.func_74762_e("SprintJump");
        this.sprintClimb = properties.func_74762_e("SprintClimb");
        this.packFF = properties.func_74767_n("PackFF");
        this.wolfID = properties.func_74762_e("WolfID");
        this.packID = properties.func_74762_e("PackID");
        this.invitedID = properties.func_74762_e("InvitedID");
        if (this.invitedID > 0) {
            this.invitedID = 0;
        }
        if (ConfigHandler.extraMechanics) {
            this.fatLevel = properties.func_74762_e("FatLevel");
        }
        this.trackAll = properties.func_74767_n("TrackAll");
        this.berserkTime = properties.func_74762_e("BeserkTime");
        this.abilitySlot1 = properties.func_74762_e("AbilitySlot1");
        this.abilitySlot2 = properties.func_74762_e("AbilitySlot2");
        if (this.isTransformed) {
            this.player.field_70131_O = this.getModelHeight();
            this.player.func_174826_a(new AxisAlignedBB(this.player.func_174813_aQ().field_72340_a, this.player.func_174813_aQ().field_72338_b, this.player.func_174813_aQ().field_72339_c, this.player.func_174813_aQ().field_72340_a + (double)this.player.field_70130_N, this.player.func_174813_aQ().field_72338_b + (double)this.player.field_70131_O, this.player.func_174813_aQ().field_72339_c + (double)this.player.field_70130_N));
        }
    }

    public void readSummon(NBTTagCompound nbt) {
        NBTTagList tagListNum = nbt.func_150295_c("SummonMembers", 10);
        if (!this.packFollowers.isEmpty()) {
            this.packFollowers.clear();
        }
        for (int i = 0; i < tagListNum.func_74745_c(); ++i) {
            NBTTagCompound tag = tagListNum.func_150305_b(i);
            int n = tag.func_74762_e("PackNum" + i);
            this.packFollowers.add(n);
        }
    }

    public void writeSummon(NBTTagCompound nbt) {
        NBTTagList tagListNum = new NBTTagList();
        for (int i = 0; i < this.packFollowers.size(); ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("PackNum" + i, this.packFollowers.get(i).intValue());
            tagListNum.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("SummonMembers", (NBTBase)tagListNum);
    }

    public void init(Entity entity, World world) {
    }

    public boolean getWerewolf() {
        return this.isWerewolf;
    }

    public void setWerewolf(boolean state) {
        if (this.isWerewolf != state) {
            this.isWerewolf = state;
            if (state) {
                this.setSavagery(5000);
                this.infected = 2;
            } else {
                this.setSavagery(0);
                this.setTransformedServer(false);
                this.infected = 0;
            }
            this.displayRage = false;
            PacketDispatcher.sendTo(new SyncWerewolfPropsMessage(this.player), (EntityPlayerMP)this.player);
        }
    }

    public boolean getTransformed() {
        return this.isTransformed;
    }

    public void tryTransformed() {
        if (this.player.field_70170_p.func_130001_d() != 1.0f || this.player.field_70170_p.func_72935_r() || !ConfigHandler.moonTransform) {
            if (this.isTransformed) {
                if (this.transformedHunger > 0 && !this.player.field_71075_bZ.field_75098_d && ConfigHandler.secondaryHunger) {
                    this.player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.exithungry")));
                    int strength = this.transformedHunger * 100;
                    this.player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, strength, 0, true, false));
                    this.player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, strength, 0, true, false));
                    this.player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, strength, 0, true, false));
                    this.player.func_71020_j((float)this.transformedHunger * 3.0f);
                    this.addSavagery(-(strength / 25));
                } else {
                    this.transformedHunger = 0;
                }
                this.isTransformed = false;
                if (this.player.func_82165_m(Potion.field_76439_r.field_76415_H) && this.player.func_70660_b(Potion.field_76439_r).func_76459_b() < 311) {
                    this.player.func_82170_o(Potion.field_76439_r.field_76415_H);
                }
                PacketDispatcher.sendTo(new SyncTransformMessage(this.player), (EntityPlayerMP)this.player);
                PacketDispatcher.sendTo(new SyncHungerMessage(this.player), (EntityPlayerMP)this.player);
            } else if (!(this.preventTransform || this.player.field_70170_p.func_72935_r() && ConfigHandler.nightsOnly)) {
                this.isTransformed = true;
                this.transformedHunger = this.getMaxHunger();
                PacketDispatcher.sendTo(new SyncTransformMessage(this.player), (EntityPlayerMP)this.player);
            }
            PacketDispatcher.sendTo(new SetPlayerHitBox(this.player, this.getModelHeight()), (EntityPlayerMP)this.player);
            Set players = ((WorldServer)this.player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this.player);
            PacketDispatcher.sendToPlayers(new TrackingMessage(this.player), players);
        } else {
            this.player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.exitmoon")));
        }
    }

    public void setTransformed(boolean state, Side side) {
        boolean temp = this.isTransformed;
        this.isTransformed = state;
        if (side.isServer()) {
            PacketDispatcher.sendTo(new SyncTransformMessage(this.player), (EntityPlayerMP)this.player);
            PacketDispatcher.sendTo(new SetPlayerHitBox(this.player, this.getModelHeight()), (EntityPlayerMP)this.player);
            if (state && !temp) {
                this.player.func_71024_bL().func_75113_a(5.0f * (float)this.getTierInt());
                this.transformedHunger = this.getMaxHunger();
            } else if (!state && temp && this.transformedHunger > 0 && !this.player.field_71075_bZ.field_75098_d && ConfigHandler.secondaryHunger) {
                this.player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.exithungry")));
                int strength = this.transformedHunger * 100;
                this.player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, strength, 0, true, false));
                this.player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, strength, 0, true, false));
                this.player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, strength, 0, true, false));
                this.player.func_71020_j((float)this.transformedHunger * 3.0f);
                this.addSavagery(-(strength / 25));
            }
            Set players = ((WorldServer)this.player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this.player);
            PacketDispatcher.sendToPlayers(new TrackingMessage(this.player), players);
        } else if (state && !temp) {
            this.transformedHunger = this.getMaxHunger();
        }
    }

    public void setTransformedServer(boolean state) {
        boolean temp = this.isTransformed;
        this.isTransformed = state;
        PacketDispatcher.sendTo(new SyncTransformMessage(this.player), (EntityPlayerMP)this.player);
        PacketDispatcher.sendTo(new SetPlayerHitBox(this.player, this.getModelHeight()), (EntityPlayerMP)this.player);
        if (state && !temp) {
            this.player.func_71024_bL().func_75113_a(5.0f * (float)this.getTierInt());
            this.transformedHunger = this.getMaxHunger();
        } else if (!state && temp && this.transformedHunger > 0 && !this.player.field_71075_bZ.field_75098_d && ConfigHandler.secondaryHunger) {
            this.player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.exithungry")));
            int strength = this.transformedHunger * 100;
            this.player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, strength, 0, true, false));
            this.player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, strength, 0, true, false));
            this.player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, strength, 0, true, false));
            this.player.func_71020_j((float)this.transformedHunger * 3.0f);
            this.addSavagery(-(strength / 25));
        }
        Set players = ((WorldServer)this.player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this.player);
        PacketDispatcher.sendToPlayers(new TrackingMessage(this.player), players);
    }

    public boolean getNightVisionOn() {
        return this.nightVisionOn;
    }

    public void setNightVisionOn(boolean state) {
        this.nightVisionOn = state;
    }

    public boolean getWolfPickupOn() {
        return this.wolfPickupOn;
    }

    public void setWolfPickupOn(boolean state) {
        this.wolfPickupOn = state;
    }

    public String getTier() {
        if (this.savagery < 2500) {
            return StatCollector.func_74838_a((String)"werewolf.menu.title1");
        }
        if (this.savagery < 5000) {
            return StatCollector.func_74838_a((String)"werewolf.menu.title2");
        }
        if (this.savagery < 7500) {
            return StatCollector.func_74838_a((String)"werewolf.menu.title3");
        }
        if (this.savagery < 10000) {
            return StatCollector.func_74838_a((String)"werewolf.menu.title4");
        }
        return StatCollector.func_74838_a((String)"werewolf.menu.title5");
    }

    public int getTierInt() {
        if (this.savagery > 9999) {
            return 4;
        }
        if (this.savagery > 7499 || this.getUpdatedSavT() != 0) {
            return 3;
        }
        if (this.savagery > 4999) {
            return 2;
        }
        if (this.savagery > 2499) {
            return 1;
        }
        return 0;
    }

    public int getTierIntInverse() {
        if (this.savagery < 2500) {
            return 6;
        }
        if (this.savagery < 5000) {
            return 5;
        }
        if (this.savagery < 7500) {
            return 4;
        }
        if (this.savagery < 10000) {
            return 3;
        }
        return 2;
    }

    public int getTierAbility() {
        if (this.savagery < 2500) {
            return 1 + this.updatedSavA;
        }
        if (this.savagery < 5000) {
            return 2 + this.updatedSavA;
        }
        if (this.savagery < 7500) {
            return 3 + this.updatedSavA;
        }
        if (this.savagery < 10000) {
            return 4 + this.updatedSavA;
        }
        return 5 + this.updatedSavA;
    }

    public int getTexture() {
        return this.werewolfTexture;
    }

    public void setTexture(int i) {
        this.werewolfTexture = i;
    }

    public void setTexture(int i, Side side) {
        this.werewolfTexture = i;
        if (side.isServer() && this.isTransformed) {
            Set players = ((WorldServer)this.player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this.player);
            PacketDispatcher.sendToPlayers(new TrackingMessage(this.player), players);
        }
    }

    public String getTextureName() {
        switch (this.werewolfTexture) {
            case 0: {
                return StatCollector.func_74838_a((String)"werewolf.menu.texture.white");
            }
            case 1: {
                return StatCollector.func_74838_a((String)"werewolf.menu.texture.black");
            }
            case 2: {
                return StatCollector.func_74838_a((String)"werewolf.menu.texture.timber");
            }
            case 3: {
                return "Killerwolf";
            }
            case 4: {
                return StatCollector.func_74838_a((String)"werewolf.menu.texture.old.gray");
            }
            case 5: {
                return StatCollector.func_74838_a((String)"werewolf.menu.texture.old.black");
            }
            case 6: {
                return StatCollector.func_74838_a((String)"werewolf.menu.texture.old.red");
            }
        }
        return StatCollector.func_74838_a((String)"werewolf.menu.texture.custom") + (this.werewolfTexture - 6);
    }

    public int getModel() {
        return this.werewolfModel;
    }

    public void setModel(int i) {
        this.werewolfModel = i;
    }

    public void setModel(int i, Side side) {
        this.werewolfModel = i;
        if (side.isServer() && this.isTransformed) {
            Set players = ((WorldServer)this.player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this.player);
            PacketDispatcher.sendToPlayers(new TrackingMessage(this.player), players);
        }
    }

    public String getModelName() {
        if (this.werewolfModel == 0) {
            return StatCollector.func_74838_a((String)"werewolf.menu.model.normal");
        }
        if (this.werewolfModel == 1) {
            return StatCollector.func_74838_a((String)"werewolf.menu.model.wolf");
        }
        if (this.werewolfModel == 2) {
            return StatCollector.func_74838_a((String)"werewolf.menu.model.beast");
        }
        if (this.werewolfModel == 3) {
            return StatCollector.func_74838_a((String)"werewolf.menu.model.dire");
        }
        return "Error";
    }

    public void addSavagery(int amount) {
        int temp = this.savagery;
        this.savagery += amount;
        if (this.savagery < 0) {
            this.savagery = 0;
        } else if (this.savagery > 10500) {
            this.savagery = 10500;
        }
        if (temp != this.savagery) {
            PacketDispatcher.sendTo(new SyncSavageryMessage(this.player), (EntityPlayerMP)this.player);
        }
    }

    public void addSavagery(int amount, Side side) {
        int temp = this.savagery;
        this.savagery += amount;
        if (this.savagery < 0) {
            this.savagery = 0;
        } else if (this.savagery > 10500) {
            this.savagery = 10500;
        }
        if (side.isServer() && temp != this.savagery) {
            PacketDispatcher.sendTo(new SyncSavageryMessage(this.player), (EntityPlayerMP)this.player);
        }
    }

    public void setSavagery(int amount) {
        this.savagery = amount;
        PacketDispatcher.sendTo(new SyncSavageryMessage(this.player), (EntityPlayerMP)this.player);
    }

    public void setSavagery(int amount, Side side) {
        this.savagery = amount;
        if (side.isServer()) {
            PacketDispatcher.sendTo(new SyncSavageryMessage(this.player), (EntityPlayerMP)this.player);
        }
    }

    public int getSavagery() {
        return this.savagery;
    }

    public int getHowlState() {
        return this.howlState;
    }

    public void setHowlState(int state) {
        this.howlState = state;
    }

    public int getLeapState() {
        return this.leapState;
    }

    public void setLeapState(int state) {
        this.leapState = state;
    }

    public int getClimbState() {
        return this.climbState;
    }

    public void setClimbState(int state) {
        this.climbState = state;
    }

    public int getVisionState() {
        return this.visionState;
    }

    public void setVisionState(int state) {
        this.visionState = state;
    }

    public int getHungerState() {
        return this.hungerState;
    }

    public void setHungerState(int state) {
        this.hungerState = state;
    }

    public String getHungerButtonName() {
        if (this.hungerState == 1) {
            return StatCollector.func_74838_a((String)"werewolf.menu.hunger.transformed");
        }
        if (this.hungerState == 2) {
            return StatCollector.func_74838_a((String)"werewolf.menu.hunger.always");
        }
        return StatCollector.func_74838_a((String)"werewolf.menu.off");
    }

    public int getMaxHunger() {
        if (this.isTransformed) {
            return this.getTierInt() * 3;
        }
        return this.getTierIntInverse() * 9;
    }

    public void addTransformedHunger(int amount) {
        this.transformedHunger += amount;
        if (this.transformedHunger > this.getMaxHunger()) {
            this.transformedHunger = this.getMaxHunger();
        }
        PacketDispatcher.sendTo(new SyncHungerMessage(this.player), (EntityPlayerMP)this.player);
    }

    public void addNonTransformHunger(int amount, boolean packet) {
        this.transformedHunger += amount;
        if (this.transformedHunger > this.getMaxHunger()) {
            this.transformedHunger = this.getMaxHunger();
        } else if (this.transformedHunger < 0) {
            this.transformedHunger = 0;
        }
        if (packet) {
            PacketDispatcher.sendTo(new SyncHungerMessage(this.player), (EntityPlayerMP)this.player);
        }
    }

    public boolean getPeaceful() {
        return this.peaceful;
    }

    public void setPeaceful(boolean set) {
        this.peaceful = set;
    }

    public boolean getPreventTransform() {
        return this.preventTransform;
    }

    public void setPreventTransform(boolean set) {
        this.preventTransform = set;
    }

    public int getUpdatedSavA() {
        return this.updatedSavA;
    }

    public void setUpdatedSavA(int set) {
        this.updatedSavA = set;
    }

    public int getUpdatedSavT() {
        return this.updatedSavT;
    }

    public void setUpdatedSavT(int set) {
        this.updatedSavT = set;
    }

    public boolean getClimb() {
        return this.climb;
    }

    public void setClimb(boolean set) {
        this.climb = set;
    }

    public void setWolfID(int id) {
        this.wolfID = id;
    }

    public int getWolfID() {
        return this.wolfID;
    }

    public void setPackID(int id) {
        this.packID = id;
    }

    public int getPackID() {
        return this.packID;
    }

    public void setInvitedID(int id) {
        this.invitedID = id;
    }

    public int getInvitedID() {
        return this.invitedID;
    }

    public void setJoiningPlayer(String id) {
        this.joiningPlayer = id;
    }

    public String getJoiningPlayer() {
        return this.joiningPlayer;
    }

    public boolean isFat() {
        return this.fatLevel > 99;
    }

    public void addFatLevel(int f) {
        if (ConfigHandler.extraMechanics) {
            this.fatLevel += f;
        }
    }

    public void setFatLevel(int f) {
        this.fatLevel = f;
    }

    public int getFatLevel() {
        return this.fatLevel;
    }

    public int getFatTier() {
        return (int)Math.floor(this.fatLevel / 100);
    }

    public float getFatEffect() {
        if (this.fatLevel < 100) {
            return 1.0f;
        }
        if (this.fatLevel < 200) {
            return 0.75f;
        }
        if (this.fatLevel < 300) {
            return 0.6f;
        }
        if (this.fatLevel < 400) {
            return 0.5f;
        }
        if (this.fatLevel < 500) {
            return 0.4f;
        }
        return 0.25f;
    }

    public int getAbilitySlot1Col() {
        if (this.abilitySlot1 > 7) {
            return this.abilitySlot1 - 8;
        }
        return this.abilitySlot1;
    }

    public int getAbilitySlot2Col() {
        if (this.abilitySlot2 > 7) {
            return this.abilitySlot2 - 8;
        }
        return this.abilitySlot2;
    }

    public int getSneakJump() {
        return this.sneakJump;
    }

    public void setSneakJump(int state) {
        this.sneakJump = state;
    }

    public int getSprintJump() {
        return this.sprintJump;
    }

    public void setSprintJump(int state) {
        this.sprintJump = state;
    }

    public int getSprintClimb() {
        return this.sprintClimb;
    }

    public void setSprintClimb(int state) {
        this.sprintClimb = state;
    }

    public float getModelHeight() {
        if (this.isTransformed) {
            switch (this.werewolfModel) {
                case 0: {
                    return 1.8f;
                }
                case 1: {
                    return 1.8f;
                }
                case 2: {
                    return 2.8f;
                }
                case 3: {
                    return 0.9f;
                }
            }
            return 1.8f;
        }
        return 1.8f;
    }
}

