/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.raz.howlingmoon.WerewolfPlayer;
import com.raz.howlingmoon.entities.EntityTameWere;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.world.EnumDifficulty;

public class EntityAINearestNonWerewolfTarget<T extends EntityLivingBase>
extends EntityAITarget {
    private EntityTameWere theTameable;
    protected final Class<T> targetClass;
    private final int targetChance;
    protected final EntityAINearestAttackableTarget.Sorter theNearestAttackableTargetSorter;
    protected Predicate<? super T> targetEntitySelector;
    private EntityLivingBase targetEntity;

    public EntityAINearestNonWerewolfTarget(EntityTameWere p_i1663_1_, Class target, int p_i1663_3_, boolean p_i1663_4_) {
        this(p_i1663_1_, target, p_i1663_3_, p_i1663_4_, false);
    }

    public EntityAINearestNonWerewolfTarget(EntityTameWere p_i1664_1_, Class target, int p_i1664_3_, boolean p_i1664_4_, boolean p_i1664_5_) {
        this(p_i1664_1_, target, p_i1664_3_, p_i1664_4_, p_i1664_5_, null);
    }

    public EntityAINearestNonWerewolfTarget(EntityTameWere p_i1665_1_, Class target, int p_i1665_3_, boolean p_i1665_4_, boolean p_i1665_5_, final Predicate p_i1665_6_) {
        super((EntityCreature)p_i1665_1_, p_i1665_4_, p_i1665_5_);
        this.theTameable = p_i1665_1_;
        this.targetClass = target;
        this.targetChance = p_i1665_3_;
        this.theNearestAttackableTargetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)p_i1665_1_);
        this.func_75248_a(1);
        this.targetEntitySelector = new Predicate(){

            public boolean func_179878_a(EntityLivingBase p_179878_1_) {
                if (p_i1665_6_ != null && !p_i1665_6_.apply((Object)p_179878_1_)) {
                    return false;
                }
                if (p_179878_1_ instanceof EntityPlayer) {
                    if (WerewolfPlayer.get((EntityPlayer)p_179878_1_).getWerewolf() || !EntityAINearestNonWerewolfTarget.this.theTameable.doesAttackPlayers()) {
                        return false;
                    }
                    double d0 = EntityAINearestNonWerewolfTarget.this.func_111175_f();
                    if (p_179878_1_.func_70093_af()) {
                        d0 *= (double)0.8f;
                    }
                    if (p_179878_1_.func_82150_aj()) {
                        float f = ((EntityPlayer)p_179878_1_).func_82243_bO();
                        if (f < 0.1f) {
                            f = 0.1f;
                        }
                        d0 *= (double)(0.7f * f);
                    }
                    if ((double)p_179878_1_.func_70032_d((Entity)EntityAINearestNonWerewolfTarget.this.field_75299_d) > d0) {
                        return false;
                    }
                } else if (p_179878_1_ instanceof EntityWolf || p_179878_1_ instanceof EntityAnimal && !EntityAINearestNonWerewolfTarget.this.theTameable.doesAttackAnimals() || p_179878_1_ instanceof EntityVillager && !EntityAINearestNonWerewolfTarget.this.theTameable.doesAttackVillagers() || p_179878_1_ instanceof EntitySkeleton && !EntityAINearestNonWerewolfTarget.this.theTameable.doesAttackBones()) {
                    return false;
                }
                return EntityAINearestNonWerewolfTarget.this.func_75296_a(p_179878_1_, false);
            }

            public boolean apply(Object p_apply_1_) {
                return this.func_179878_a((EntityLivingBase)p_apply_1_);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.field_75299_d.func_70638_az();
        if (this.theTameable.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        if (this.targetChance > 0 && this.field_75299_d.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        if (this.theTameable.isTamed() && !(entitylivingbase instanceof EntitySkeleton) && (!this.theTameable.needsToFeed() || entitylivingbase instanceof EntityPlayer && this.theTameable.getSavageryLevel() != 5)) {
            EntityLivingBase owner = this.theTameable.getOwnerEntity();
            if (owner == null) return false;
            if (!(owner instanceof EntityPlayer)) return false;
            if (this.theTameable.getHunger() >= 19 || this.theTameable.isSubmissve() || this.theTameable.getSavageryLevel() <= WerewolfPlayer.get((EntityPlayer)owner).getTierInt() + 2) {
                return false;
            }
        }
        if (entitylivingbase instanceof EntityAnimal && !this.theTameable.doesAttackAnimals() || entitylivingbase instanceof EntityVillager && !this.theTameable.doesAttackVillagers() || entitylivingbase instanceof EntityPlayer && !this.theTameable.doesAttackPlayers() || entitylivingbase instanceof EntitySkeleton && !this.theTameable.doesAttackBones()) {
            return false;
        }
        double d0 = this.func_111175_f();
        List list = this.field_75299_d.field_70170_p.func_175647_a(this.targetClass, this.field_75299_d.func_174813_aQ().func_72314_b(d0, 4.0, d0), Predicates.and(this.targetEntitySelector, (Predicate)EntitySelectors.field_180132_d));
        Collections.sort(list, this.theNearestAttackableTargetSorter);
        if (list.isEmpty()) {
            return false;
        }
        this.targetEntity = (EntityLivingBase)list.get(0);
        return true;
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    public static class Sorter
    implements Comparator {
        private final Entity theEntity;

        public Sorter(Entity p_i1662_1_) {
            this.theEntity = p_i1662_1_;
        }

        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }

        public int compare(Object p_compare_1_, Object p_compare_2_) {
            return this.compare((Entity)p_compare_1_, (Entity)p_compare_2_);
        }
    }
}

