/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.entities;

import com.raz.howlingmoon.HowlingWorldData;
import com.raz.howlingmoon.Werewolf;
import com.raz.howlingmoon.WerewolfPlayer;
import com.raz.howlingmoon.ai.EntityAIFollowPackLeader;
import com.raz.howlingmoon.ai.EntityAINearestNonWerewolfTarget;
import com.raz.howlingmoon.ai.EntityAIOwnerWereHurtByTarget;
import com.raz.howlingmoon.ai.EntityAIOwnerWereHurtTarget;
import com.raz.howlingmoon.ai.EntityAIWereBeg;
import com.raz.howlingmoon.entities.EntityTameWere;
import com.raz.howlingmoon.items.ItemCurePotion;
import com.raz.howlingmoon.packets.PacketDispatcher;
import com.raz.howlingmoon.packets.SyncInfectedMessage;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityAlphaWolf
extends EntityTameWere {
    private float field_70926_e;
    private float field_70924_f;

    public EntityAlphaWolf(World p_i1738_1_) {
        super(p_i1738_1_);
        this.setupAI();
        this.setTamed(false);
        this.func_70105_a(1.0f, 1.0f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        if (this.hasAgile()) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.45);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        }
        if (this.hasKnockbackResistance()) {
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    protected void setupAI() {
        if (this.getAvoidWater()) {
            ((PathNavigateGround)this.func_70661_as()).func_179690_a(true);
        }
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowPackLeader(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWereBeg(this, 40.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerWereHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerWereHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new EntityAINearestNonWerewolfTarget(this, EntityPlayer.class, 0, false));
        this.field_70715_bh.func_75776_a(5, new EntityAINearestNonWerewolfTarget(this, EntityAnimal.class, 10, false));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySkeleton.class, false));
    }

    protected void clearAITasks() {
        this.field_70714_bg.field_75782_a.clear();
        this.field_70715_bh.field_75782_a.clear();
    }

    public void func_70624_b(EntityLivingBase p_70624_1_) {
        super.func_70624_b(p_70624_1_);
        if (p_70624_1_ == null) {
            this.setAngry(false);
        } else {
            this.setAngry(true);
        }
    }

    @Override
    public boolean func_70652_k(Entity entityTarget) {
        boolean flag;
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityTarget instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_152377_a((ItemStack)this.func_70694_bm(), (EnumCreatureAttribute)((EntityLivingBase)entityTarget).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
            if (this.hasKnockback()) {
                i += 2;
            }
        }
        if (flag = entityTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage)) {
            int j;
            if (i > 0) {
                entityTarget.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityTarget.func_70015_d(j * 4);
            }
            if (entityTarget instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entityTarget), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entityTarget);
            if (entityTarget instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entityTarget;
                WerewolfPlayer props = WerewolfPlayer.get(player);
                if (!props.getWerewolf() && props.infected == 0) {
                    ((EntityPlayer)entityTarget).func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 310, 0, true, false));
                    props.infected = 1;
                    PacketDispatcher.sendTo(new SyncInfectedMessage(player), (EntityPlayerMP)player);
                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"werewolf.message.infected")));
                } else if (props.getPackID() == this.getPackID()) {
                    this.func_70624_b(null);
                }
            } else if (entityTarget instanceof EntityTameWere && this.getPackID() == ((EntityTameWere)entityTarget).getPackID()) {
                this.func_70624_b(null);
            }
        }
        return flag;
    }

    public float getInterestedAngle(float p_70917_1_) {
        return (this.field_70924_f + (this.field_70926_e - this.field_70924_f) * p_70917_1_) * 0.15f * (float)Math.PI;
    }

    @Override
    public boolean func_70601_bi() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
        return (this.field_70163_u > 60.0 || this.field_70170_p.func_175678_i(blockpos)) && super.func_70601_bi();
    }

    protected boolean func_70692_ba() {
        return !this.isTamed() && this.field_70173_aa > 1200;
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemFood itemfood;
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (this.isTamed()) {
            if (itemstack != null) {
                if (itemstack.func_77973_b() instanceof ItemFood) {
                    ItemFood itemfood2 = (ItemFood)itemstack.func_77973_b();
                    if (itemfood2.func_77845_h() && (this.func_110143_aJ() < this.func_110138_aP() || this.getHunger() < 20)) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            --itemstack.field_77994_a;
                        }
                        this.func_70691_i(itemfood2.func_150905_g(itemstack));
                        this.addFood(5);
                        if (itemstack.field_77994_a <= 0) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                        }
                        return true;
                    }
                } else if (itemstack.func_77973_b() instanceof ItemCurePotion && this.isOwner((EntityLivingBase)player)) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.createWolf(this);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        --itemstack.field_77994_a;
                    }
                    if (itemstack.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                    this.field_70170_p.func_72900_e((Entity)this);
                    return true;
                }
            } else if (!player.func_70093_af()) {
                player.openGui((Object)Werewolf.instance, 2, player.field_70170_p, this.func_145782_y(), 0, 0);
                return true;
            }
        } else if (itemstack != null && itemstack.func_77973_b() instanceof ItemFood && WerewolfPlayer.get((EntityPlayer)player).howlAttention && WerewolfPlayer.get(player).getTransformed() && (itemfood = (ItemFood)itemstack.func_77973_b()).func_77845_h()) {
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            if (itemstack.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.setTamed(true);
                this.func_70624_b(null);
                this.setOwnerId(player.func_110124_au().toString());
                HowlingWorldData.forWorld(this.field_70170_p).addMember(player);
                this.setPlayerWolfID(WerewolfPlayer.get(player).getWolfID());
                this.setPackID(WerewolfPlayer.get(player).getPackID());
                this.playTameEffect(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    public void createWolf(EntityTameWere wolf) {
        EntityWolf entitywolf = new EntityWolf(this.field_70170_p);
        String s = this.func_152113_b();
        if (s != null && s.trim().length() > 0) {
            entitywolf.func_152115_b(s);
            entitywolf.func_70903_f(true);
        }
        entitywolf.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
        this.field_70170_p.func_72838_d((Entity)entitywolf);
    }

    protected String func_70639_aQ() {
        if (this.isAngry()) {
            return "mob.wolf.growl";
        }
        Random rnd = new Random();
        if (rnd.nextInt(8) == 0) {
            return "howlingmoon:howl";
        }
        return null;
    }

    @Override
    protected String func_70621_aR() {
        return "mob.wolf.hurt";
    }

    @Override
    protected String func_70673_aS() {
        return "mob.wolf.death";
    }
}

