/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.entities;

import com.raz.howlingmoon.HowlingWorldData;
import com.raz.howlingmoon.Werewolf;
import com.raz.howlingmoon.WerewolfPlayer;
import com.raz.howlingmoon.entities.EntityAlphaWolf;
import com.raz.howlingmoon.entities.EntityWere;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityTameWere
extends EntityWere
implements IEntityOwnable {
    private int tickTimer = 0;

    public EntityTameWere(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)"");
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.func_152113_b() == null) {
            tagCompound.func_74778_a("OwnerUUID", "");
        } else {
            tagCompound.func_74778_a("OwnerUUID", this.func_152113_b());
        }
        tagCompound.func_74757_a("Sitting", this.isSitting());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        String s = "";
        if (tagCompund.func_150297_b("OwnerUUID", 8)) {
            s = tagCompund.func_74779_i("OwnerUUID");
        } else {
            String s1 = tagCompund.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_152719_a((String)s1);
        }
        if (s.length() > 0) {
            this.setOwnerId(s);
            this.setTamed(true);
            if (tagCompund.func_74764_b("aiswim") && this.getOwnerEntity() != null) {
                this.field_70180_af.func_75692_b(18, (Object)WerewolfPlayer.get((EntityPlayer)this.getOwnerEntity()).getWolfID());
            }
        }
        this.setSitting(tagCompund.func_74767_n("Sitting"));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() == null && this.isAngry()) {
                this.setAngry(false);
            } else if (this.func_70638_az() instanceof EntityTameWere && this.getPackID() == ((EntityTameWere)this.func_70638_az()).getPackID()) {
                this.func_70624_b(null);
                this.setAngry(false);
            }
            if (this.isTamed()) {
                ++this.tickTimer;
                if (this.tickTimer % 100 == 0) {
                    if (this.getOwnerEntity() instanceof EntityPlayer) {
                        if (!WerewolfPlayer.get((EntityPlayer)this.getOwnerEntity()).getWerewolf() || WerewolfPlayer.get((EntityPlayer)this.getOwnerEntity()).getTierInt() + 3 < this.getSavageryLevel() && !this.isSubmissve()) {
                            this.setTamed(false);
                            HowlingWorldData.forWorld(this.field_70170_p).removeMember(this.getPlayerWolfID());
                        } else if (WerewolfPlayer.get((EntityPlayer)this.getOwnerEntity()).getPackID() != this.getPackID()) {
                            this.setPackID(WerewolfPlayer.get((EntityPlayer)this.getOwnerEntity()).getPackID());
                        }
                    }
                    if (this.func_70638_az() instanceof EntityPlayer && this.getPackID() == WerewolfPlayer.get((EntityPlayer)this.func_70638_az()).getPackID()) {
                        this.func_70624_b(null);
                        this.setAngry(false);
                    }
                }
                if (this.tickTimer > 2400) {
                    this.tickTimer = this.getHunger() - 1;
                    if (this.tickTimer < 0) {
                        this.tickTimer = 0;
                    }
                    this.field_70180_af.func_75692_b(27, (Object)this.tickTimer);
                    this.tickTimer = 0;
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.isTamed() && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    protected String func_145776_H() {
        return "game.hostile.swim";
    }

    protected String func_145777_O() {
        return "game.hostile.swim.splash";
    }

    protected String func_70621_aR() {
        return "mob.wolf.hurt";
    }

    protected String func_70673_aS() {
        return "mob.wolf.death";
    }

    protected String func_146067_o(int damageValue) {
        return damageValue > 4 ? "game.hostile.hurt.fall.big" : "game.hostile.hurt.fall.small";
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f - this.field_70170_p.func_175724_o(pos);
    }

    protected boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        return i <= this.field_70146_Z.nextInt(8);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevel() && super.func_70601_bi();
    }

    protected void playTameEffect(boolean p_70908_1_) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        if (!p_70908_1_) {
            enumparticletypes = EnumParticleTypes.SMOKE_NORMAL;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 7) {
            this.playTameEffect(true);
        } else if (id == 6) {
            this.playTameEffect(false);
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean isAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public void setAngry(boolean angry) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        if (angry) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    public boolean isTamed() {
        return (this.field_70180_af.func_75683_a(16) & 4) != 0;
    }

    public void setTamed(boolean tamed) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        if (tamed) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 | 4)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 & 0xFFFFFFFB)));
            this.setPlayerWolfID(0);
            this.setPackID(0);
        }
    }

    protected void setupTamedAI() {
    }

    public boolean isSitting() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setSitting(boolean p_70904_1_) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        if (p_70904_1_) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public String getSittingName() {
        if (this.isSitting()) {
            return StatCollector.func_74838_a((String)"werewolf.tame.wander");
        }
        return StatCollector.func_74838_a((String)"werewolf.tame.follow");
    }

    public String func_152113_b() {
        return this.field_70180_af.func_75681_e(17);
    }

    public void setOwnerId(String ownerUuid) {
        this.field_70180_af.func_75692_b(17, (Object)ownerUuid);
    }

    public EntityLivingBase getOwnerEntity() {
        try {
            UUID uuid = UUID.fromString(this.func_152113_b());
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        return entityIn == this.getOwnerEntity();
    }

    public boolean func_142018_a(EntityLivingBase p_142018_1_, EntityLivingBase p_142018_2_) {
        return true;
    }

    public Team func_96124_cp() {
        EntityLivingBase entitylivingbase;
        if (this.isTamed() && (entitylivingbase = this.getOwnerEntity()) != null) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_142014_c(EntityLivingBase otherEntity) {
        if (this.isTamed()) {
            EntityLivingBase entitylivingbase1 = this.getOwnerEntity();
            if (otherEntity == entitylivingbase1) {
                return true;
            }
            if (otherEntity instanceof EntityTameWere && ((EntityTameWere)otherEntity).getPackID() == this.getPackID()) {
                return true;
            }
            if (otherEntity instanceof EntityPlayer && WerewolfPlayer.get((EntityPlayer)otherEntity).getPackID() == this.getPackID()) {
                return true;
            }
            if (entitylivingbase1 != null) {
                return entitylivingbase1.func_142014_c(otherEntity);
            }
        }
        return super.func_142014_c(otherEntity);
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            HowlingWorldData.forWorld(this.field_70170_p).removeMember(this.getPlayerWolfID());
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && this.func_145818_k_() && this.getOwnerEntity() instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.getOwnerEntity()).func_145747_a(this.func_110142_aN().func_151521_b());
        }
        super.func_70645_a(cause);
    }

    public Entity func_70902_q() {
        return this.getOwnerEntity();
    }

    public boolean isDire() {
        return this instanceof EntityAlphaWolf;
    }

    protected Item func_146068_u() {
        return Werewolf.wolfFangs;
    }
}

