/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.handler;

import com.raz.howlingmoon.Werewolf;
import com.raz.howlingmoon.WerewolfPlayer;
import com.raz.howlingmoon.client.EntityParticleFXInfrared;
import com.raz.howlingmoon.client.EntityParticleFXScent;
import com.raz.howlingmoon.client.EntityRenderBeast;
import com.raz.howlingmoon.client.ItemRendererWerewolf;
import com.raz.howlingmoon.client.RenderBeastPlayer;
import com.raz.howlingmoon.client.RenderDireWolf;
import com.raz.howlingmoon.client.RenderWerewolfPlayer;
import com.raz.howlingmoon.handler.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

public class WerewolfClientEventHandler {
    private Render renderCustomModel;
    private static final ResourceLocation guiBar = new ResourceLocation("howlingmoon:textures/gui/bars.png");
    private Minecraft mc = Minecraft.func_71410_x();
    public final ItemRendererWerewolf itemRendererWerewolf = new ItemRendererWerewolf(this.mc);
    private int curModel = 0;
    private EntityRenderer rendererBeast;
    private EntityRenderer rendererDire;
    private EntityRenderer prevRenderer;
    private float ySize = -1.0f;
    private float eyeHeight;
    private boolean createdRender = false;

    public WerewolfClientEventHandler() {
        this.renderCustomModel = new RenderWerewolfPlayer(Minecraft.func_71410_x().func_175598_ae());
    }

    @SubscribeEvent
    public void onRenderPlayerPre(RenderPlayerEvent.Pre pre) {
        if (!ConfigHandler.disableRender) {
            EntityPlayer player = pre.entityPlayer;
            WerewolfPlayer props = WerewolfPlayer.get(player);
            if (props.getTransformed()) {
                pre.setCanceled(true);
                if (!this.createdRender || this.curModel != props.getModel()) {
                    this.curModel = props.getModel();
                    if (this.curModel < 2) {
                        this.renderCustomModel = new RenderWerewolfPlayer(Minecraft.func_71410_x().func_175598_ae());
                    } else if (this.curModel == 2) {
                        this.renderCustomModel = new RenderBeastPlayer(Minecraft.func_71410_x().func_175598_ae());
                    } else if (this.curModel == 3) {
                        this.renderCustomModel = new RenderDireWolf(Minecraft.func_71410_x().func_175598_ae());
                    }
                    this.createdRender = true;
                }
                this.renderCustomModel.func_76986_a(pre.entity, pre.x, pre.y, pre.z, 0.0f, pre.partialRenderTick);
            } else if (this.createdRender) {
                this.createdRender = false;
            }
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (this.mc.field_71441_e != null) {
            EntityPlayerSP player = this.mc.field_71439_g;
            WerewolfPlayer props = WerewolfPlayer.get((EntityPlayer)player);
            if (props.getModel() == 2 && props.getTransformed()) {
                if (this.rendererBeast == null) {
                    this.rendererBeast = new EntityRenderBeast(this.mc);
                }
                if (this.mc.field_71460_t != this.rendererBeast) {
                    if (this.prevRenderer == null) {
                        this.prevRenderer = this.mc.field_71460_t;
                    }
                    this.mc.field_71460_t = this.rendererBeast;
                }
            } else if (props.getModel() == 3 && props.getTransformed()) {
                if (this.rendererDire == null) {
                    this.rendererDire = new EntityRenderBeast(this.mc, 0.8f);
                }
                if (this.mc.field_71460_t != this.rendererDire) {
                    if (this.prevRenderer == null) {
                        this.prevRenderer = this.mc.field_71460_t;
                    }
                    this.mc.field_71460_t = this.rendererDire;
                }
            } else if (this.prevRenderer != null && this.mc.field_71460_t != this.prevRenderer) {
                this.mc.field_71460_t = this.prevRenderer;
            }
        }
    }

    @SubscribeEvent
    public void onRenderWerewolfPaw(RenderHandEvent event) {
        if (WerewolfPlayer.get((EntityPlayer)this.mc.field_71439_g).getTransformed() && !ConfigHandler.disableRender) {
            boolean flag;
            event.setCanceled(true);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            EntityRenderer playerRender = Minecraft.func_71410_x().field_71460_t;
            GlStateManager.func_179086_m((int)256);
            float partialTicks = event.partialTicks;
            int xOffset = event.renderPass;
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            float f = 0.07f;
            if (this.mc.field_71474_y.field_74337_g) {
                GlStateManager.func_179109_b((float)((float)(-(xOffset * 2 - 1)) * f), (float)0.0f, (float)0.0f);
            }
            float farPlaneDistance = this.mc.field_71474_y.field_151451_c * 16;
            Project.gluPerspective((float)this.getFOVModifier(partialTicks, false), (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)(farPlaneDistance * 2.0f));
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            if (this.mc.field_71474_y.field_74337_g) {
                GlStateManager.func_179109_b((float)((float)(xOffset * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179094_E();
            if (this.mc.field_71474_y.field_74336_f) {
                this.setupViewBobbing(partialTicks);
            }
            boolean bl = flag = this.mc.func_175606_aa() instanceof EntityLivingBase && ((EntityLivingBase)this.mc.func_175606_aa()).func_70608_bn();
            if (!(this.mc.field_71474_y.field_74320_O != 0 || flag || this.mc.field_71474_y.field_74319_N || this.mc.field_71442_b.func_78747_a())) {
                playerRender.func_180436_i();
                this.itemRendererWerewolf.updateEquippedItem();
                this.itemRendererWerewolf.renderItemInFirstPerson(partialTicks);
                playerRender.func_175072_h();
            }
            GlStateManager.func_179121_F();
            if (this.mc.field_71474_y.field_74320_O == 0 && !flag) {
                playerRender.field_78516_c.func_78447_b(partialTicks);
            }
            if (this.mc.field_71474_y.field_74336_f) {
                this.setupViewBobbing(partialTicks);
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingFinished(RenderLivingEvent.Post e) {
        WerewolfPlayer props = WerewolfPlayer.get((EntityPlayer)this.mc.field_71439_g);
        if (props.getTransformed() && props.getTierAbility() > 2 && props.getVisionState() == 2 && e.entity.field_70173_aa % 5 == 0) {
            if (e.entity instanceof EntityAnimal) {
                Werewolf.proxy.generateInfraredParticles((Entity)e.entity, 1.0f, 0.5f, 0.0f);
            } else if (e.entity instanceof EntityCreeper) {
                Werewolf.proxy.generateInfraredParticles((Entity)e.entity, 0.0f, 1.0f, 0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE || this.mc.field_71439_g.func_70055_a(Material.field_151586_h) || !ConfigHandler.secondaryHunger || this.mc.field_71439_g.field_71075_bZ.field_75098_d) {
            return;
        }
        WerewolfPlayer props = WerewolfPlayer.get((EntityPlayer)this.mc.field_71439_g);
        if (props.getWerewolf() && props.getHungerState() != 0 && props.getTierInt() > 0 && (props.getTransformed() || props.getHungerState() == 2)) {
            ScaledResolution scaledresolution = new ScaledResolution(this.mc);
            int k = scaledresolution.func_78326_a();
            int l = scaledresolution.func_78328_b();
            this.mc.func_110434_K().func_110577_a(guiBar);
            int rallyColor = 0;
            if (props.rally > 300) {
                rallyColor = 164;
            } else if (props.rally > 0) {
                rallyColor = 82;
            }
            if (props.isFat()) {
                this.mc.field_71456_v.func_73729_b(k / 2 + 10, l - 53, rallyColor, 65, 81, 14);
                int widthP = (int)((float)props.transformedHunger / (float)props.getMaxHunger() * 79.0f);
                widthP = widthP < 0 ? 0 : widthP;
                this.mc.field_71456_v.func_73729_b(k / 2 + 11, l - 53, 1, 80, widthP, 14);
            } else {
                this.mc.field_71456_v.func_73729_b(k / 2 + 10, l - 49, rallyColor, 20, 81, 9);
                int widthP = (int)((float)props.transformedHunger / (float)props.getMaxHunger() * 79.0f);
                widthP = widthP < 0 ? 0 : widthP;
                this.mc.field_71456_v.func_73729_b(k / 2 + 11, l - 48, 1, 31, widthP, 7);
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Tessellator tess = Tessellator.func_178181_a();
        boolean isLightingEnabled = GL11.glGetBoolean((int)2896);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        if (isLightingEnabled) {
            GlStateManager.func_179140_f();
        }
        EntityParticleFXScent.dispatchQueuedRenders(tess);
        EntityParticleFXInfrared.dispatchQueuedRenders(tess);
        if (isLightingEnabled) {
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }

    private void setupViewBobbing(float p_78475_1_) {
        if (this.mc.func_175606_aa() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this.mc.func_175606_aa();
            float f1 = entityplayer.field_70140_Q - entityplayer.field_70141_P;
            float f2 = -(entityplayer.field_70140_Q + f1 * p_78475_1_);
            float f3 = entityplayer.field_71107_bF + (entityplayer.field_71109_bG - entityplayer.field_71107_bF) * p_78475_1_;
            float f4 = entityplayer.field_70727_aS + (entityplayer.field_70726_aT - entityplayer.field_70727_aS) * p_78475_1_;
            GlStateManager.func_179109_b((float)(MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 0.5f), (float)(-Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI)) * f3)), (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI - 0.2f)) * f3) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)f4, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private float getFOVModifier(float p_78481_1_, boolean p_78481_2_) {
        Block block;
        EntityLivingBase entityplayer = (EntityLivingBase)this.mc.func_175606_aa();
        float f1 = 70.0f;
        if (entityplayer.func_110143_aJ() <= 0.0f) {
            float f2 = (float)entityplayer.field_70725_aQ + p_78481_1_;
            f1 /= (1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f;
        }
        if ((block = ActiveRenderInfo.func_180786_a((World)this.mc.field_71441_e, (Entity)entityplayer, (float)p_78481_1_)).func_149688_o() == Material.field_151586_h) {
            f1 = f1 * 60.0f / 70.0f;
        }
        return f1;
    }
}

