/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon;

import com.raz.howlingmoon.IWerewolfCapability;
import com.raz.howlingmoon.WereAbilityList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;

public class WereAbility {
    public final int displayColumn;
    public final int displayRow;
    public final List<WereAbility> parentAbilities;
    private final String abilityName;
    private final String abilityDescription;
    private final String key;
    private final int cap;
    private final boolean requireCap;
    private final int type;
    private final int skillPoint;
    private final int xTexture;
    private final int yTexture;

    public WereAbility(String key, String unlocalizedName, int cap, int column, int row, int type, int skillPoint, List<WereAbility> parents, int xTexture, int yTexture) {
        this(key, unlocalizedName, cap, column, row, type, skillPoint, false, parents, xTexture, yTexture);
    }

    public WereAbility(String key, String unlocalizedName, int cap, int column, int row, int type, int skillPoint, WereAbility parent, int xTexture, int yTexture) {
        this(key, unlocalizedName, cap, column, row, type, skillPoint, false, Arrays.asList(parent), xTexture, yTexture);
    }

    public WereAbility(String key, String unlocalizedName, int cap, int column, int row, int type, int skillPoint, boolean required, List<WereAbility> parents, int xTexture, int yTexture) {
        this.abilityName = unlocalizedName;
        this.abilityDescription = unlocalizedName + ".desc";
        this.xTexture = xTexture;
        this.yTexture = yTexture;
        this.displayColumn = column;
        this.displayRow = row;
        this.key = key;
        this.type = type;
        this.skillPoint = skillPoint;
        this.cap = cap;
        this.requireCap = required;
        this.parentAbilities = parents;
        if (column < WereAbilityList.minDisplayColumn) {
            WereAbilityList.minDisplayColumn = column;
        }
        if (row < WereAbilityList.minDisplayRow) {
            WereAbilityList.minDisplayRow = row;
        }
        if (column > WereAbilityList.maxDisplayColumn) {
            WereAbilityList.maxDisplayColumn = column;
        }
        if (row > WereAbilityList.maxDisplayRow) {
            WereAbilityList.maxDisplayRow = row;
        }
    }

    public WereAbility registerStat() {
        WereAbilityList.ABILITIES.add(this);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public int getCap() {
        return this.cap;
    }

    public boolean requireCap() {
        return this.requireCap;
    }

    public boolean canUnlock(IWerewolfCapability wolf) {
        if (this.parentAbilities == null) {
            return true;
        }
        for (int i = 0; i < this.parentAbilities.size(); ++i) {
            if (this.parentAbilities.get(i) == null) continue;
            if (wolf.getSkillTreeAbility(this.parentAbilities.get(i).getKey()) == 0) {
                return false;
            }
            if (!this.requireCap() || wolf.getSkillTreeAbility(this.parentAbilities.get(i).getKey()) == this.parentAbilities.get(i).getCap()) continue;
            return false;
        }
        return true;
    }

    public boolean havePointsFor(IWerewolfCapability wolf) {
        if (this.skillPoint == 0) {
            return false;
        }
        return this.skillPoint == 1 ? wolf.getUsuableSkillPoints() > 0 : (this.skillPoint == 2 ? wolf.getUsuableCalmPoints() > 0 : this.skillPoint == 3 && wolf.getUsuableSavagePoints() > 0);
    }

    public String getName() {
        return I18n.func_135052_a((String)this.abilityName, (Object[])new Object[0]);
    }

    public String getDescription() {
        return I18n.func_135052_a((String)this.abilityDescription, (Object[])new Object[0]);
    }

    public int getXTexture() {
        return this.xTexture;
    }

    public int getYTexture() {
        return this.yTexture;
    }

    public int getType() {
        return this.type;
    }

    public int getSkillPoint() {
        return this.skillPoint;
    }

    public String printPoints(IWerewolfCapability wolf) {
        return wolf.getSkillTreeAbility(this.getKey()) + "/" + this.getCap();
    }
}

