/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon;

import com.raz.howlingmoon.HMPotions;
import com.raz.howlingmoon.IWerewolfCapability;
import com.raz.howlingmoon.WereAbilityList;
import com.raz.howlingmoon.packets.PacketDispatcher;
import com.raz.howlingmoon.packets.SyncExpLevelClient;
import com.raz.howlingmoon.packets.SyncWereCapsMessage;
import com.raz.howlingmoon.packets.TrackingMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WereEventHandler {
    public static List<String> transformedPlayers = new ArrayList<String>();
    @CapabilityInject(value=IWerewolfCapability.class)
    public static final Capability<IWerewolfCapability> WERE_CAP = null;

    @SubscribeEvent
    public void onEntityConstruct(AttachCapabilitiesEvent.Entity evt) {
        if (evt.getEntity() instanceof EntityPlayer) {
            evt.addCapability(new ResourceLocation("howlingmoon", "IWerewolfCapability"), (ICapabilityProvider)new ICapabilitySerializable<NBTBase>(){
                IWerewolfCapability inst = (IWerewolfCapability)WERE_CAP.getDefaultInstance();

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == WERE_CAP;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == WERE_CAP ? WERE_CAP.cast((Object)this.inst) : null);
                }

                public NBTBase serializeNBT() {
                    return WERE_CAP.getStorage().writeNBT(WERE_CAP, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTBase nbt) {
                    WERE_CAP.getStorage().readNBT(WERE_CAP, (Object)this.inst, null, nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().field_70170_p.field_72995_K) {
            PacketDispatcher.sendTo(new SyncWereCapsMessage((EntityPlayer)event.getEntity()), (EntityPlayerMP)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        ((IWerewolfCapability)event.getEntityPlayer().getCapability(WERE_CAP, null)).copy((IWerewolfCapability)event.getOriginal().getCapability(WERE_CAP, null));
    }

    @SubscribeEvent
    public void TrackHandler(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayer && !event.getEntityPlayer().field_70170_p.field_72995_K && ((IWerewolfCapability)((EntityPlayer)event.getEntityLiving()).getCapability(WERE_CAP, null)).isWerewolf()) {
            PacketDispatcher.sendTo(new TrackingMessage((EntityPlayer)event.getTarget()), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void jumpHeight(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IWerewolfCapability wolf = (IWerewolfCapability)player.getCapability(WERE_CAP, null);
            if (wolf.isTransformed()) {
                double i = (double)wolf.getSTreeAbilityTotal(WereAbilityList.JUMPHEIGHT.getKey()) / 10.0;
                i += 0.2;
                if (this.wearingArmor(player)) {
                    int reduce = wolf.getSTreeAbilityTotal(WereAbilityList.ARMORP.getKey());
                    i *= 0.25 * (double)reduce;
                }
                event.getEntityLiving().field_70181_x += i;
            }
            if (player.field_70170_p.field_72995_K) {
                if (this.canLeap(player)) {
                    float speed = 1.5f + 0.5f * (float)wolf.getSTreeAbilityTotal(WereAbilityList.LEAPP.getKey());
                    if (!player.field_70122_E) {
                        speed -= 0.3f;
                    }
                    if (wolf.getLeapState() == 0) {
                        player.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * speed;
                        player.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * speed;
                    } else {
                        if (player.field_70127_C < 0.0f) {
                            player.field_70181_x += (double)(-MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * speed / 5.0f);
                        }
                        player.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * speed;
                        player.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * speed;
                    }
                }
                wolf.setLeap(false);
            }
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        EntityPlayer player;
        IWerewolfCapability wolf;
        if (event.getEntityLiving() instanceof EntityPlayer && (wolf = (IWerewolfCapability)(player = (EntityPlayer)event.getEntityLiving()).getCapability(WERE_CAP, null)).isTransformed()) {
            float reduceby = (float)wolf.getSTreeAbilityTotal(WereAbilityList.JUMPHEIGHT.getKey()) * 2.0f;
            event.setDistance(event.getDistance() - (reduceby += 2.0f));
        }
    }

    @SubscribeEvent
    public void updateStep(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().func_70644_a((Potion)HMPotions.BLEEDING) && event.getEntityLiving().func_70660_b((Potion)HMPotions.BLEEDING).func_76459_b() % 40 == 0) {
            event.getEntityLiving().func_70097_a(DamageSource.field_76376_m.func_151518_m(), 1.0f);
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            String s = player.func_146103_bH().getName() + ":" + player.field_70170_p.field_72995_K;
            IWerewolfCapability wolf = (IWerewolfCapability)((EntityPlayer)event.getEntityLiving()).getCapability(WERE_CAP, null);
            if (transformedPlayers.contains(s)) {
                if (wolf.isTransformed()) {
                    if ((player.field_70122_E || player.field_71075_bZ.field_75100_b) && player.field_70701_bs > 0.0f && !player.func_70055_a(Material.field_151586_h)) {
                        float additional = 0.025f;
                        additional += 0.025f * (float)wolf.getSTreeAbilityTotal(WereAbilityList.MOVESPEED.getKey());
                        if (player.func_70051_ag() && wolf.getSTreeAbilityTotal(WereAbilityList.DASH.getKey()) > 0) {
                            additional *= 2.5f;
                        }
                        if (this.wearingArmor(player)) {
                            int reduce = wolf.getSTreeAbilityTotal(WereAbilityList.ARMORP.getKey());
                            additional *= 0.25f * (float)reduce;
                        }
                        player.func_70060_a(0.0f, 1.0f, additional);
                    }
                    if (wolf.getSTreeAbilityTotal(WereAbilityList.QUICKSTEP.getKey()) > 0) {
                        player.field_70138_W = player.func_70093_af() ? 0.60001f : 1.1f;
                    }
                    if (wolf.getSTreeAbilityTotal(WereAbilityList.TENACITY.getKey()) == 0) {
                        if (wolf.getT2Knockback()) {
                            player.func_110140_aT().func_111148_a(wolf.getAttributeMod());
                            wolf.setT2Knockback(false);
                        }
                    } else if (!wolf.getT2Knockback()) {
                        player.func_110140_aT().func_111147_b(wolf.getAttributeMod());
                        wolf.setT2Knockback(true);
                    }
                    if (wolf.getSTreeAbilityTotal(WereAbilityList.NIGHTVISION.getKey()) > 0 && wolf.getNightVision()) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 310, 0, false, false));
                    }
                } else {
                    player.field_70138_W = 0.6f;
                    transformedPlayers.remove(s);
                    player.func_110140_aT().func_111148_a(wolf.getAttributeMod());
                    wolf.setT2Knockback(false);
                }
            } else if (wolf.isTransformed()) {
                transformedPlayers.add(s);
                if (wolf.getSTreeAbilityTotal(WereAbilityList.QUICKSTEP.getKey()) > 0) {
                    player.field_70138_W = 1.1f;
                }
                if (wolf.getSTreeAbilityTotal(WereAbilityList.TENACITY.getKey()) > 0) {
                    player.func_110140_aT().func_111147_b(wolf.getAttributeMod());
                    wolf.setT2Knockback(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void clawAttack(LivingHurtEvent event) {
        if (event.getEntityLiving() != null) {
            float damage;
            EntityPlayer player;
            IWerewolfCapability wolf;
            if (event.getSource().func_76346_g() instanceof EntityPlayer && (wolf = (IWerewolfCapability)(player = (EntityPlayer)event.getSource().func_76346_g()).getCapability(WERE_CAP, null)).isTransformed()) {
                if (player.func_184614_ca() == null) {
                    if (wolf.getSTreeAbilityTotal(WereAbilityList.SHRED.getKey()) > 0) {
                        event.getEntityLiving().func_70690_d(new PotionEffect((Potion)HMPotions.BLEEDING, 300, 0, false, true));
                    }
                    damage = (float)wolf.getSTreeAbilityTotal(WereAbilityList.STRENGTH.getKey()) * 4.0f;
                    damage += 4.0f;
                    if (wolf.getSTreeAbilityTotal(WereAbilityList.SHARPNESS.getKey()) > 0) {
                        int sharpness = event.getEntityLiving().func_70658_aO() / 4;
                        damage += (float)sharpness;
                    }
                    event.setAmount(event.getAmount() + damage);
                    if (wolf.getSTreeAbilityTotal(WereAbilityList.KNOCKBACK.getKey()) > 0) {
                        event.getEntityLiving().func_70653_a((Entity)event.getEntityLiving(), 2.0f, event.getSource().func_76364_f().field_70165_t - event.getEntityLiving().field_70165_t, event.getSource().func_76364_f().field_70161_v - event.getEntityLiving().field_70161_v);
                    }
                } else if (wolf.getSTreeAbilityTotal(WereAbilityList.PAWP.getKey()) < 4) {
                    damage = 0.6f + (float)wolf.getSTreeAbilityTotal(WereAbilityList.PAWP.getKey()) * 0.1f;
                    event.setAmount(event.getAmount() * damage);
                }
            }
            if (event.getEntity() instanceof EntityPlayer && (wolf = (IWerewolfCapability)(player = (EntityPlayer)event.getEntity()).getCapability(WERE_CAP, null)).isTransformed()) {
                int reduce;
                if (!event.getSource().func_76347_k() && !event.getSource().func_151517_h()) {
                    damage = 1.0f - (float)wolf.getSTreeAbilityTotal(WereAbilityList.PROTECTION.getKey()) * 0.2f;
                    if (damage > 0.9f || this.wearingArmor(player)) {
                        damage = 0.9f;
                    }
                    event.setAmount(event.getAmount() * damage);
                }
                if (this.wearingArmor(player) && (reduce = wolf.getSTreeAbilityTotal(WereAbilityList.ARMORP.getKey())) < 4) {
                    reduce = 4 - reduce;
                    Iterator armor = player.func_184193_aE().iterator();
                    int slot = 0;
                    while (armor.hasNext()) {
                        ItemStack piece = (ItemStack)armor.next();
                        if (piece != null) {
                            if (piece.func_77973_b() instanceof ISpecialArmor) {
                                ((ISpecialArmor)piece.func_77973_b()).damageArmor((EntityLivingBase)player, piece, event.getSource(), reduce, slot);
                            } else {
                                piece.func_77972_a(reduce, (EntityLivingBase)player);
                            }
                        }
                        ++slot;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onWerewolfKill(LivingDeathEvent event) {
        EntityPlayer player;
        IWerewolfCapability wolf;
        if (event.getSource().func_76364_f() instanceof EntityPlayer && (wolf = (IWerewolfCapability)(player = (EntityPlayer)event.getSource().func_76364_f()).getCapability(WERE_CAP, null)).isWerewolf() && wolf.isTransformed()) {
            if (wolf.getSTreeAbilityTotal(WereAbilityList.FEAST.getKey()) > 0) {
                player.func_71024_bL().func_75122_a(3, 4.0f);
                int feast = wolf.getSTreeAbilityTotal(WereAbilityList.FEASTP.getKey());
                if (feast > 0) {
                    player.func_70691_i(2.0f);
                    if (feast > 1) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 300, 1, false, false));
                    }
                }
            } else {
                player.func_71024_bL().func_75122_a(1, 1.0f);
            }
            wolf.addExp((int)event.getEntityLiving().func_110138_aP());
            PacketDispatcher.sendTo(new SyncExpLevelClient(player), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onWerewolfStartEat(LivingEntityUseItemEvent.Start event) {
        IWerewolfCapability wolf;
        if (event.getEntityLiving() instanceof EntityPlayer && event.getItem().func_77973_b() instanceof ItemFood && (wolf = (IWerewolfCapability)((EntityPlayer)event.getEntityLiving()).getCapability(WERE_CAP, null)).getSTreeAbilityTotal(WereAbilityList.HUNGER.getKey()) < 3) {
            ItemFood itemfood = (ItemFood)event.getItem().func_77973_b();
            if (wolf.isWerewolf() && wolf.isTransformed() && !itemfood.func_77845_h()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void werewolfBreakBlock(PlayerEvent.BreakSpeed event) {
        IWerewolfCapability wolf = (IWerewolfCapability)event.getEntityPlayer().getCapability(WERE_CAP, null);
        if (wolf.isTransformed() && event.getEntityPlayer().func_184614_ca() != null) {
            event.setNewSpeed(event.getNewSpeed() * (0.2f + 0.2f * (float)wolf.getSTreeAbilityTotal(WereAbilityList.PAWP.getKey())));
            if (wolf.getSTreeAbilityTotal(WereAbilityList.DEXTEROUS.getKey()) > 0) {
                event.setNewSpeed(event.getNewSpeed() * 1.2f);
            }
        }
    }

    @SubscribeEvent
    public void onWereXPPickup(PlayerPickupXpEvent event) {
        IWerewolfCapability wolf = (IWerewolfCapability)event.getEntityPlayer().getCapability(WERE_CAP, null);
        if (wolf.isWerewolf() && wolf.getSTreeAbilityTotal(WereAbilityList.GIFTED.getKey()) > 0) {
            event.getEntityPlayer().func_71023_q(event.getOrb().func_70526_d() / 3);
        }
    }

    @SubscribeEvent
    public void werewolfSleepEvent(PlayerSleepInBedEvent event) {
        IWerewolfCapability wolf;
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && (wolf = (IWerewolfCapability)event.getEntityPlayer().getCapability(WERE_CAP, null)).isTransformed()) {
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("werewolf.message.sleep", new Object[0]));
        }
    }

    private boolean canLeap(EntityPlayer player) {
        IWerewolfCapability wolf = (IWerewolfCapability)player.getCapability(WERE_CAP, null);
        if (wolf.getSTreeAbilityTotal(WereAbilityList.LEAP.getKey()) > 0) {
            if (Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d() && wolf.getSprintJump() > 1) {
                return true;
            }
            if (player.func_70093_af() && wolf.getSneakJump() > 1) {
                return true;
            }
            return wolf.getLeap();
        }
        return false;
    }

    private boolean wearingArmor(EntityPlayer player) {
        Iterator armor = player.func_184193_aE().iterator();
        while (armor.hasNext()) {
            if (armor.next() == null) continue;
            return true;
        }
        return false;
    }
}

