/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.raz.howlingmoon.IWerewolfCapability;
import com.raz.howlingmoon.WereAbility;
import com.raz.howlingmoon.WereAbilityList;
import com.raz.howlingmoon.handler.ConfigHandler;
import com.raz.howlingmoon.packets.PacketDispatcher;
import com.raz.howlingmoon.packets.SetPlayerHitBox;
import com.raz.howlingmoon.packets.SyncTransformMessage;
import com.raz.howlingmoon.packets.SyncWereCapsMessage;
import com.raz.howlingmoon.packets.TrackingMessage;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;

public class WerewolfCapability
implements IWerewolfCapability {
    private boolean isWerewolf = false;
    private boolean isTransformed = false;
    private boolean isSprintKey = false;
    private int infected = 0;
    private boolean displayRage = false;
    private int tick = 0;
    private int cdExhil = 150;
    private int level = 0;
    private int exp = 0;
    private int questsDone = 0;
    private int usedSkillPoints = 0;
    private int calmPoints = 0;
    private int usedCalmPoints = 0;
    private int savagePoints = 0;
    private int usedSavagePoints = 0;
    private HashMap<String, Integer> skillTree = new HashMap<String, Integer>(){
        {
            for (WereAbility ability : WereAbilityList.ABILITIES) {
                this.put(ability.getKey(), 0);
            }
        }
    };
    private HashMap<String, Integer> skillTreeLunacy = new HashMap<String, Integer>(){
        {
            for (WereAbility ability : WereAbilityList.ABILITIES) {
                this.put(ability.getKey(), 0);
            }
        }
    };
    private final HashMap<String, Integer> skillTreeCap = new HashMap<String, Integer>(){
        {
            for (WereAbility ability : WereAbilityList.ABILITIES) {
                this.put(ability.getKey(), ability.getCap());
            }
        }
    };
    private AttributeModifier t2Modifier = new AttributeModifier(UUID.fromString("fc1af77f-2c52-4ba6-b722-7d3097162cf9"), "Tenacity", 1.0, 0);
    private Multimap<String, AttributeModifier> attributes = HashMultimap.create();
    private boolean t2Knockback;
    private boolean climb;
    private boolean nightVision;
    private boolean leap;
    private int sprintClimb;
    private int sneakJump;
    private int sprintJump;
    private int leapState;
    private int pawSlot;
    private WereAbility abilitySlot1;
    private WereAbility abilitySlot2;
    private int texture;
    private int model;

    public WerewolfCapability() {
        this.attributes.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)this.t2Modifier);
        this.sprintClimb = 0;
        this.sneakJump = 2;
        this.sprintJump = 2;
        this.leapState = 0;
        this.pawSlot = -1;
        this.texture = 0;
        this.model = 0;
    }

    @Override
    public void copy(IWerewolfCapability cap) {
        this.isWerewolf = cap.isWerewolf();
        this.isTransformed = false;
        this.infected = cap.getInfected();
        this.level = cap.getLevel();
        this.exp = cap.getExp();
        this.questsDone = cap.getQuestsDone();
        this.usedSkillPoints = cap.getUsedSkillPoints();
        this.calmPoints = cap.getCalmPoints();
        this.usedCalmPoints = cap.getUsedCalmPoints();
        this.savagePoints = cap.getSavagePoints();
        this.usedSavagePoints = cap.getUsedSavagePoints();
        this.skillTree = cap.getSkillTree();
        this.skillTreeLunacy = cap.getSkillTreeLunacy();
        this.pawSlot = cap.getPawSlot();
        this.nightVision = cap.getNightVision();
        this.leapState = cap.getLeapState();
        this.sprintClimb = cap.getSprintClimb();
        this.sneakJump = cap.getSneakJump();
        this.sprintJump = cap.getSprintJump();
    }

    @Override
    public boolean isWerewolf() {
        return this.isWerewolf;
    }

    @Override
    public boolean isTransformed() {
        return this.isTransformed;
    }

    @Override
    public boolean isSprintKey() {
        return this.isSprintKey;
    }

    @Override
    public void setSprintKey(boolean isSprintKey) {
        this.isSprintKey = isSprintKey;
    }

    @Override
    public void setTransformed(boolean isTransformed) {
        this.isTransformed = isTransformed;
    }

    @Override
    public void setWerewolf(boolean state) {
        this.isWerewolf = state;
        this.skillTree.put("WEREWOLF", state ? 1 : 0);
    }

    @Override
    public void setWerewolf(boolean state, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && this.isWerewolf != state) {
            this.isWerewolf = state;
            this.skillTree.put("WEREWOLF", state ? 1 : 0);
            if (state) {
                if (this.level < 1) {
                    this.setLevel(1);
                }
                this.infected = 2;
            } else {
                this.resetSkillPoints();
                this.setTransformedServer(false, player);
                this.infected = 0;
                this.exp = this.level % 2 == 1 && this.level > 1 ? this.level / 2 * 100 : 0;
                this.level /= 2;
            }
            PacketDispatcher.sendTo(new SyncWereCapsMessage(player), (EntityPlayerMP)player);
        }
    }

    @Override
    public void tryTransform(EntityPlayer player) {
        if (player.field_70170_p.func_130001_d() != 1.0f || player.field_70170_p.func_72935_r()) {
            int duration;
            if (this.isTransformed) {
                duration = 1200;
                if ((duration -= this.getSTreeAbilityTotal(WereAbilityList.CLARITY.getKey()) * 400) > 0) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, duration, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, duration, 0, false, false));
                }
                this.isTransformed = false;
                PacketDispatcher.sendTo(new SyncTransformMessage(player), (EntityPlayerMP)player);
            } else {
                duration = 0;
                if ((duration += this.getSTreeAbilityTotal(WereAbilityList.EXHILARATING.getKey())) > 0 && this.getCDExhil() < 1) {
                    player.func_71024_bL().func_75122_a(0, (float)(duration * 3));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, duration * 400, duration - 1, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, duration * 400, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, duration * 400, 0, false, false));
                    this.resetCDExhil();
                }
                this.isTransformed = true;
                PacketDispatcher.sendTo(new SyncTransformMessage(player), (EntityPlayerMP)player);
            }
            PacketDispatcher.sendTo(new SetPlayerHitBox(player, this.getModelHeight()), (EntityPlayerMP)player);
            Set players = ((WorldServer)player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)player);
            PacketDispatcher.sendToPlayers(new TrackingMessage(player), players);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("werewolf.message.exitmoon", new Object[0]));
        }
    }

    @Override
    public void setTransformed(boolean state, Side side, EntityPlayer player) {
        boolean temp = this.isTransformed;
        this.isTransformed = state;
        if (side.isServer()) {
            int duration;
            PacketDispatcher.sendTo(new SyncTransformMessage(player), (EntityPlayerMP)player);
            PacketDispatcher.sendTo(new SetPlayerHitBox(player, this.getModelHeight()), (EntityPlayerMP)player);
            if (!state && temp) {
                duration = 1200;
                if ((duration -= this.getSTreeAbilityTotal(WereAbilityList.CLARITY.getKey()) * 400) > 0) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, duration, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, duration, 0, false, false));
                }
            } else if (state && !temp) {
                duration = 0;
                if ((duration += this.getSTreeAbilityTotal(WereAbilityList.EXHILARATING.getKey())) > 0 && this.getCDExhil() < 1) {
                    player.func_71024_bL().func_75122_a(0, (float)duration);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, duration * 400, duration - 1, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, duration * 400, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, duration * 400, 0, false, false));
                    this.resetCDExhil();
                }
            }
            Set players = ((WorldServer)player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)player);
            PacketDispatcher.sendToPlayers(new TrackingMessage(player), players);
        }
    }

    @Override
    public void setTransformedServer(boolean state, EntityPlayer player) {
        int duration;
        boolean temp = this.isTransformed;
        this.isTransformed = state;
        PacketDispatcher.sendTo(new SyncTransformMessage(player), (EntityPlayerMP)player);
        PacketDispatcher.sendTo(new SetPlayerHitBox(player, this.getModelHeight()), (EntityPlayerMP)player);
        if (!state && temp) {
            duration = 1200;
            if ((duration -= this.getSTreeAbilityTotal(WereAbilityList.CLARITY.getKey()) * 400) > 0) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, duration, 0, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration, 0, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, duration, 0, false, false));
            }
        } else if (state && !temp) {
            duration = 0;
            if ((duration += this.getSTreeAbilityTotal(WereAbilityList.EXHILARATING.getKey())) > 0 && this.getCDExhil() < 1) {
                player.func_71024_bL().func_75122_a(0, (float)duration);
                player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, duration * 400, duration - 1, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, duration * 400, 0, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, duration * 400, 0, false, false));
                this.resetCDExhil();
            }
        }
        Set players = ((WorldServer)player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)player);
        PacketDispatcher.sendToPlayers(new TrackingMessage(player), players);
    }

    @Override
    public HashMap<String, Integer> getSkillTree() {
        return this.skillTree;
    }

    @Override
    public void setSkillTree(HashMap array) {
        this.skillTree = array;
    }

    @Override
    public HashMap<String, Integer> getSkillTreeLunacy() {
        return this.skillTreeLunacy;
    }

    @Override
    public void setSkillTreeLunacy(HashMap array) {
        this.skillTreeLunacy = array;
    }

    @Override
    public int getSkillTreeAbility(String key) {
        if (this.skillTree.get(key) != null) {
            return this.skillTree.get(key);
        }
        return 0;
    }

    @Override
    public void setSkillTreeAbility(String key, int value) {
        if (value < 0) {
            value = 0;
        }
        this.skillTree.put(key, value);
        if (this.skillTree.get(key) > this.skillTreeCap.get(key)) {
            this.skillTree.put(key, this.skillTreeCap.get(key));
        }
    }

    @Override
    public void addSkillTreeAbility(String key, boolean value) {
        if (value) {
            if (!this.isSkillCapped(key)) {
                this.skillTree.put(key, this.skillTree.get(key) + 1);
                this.setUsedSkillPoints(this.getUsedSkillPoints() + 1);
            }
        } else if (this.skillTree.get(key) > 0) {
            this.skillTree.put(key, this.skillTree.get(key) - 1);
            this.setUsedSkillPoints(this.getUsedSkillPoints() - 1);
        }
    }

    @Override
    public void addSkillTreeAbility(WereAbility ability) {
        String key = ability.getKey();
        if (!this.isSkillCapped(key)) {
            int point = ability.getSkillPoint();
            if (point == 1) {
                if (this.getUsuableSkillPoints() > 0) {
                    this.skillTree.put(key, this.skillTree.get(key) + 1);
                    this.setUsedSkillPoints(this.getUsedSkillPoints() + 1);
                }
            } else if (point == 2) {
                if (this.getUsuableCalmPoints() > 0) {
                    this.skillTree.put(key, this.skillTree.get(key) + 1);
                    this.setUsedCalmPoints(this.getUsedCalmPoints() + 1);
                }
            } else if (point == 3 && this.getUsuableSavagePoints() > 0) {
                this.skillTree.put(key, this.skillTree.get(key) + 1);
                this.setUsedSavagePoints(this.getUsedSavagePoints() + 1);
            }
        }
    }

    @Override
    public boolean isSkillCapped(String key) {
        return this.skillTree.get(key) >= this.skillTreeCap.get(key);
    }

    @Override
    public boolean isLunacySkillCapped(String key) {
        return this.skillTree.get(key) + this.skillTreeLunacy.get(key) >= this.skillTreeCap.get(key);
    }

    @Override
    public void resetSkillTree() {
        for (String key : this.skillTree.keySet()) {
            if (key == "WEREWOLF") continue;
            this.skillTree.put(key, 0);
        }
        for (String key : this.skillTreeLunacy.keySet()) {
            this.skillTreeLunacy.put(key, 0);
        }
    }

    @Override
    public void resetLunacyTree() {
        for (String key : this.skillTreeLunacy.keySet()) {
            this.skillTreeLunacy.put(key, 0);
        }
    }

    @Override
    public int getSTreeAbilityTotal(String key) {
        if (this.skillTree.get(key) != null) {
            return this.skillTree.get(key) + this.skillTreeLunacy.get(key);
        }
        return 0;
    }

    @Override
    public void setSTLunacyAbility(String key, int value) {
        if (value < 0) {
            value = 0;
        }
        this.skillTreeLunacy.put(key, value);
        if (this.skillTree.get(key) + this.skillTreeLunacy.get(key) > this.skillTreeCap.get(key)) {
            int temp = this.skillTreeCap.get(key) - this.skillTree.get(key);
            if (temp > 0) {
                this.skillTreeLunacy.put(key, temp);
            } else {
                this.skillTreeLunacy.put(key, 0);
            }
        }
    }

    @Override
    public void addSTLunacyAbility(String key, boolean value) {
        if (value) {
            if (!this.isLunacySkillCapped(key)) {
                this.skillTreeLunacy.put(key, this.skillTreeLunacy.get(key) + 1);
            }
        } else if (this.skillTreeLunacy.get(key) > 0) {
            this.skillTreeLunacy.put(key, this.skillTreeLunacy.get(key) - 1);
        }
    }

    @Override
    public int getLevelCap() {
        return 10 + this.questsDone * 10;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
        if (!ConfigHandler.removeLevelCap && this.level > this.getLevelCap()) {
            this.level = this.getLevelCap();
        }
    }

    @Override
    public int getExp() {
        return this.exp;
    }

    @Override
    public void setExp(int exp) {
        this.exp = exp;
        this.expLevel();
    }

    @Override
    public void addExp(int amount) {
        this.exp += amount;
        this.expLevel();
    }

    private void expLevel() {
        if (!this.levelCapped()) {
            if (this.exp > this.expNeededLevel()) {
                this.setExp(this.exp - this.expNeededLevel());
                this.setLevel(this.getLevel() + 1);
            }
        } else if (this.exp > 0) {
            this.exp = 0;
        }
    }

    @Override
    public int expNeededLevel() {
        if (this.getLevel() < 50) {
            return this.getLevel() * (125 - this.getLevel());
        }
        return 3750;
    }

    private boolean levelCapped() {
        return this.level >= 10 + this.questsDone * 10;
    }

    @Override
    public int getQuestsDone() {
        return this.questsDone;
    }

    @Override
    public void setQuestsDone(int questsDone) {
        this.questsDone = questsDone > 4 ? 4 : questsDone;
    }

    @Override
    public int getUsedSkillPoints() {
        return this.usedSkillPoints;
    }

    @Override
    public void setUsedSkillPoints(int usedSkillPoints) {
        this.usedSkillPoints = usedSkillPoints;
    }

    @Override
    public int getUsuableSkillPoints() {
        return this.level - this.usedSkillPoints;
    }

    @Override
    public void resetSkillPoints() {
        this.setUsedSkillPoints(0);
        this.setUsedCalmPoints(0);
        this.setUsedSavagePoints(0);
        this.resetSkillTree();
    }

    @Override
    public void resetCalmSavagePoints() {
        this.resetLunacyTree();
        this.setUsedCalmPoints(0);
        this.setUsedSavagePoints(0);
        int tempPoints = 0;
        this.skillTree.put(WereAbilityList.ANGELFALL.getKey(), 0);
        this.skillTree.put(WereAbilityList.ARMOR.getKey(), 0);
        tempPoints = this.skillTree.get(WereAbilityList.ARMORP.getKey());
        if (tempPoints > 0) {
            this.skillTree.put(WereAbilityList.ARMORP.getKey(), 0);
            this.usedSkillPoints -= tempPoints;
            tempPoints = 0;
        }
        this.skillTree.put(WereAbilityList.WOLFSBANEW.getKey(), 0);
        this.skillTree.put(WereAbilityList.TRANQUILITY.getKey(), 0);
        this.skillTree.put(WereAbilityList.SHRED.getKey(), 0);
        this.skillTree.put(WereAbilityList.BEAST.getKey(), 0);
        this.skillTree.put(WereAbilityList.FEASTP.getKey(), 0);
        this.skillTree.put(WereAbilityList.FEAR.getKey(), 0);
        tempPoints = this.skillTree.get(WereAbilityList.FEARP.getKey());
        if (tempPoints > 0) {
            this.skillTree.put(WereAbilityList.FEARP.getKey(), 0);
            this.usedSkillPoints -= tempPoints;
        }
    }

    @Override
    public int getCalmPoints() {
        return this.calmPoints;
    }

    @Override
    public void setCalmPoints(int calmPoints) {
        this.calmPoints = calmPoints;
    }

    @Override
    public int getUsedCalmPoints() {
        return this.usedCalmPoints;
    }

    @Override
    public void setUsedCalmPoints(int usedCalmPoints) {
        this.usedCalmPoints = usedCalmPoints;
    }

    @Override
    public int getUsuableCalmPoints() {
        return this.calmPoints - this.usedCalmPoints;
    }

    @Override
    public int getSavagePoints() {
        return this.savagePoints;
    }

    @Override
    public void setSavagePoints(int savagePoints) {
        this.savagePoints = savagePoints;
    }

    @Override
    public int getUsedSavagePoints() {
        return this.usedSavagePoints;
    }

    @Override
    public void setUsedSavagePoints(int usedSavagePoints) {
        this.usedSavagePoints = usedSavagePoints;
    }

    @Override
    public int getUsuableSavagePoints() {
        return this.savagePoints - this.usedSavagePoints;
    }

    @Override
    public int getTexture() {
        return this.texture;
    }

    @Override
    public String getTextureName() {
        switch (this.texture) {
            case 0: {
                return I18n.func_135052_a((String)"werewolf.menu.texture.white", (Object[])new Object[0]);
            }
            case 1: {
                return I18n.func_135052_a((String)"werewolf.menu.texture.black", (Object[])new Object[0]);
            }
            case 2: {
                return I18n.func_135052_a((String)"werewolf.menu.texture.timber", (Object[])new Object[0]);
            }
            case 3: {
                return "Killerwolf";
            }
        }
        return I18n.func_135052_a((String)"werewolf.menu.texture.custom", (Object[])new Object[0]) + (this.texture - 3);
    }

    @Override
    public void setTexture(int i) {
        this.texture = i;
    }

    @Override
    public void setTexture(int i, Side side, EntityPlayer player) {
        this.texture = i;
        if (side.isServer() && this.isTransformed) {
            Set players = ((WorldServer)player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)player);
            PacketDispatcher.sendToPlayers(new TrackingMessage(player), players);
        }
    }

    @Override
    public int getModel() {
        return this.model;
    }

    @Override
    public String getModelName() {
        if (this.model == 0) {
            return I18n.func_135052_a((String)"werewolf.menu.werewolf", (Object[])new Object[0]);
        }
        if (this.model == 1) {
            return I18n.func_135052_a((String)"werewolf.menu.werewolf", (Object[])new Object[0]);
        }
        if (this.model == 2) {
            return I18n.func_135052_a((String)"werewolf.menu.model.wolf", (Object[])new Object[0]);
        }
        if (this.model == 3) {
            return I18n.func_135052_a((String)"werewolf.menu.model.beast", (Object[])new Object[0]);
        }
        return "Error";
    }

    @Override
    public void setModel(int i) {
        this.model = i;
    }

    @Override
    public void setModel(int i, Side side, EntityPlayer player) {
        this.model = i;
        if (side.isServer() && this.isTransformed) {
            Set players = ((WorldServer)player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)player);
            PacketDispatcher.sendToPlayers(new TrackingMessage(player), players);
        }
    }

    @Override
    public int getInfected() {
        return this.infected;
    }

    @Override
    public void setInfected(int i) {
        this.infected = i;
    }

    @Override
    public int getTick() {
        return this.tick;
    }

    @Override
    public void incTick() {
        ++this.tick;
    }

    @Override
    public void resetTick() {
        this.tick = 0;
    }

    @Override
    public int getCDExhil() {
        return this.cdExhil;
    }

    @Override
    public void deincCDExhil() {
        if (this.cdExhil > 0) {
            --this.cdExhil;
        }
    }

    @Override
    public void resetCDExhil() {
        this.cdExhil = 300;
    }

    @Override
    public boolean getDisplayRage() {
        return this.displayRage;
    }

    @Override
    public void setDisplayRage(boolean state) {
        this.displayRage = state;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeMod() {
        return this.attributes;
    }

    @Override
    public boolean getT2Knockback() {
        return this.t2Knockback;
    }

    @Override
    public void setT2Knockback(boolean state) {
        this.t2Knockback = state;
    }

    @Override
    public boolean getClimb() {
        return this.climb;
    }

    @Override
    public void setClimb(boolean set) {
        this.climb = set;
    }

    @Override
    public boolean getLeap() {
        return this.leap;
    }

    @Override
    public void setLeap(boolean set) {
        this.leap = set;
    }

    @Override
    public boolean getNightVision() {
        return this.nightVision;
    }

    @Override
    public void setNightVision(boolean set) {
        this.nightVision = set;
    }

    @Override
    public int getSprintClimb() {
        return this.sprintClimb;
    }

    @Override
    public void setSprintClimb(int state) {
        this.sprintClimb = state;
    }

    @Override
    public int getLeapState() {
        return this.leapState;
    }

    @Override
    public void setLeapState(int state) {
        this.leapState = state;
    }

    @Override
    public int getSneakJump() {
        return this.sneakJump;
    }

    @Override
    public void setSneakJump(int state) {
        this.sneakJump = state;
    }

    @Override
    public int getSprintJump() {
        return this.sprintJump;
    }

    @Override
    public void setSprintJump(int state) {
        this.sprintJump = state;
    }

    @Override
    public WereAbility getAbilitySlot1() {
        return this.abilitySlot1;
    }

    @Override
    public WereAbility getAbilitySlot2() {
        return this.abilitySlot2;
    }

    @Override
    public void setAbilitySlot1(WereAbility ability) {
        this.abilitySlot1 = ability;
    }

    @Override
    public void setAbilitySlot2(WereAbility ability) {
        this.abilitySlot2 = ability;
    }

    @Override
    public int getPawSlot() {
        return this.pawSlot;
    }

    @Override
    public void setPawSlot(int slot) {
        this.pawSlot = slot;
    }

    @Override
    public float getModelHeight() {
        if (this.isTransformed) {
            switch (this.model) {
                case 0: {
                    return 1.8f;
                }
                case 1: {
                    return 1.8f;
                }
                case 2: {
                    return 0.9f;
                }
                case 3: {
                    return 2.8f;
                }
            }
            return 1.8f;
        }
        return 1.8f;
    }
}

