/*
 * Decompiled with CFR 0.152.
 */
package com.raz.howlingmoon.packets;

import com.raz.howlingmoon.packets.AbstractMessage;
import com.raz.howlingmoon.packets.BiteEntity;
import com.raz.howlingmoon.packets.ClientClimbMessage;
import com.raz.howlingmoon.packets.DismountEntity;
import com.raz.howlingmoon.packets.ForceMovement;
import com.raz.howlingmoon.packets.LaunchEntity;
import com.raz.howlingmoon.packets.LiftEntity;
import com.raz.howlingmoon.packets.LiftEntity2;
import com.raz.howlingmoon.packets.MaimEntity;
import com.raz.howlingmoon.packets.PawSlot;
import com.raz.howlingmoon.packets.PlaySoundPacket;
import com.raz.howlingmoon.packets.ResetFallMessage;
import com.raz.howlingmoon.packets.SetEquippedAbilities;
import com.raz.howlingmoon.packets.SetPlayerHitBox;
import com.raz.howlingmoon.packets.SneakJumpToggle;
import com.raz.howlingmoon.packets.SprintClimbToggle;
import com.raz.howlingmoon.packets.SprintJumpToggle;
import com.raz.howlingmoon.packets.SyncExpLevelClient;
import com.raz.howlingmoon.packets.SyncInfectedMessage;
import com.raz.howlingmoon.packets.SyncIsWerewolfMessage;
import com.raz.howlingmoon.packets.SyncLeapMessage;
import com.raz.howlingmoon.packets.SyncNightVisionMessage;
import com.raz.howlingmoon.packets.SyncQuestsDoneClient;
import com.raz.howlingmoon.packets.SyncSprintKeyMessage;
import com.raz.howlingmoon.packets.SyncTransformMessage;
import com.raz.howlingmoon.packets.SyncWereCapsMessage;
import com.raz.howlingmoon.packets.SyncWerewolfModelMessage;
import com.raz.howlingmoon.packets.SyncWerewolfTextureMessage;
import com.raz.howlingmoon.packets.TrackingMessage;
import com.raz.howlingmoon.packets.TryTransformServerMessage;
import com.raz.howlingmoon.packets.UpdateExpServer;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDispatcher {
    private static byte packetId = 0;
    private static final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("howlingmoon");

    public static final void registerPackets() {
        PacketDispatcher.registerMessage(SyncWereCapsMessage.class);
        PacketDispatcher.registerMessage(TrackingMessage.class);
        PacketDispatcher.registerMessage(SyncExpLevelClient.class);
        PacketDispatcher.registerMessage(SyncQuestsDoneClient.class);
        PacketDispatcher.registerMessage(ClientClimbMessage.class);
        PacketDispatcher.registerMessage(ForceMovement.class);
        PacketDispatcher.registerMessage(LiftEntity2.class);
        PacketDispatcher.registerMessage(UpdateExpServer.class);
        PacketDispatcher.registerMessage(TryTransformServerMessage.class);
        PacketDispatcher.registerMessage(PlaySoundPacket.class);
        PacketDispatcher.registerMessage(SyncLeapMessage.class);
        PacketDispatcher.registerMessage(ResetFallMessage.class);
        PacketDispatcher.registerMessage(LaunchEntity.class);
        PacketDispatcher.registerMessage(SetEquippedAbilities.class);
        PacketDispatcher.registerMessage(LiftEntity.class);
        PacketDispatcher.registerMessage(SneakJumpToggle.class);
        PacketDispatcher.registerMessage(SprintJumpToggle.class);
        PacketDispatcher.registerMessage(SprintClimbToggle.class);
        PacketDispatcher.registerMessage(BiteEntity.class);
        PacketDispatcher.registerMessage(MaimEntity.class);
        PacketDispatcher.registerMessage(PawSlot.class);
        PacketDispatcher.registerMessage(SyncIsWerewolfMessage.class);
        PacketDispatcher.registerMessage(SyncTransformMessage.class);
        PacketDispatcher.registerMessage(SyncNightVisionMessage.class);
        PacketDispatcher.registerMessage(SyncWerewolfTextureMessage.class);
        PacketDispatcher.registerMessage(SyncWerewolfModelMessage.class);
        PacketDispatcher.registerMessage(SyncInfectedMessage.class);
        PacketDispatcher.registerMessage(SyncSprintKeyMessage.class);
        PacketDispatcher.registerMessage(DismountEntity.class);
        PacketDispatcher.registerMessage(SetPlayerHitBox.class);
    }

    private static final <T extends AbstractMessage<T>> void registerMessage(Class<T> clazz) {
        if (AbstractMessage.AbstractClientMessage.class.isAssignableFrom(clazz)) {
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.CLIENT);
        } else if (AbstractMessage.AbstractServerMessage.class.isAssignableFrom(clazz)) {
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.SERVER);
        } else {
            dispatcher.registerMessage(clazz, clazz, (int)packetId, Side.CLIENT);
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.SERVER);
        }
    }

    public static final void sendTo(IMessage message, EntityPlayerMP player) {
        dispatcher.sendTo(message, player);
    }

    public static void sendToAll(IMessage message) {
        dispatcher.sendToAll(message);
    }

    public static final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        dispatcher.sendToAllAround(message, point);
    }

    public static final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketDispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        PacketDispatcher.sendToAllAround(message, player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static final void sendToDimension(IMessage message, int dimensionId) {
        dispatcher.sendToDimension(message, dimensionId);
    }

    public static final void sendToServer(IMessage message) {
        dispatcher.sendToServer(message);
    }

    public static final void sendToPlayers(IMessage message, Set<? extends EntityPlayer> players) {
        for (EntityPlayer entityPlayer : players) {
            dispatcher.sendTo(message, (EntityPlayerMP)entityPlayer);
        }
    }
}

