/*
 * Decompiled with CFR 0.152.
 */
package mobarmormod.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;

public class UpdateChecker {
    public static boolean isUpdateAvailable() throws IOException, MalformedURLException {
        return !UpdateChecker.getCurrentVersion().contains("1.5.0 Beta");
    }

    public static boolean isOnline() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface interf = interfaces.nextElement();
            if (!interf.isUp() || interf.isLoopback()) continue;
            List<InterfaceAddress> adrs = interf.getInterfaceAddresses();
            for (InterfaceAddress adr : adrs) {
                InetAddress inadr = adr.getAddress();
                if (!(inadr instanceof Inet4Address)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getCurrentVersion() throws MalformedURLException, IOException {
        BufferedReader versionFile = new BufferedReader(new InputStreamReader(new URL("http://rolikdevelopment.com/mobarmormodupdate.txt").openStream()));
        String curVersion = versionFile.readLine();
        versionFile.close();
        return curVersion;
    }
}

