/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="aether_legacy")
@Config.LangKey(value="aether_legacy.config.title")
public class AetherConfig {
    public static final Dimension dimension = new Dimension();
    public static final WorldGenOptions world_gen = new WorldGenOptions();
    public static final VisualOptions visual_options = new VisualOptions();
    public static final GameplayChanges gameplay_changes = new GameplayChanges();

    @Mod.EventBusSubscriber(modid="aether_legacy")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("aether_legacy")) {
                ConfigManager.sync((String)"aether_legacy", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class GameplayChanges {
        @Config.Comment(value={"Determines if the player will get an Aether Portal Frame item when first joining the world."})
        public boolean aether_start = false;
        @Config.Comment(value={"The max amount of life shards that can be used per player"})
        public int max_life_shards = 10;
        @Config.Comment(value={"If enabled, Aether Portals can only be lit by Skyroot Buckets"})
        public boolean skyroot_bucket_only = false;
        @Config.Comment(value={"Makes it so you have to eat Ambrosium, instead of just right clicking to heal"})
        public boolean ambro_is_edible = false;
        @Config.Comment(value={"Swaps the Golden Feather with the Valkyrie Cape in dungeon loot"})
        public boolean valkyrie_cape = false;
        @Config.Comment(value={"Disables spawn of the Aether portal for use with portal being provided by another mod."})
        public boolean disable_portal = false;
        @Config.Comment(value={"Disables startup loot when entering the Aether"})
        public boolean disable_startup_loot = false;
        @Config.Comment(value={"Removes the requirement for a player to be an operator to use the Sun Altar in multiplayer."})
        public boolean sun_altar_multiplayer = false;
        @Config.Comment(value={"If disabed, the Sun Spirit's dialog will only show once per world."})
        public boolean repeat_sun_spirit_dialog = true;
    }

    public static class VisualOptions {
        @Config.Comment(value={"Changes Aether mobs to use their old models, if applicable"})
        public boolean legacy_models = false;
        @Config.Comment(value={"Aerclouds will use their more saturated colors from later updates"})
        public boolean updated_aercloud_colors = false;
        @Config.Comment(value={"Disables the random trivia/tips you see during loading screens"})
        @Config.RequiresMcRestart
        public boolean trivia_disabled = false;
        @Config.Comment(value={"Enables the Aether Menu"})
        public boolean menu_enabled = false;
        @Config.Comment(value={"Enables the Aether Menu toggle button"})
        public boolean menu_button = true;
        @Config.Comment(value={"Determines whether the Aether b1.7.3 resource pack should be generated."})
        public boolean install_resourcepack = true;
        @Config.Comment(value={"Changes whether the Altar should be named Enchanter or not."})
        public boolean legacy_altar_name = false;
    }

    public static class WorldGenOptions {
        @Config.Comment(value={"Enables natural christmas decor"})
        public boolean christmas_time = false;
        @Config.Comment(value={"Enables naturally generating tallgrass"})
        public boolean tallgrass_enabled = false;
        @Config.Comment(value={"Enables natural Pink Aercloud generation"})
        public boolean pink_aerclouds = false;
    }

    public static class Dimension {
        @Config.RangeInt(min=2, max=256)
        @Config.RequiresMcRestart
        @Config.Comment(value={"Set the Dimension ID for the Aether."})
        public int aether_dimension_id = 4;
    }
}

