/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.blocks.natural;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.blocks.util.EnumCloudType;
import com.gildedgames.the_aether.blocks.util.IAetherMeta;
import com.gildedgames.the_aether.registry.creative_tabs.AetherCreativeTabs;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAercloud
extends Block
implements IAetherMeta {
    public static final PropertyEnum<EnumCloudType> cloud_type = PropertyEnum.func_177709_a((String)"aether_aercloud", EnumCloudType.class);

    public BlockAercloud() {
        super(Material.field_151588_w);
        this.func_149711_c(0.2f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149647_a(AetherCreativeTabs.blocks);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(cloud_type, (Comparable)((Object)EnumCloudType.Cold)));
    }

    public static int getHexColor(ItemStack stack) {
        if (stack.func_77960_j() == 1) {
            if (AetherConfig.visual_options.updated_aercloud_colors) {
                return 7459583;
            }
            return 0xCCFFFF;
        }
        if (stack.func_77960_j() == 2) {
            if (AetherConfig.visual_options.updated_aercloud_colors) {
                return 16769154;
            }
            return 0xFFFF80;
        }
        return 0xFFFFFF;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        entity.field_70143_R = 0.0f;
        if (((EnumCloudType)((Object)state.func_177229_b(cloud_type))).equals((Object)EnumCloudType.Blue)) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (player.func_70093_af()) {
                    if (entity.field_70181_x < 0.0) {
                        entity.field_70181_x *= 0.005;
                    }
                    return;
                }
                entity.field_70181_x = 2.0;
            } else {
                entity.field_70181_x = 2.0;
            }
            if (world.field_72995_K) {
                for (int count = 0; count < 50; ++count) {
                    double xOffset = (double)pos.func_177958_n() + world.field_73012_v.nextDouble();
                    double yOffset = (double)pos.func_177956_o() + world.field_73012_v.nextDouble();
                    double zOffset = (double)pos.func_177952_p() + world.field_73012_v.nextDouble();
                    world.func_175688_a(EnumParticleTypes.WATER_SPLASH, xOffset, yOffset, zOffset, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        } else {
            if (((EnumCloudType)((Object)state.func_177229_b(cloud_type))).equals((Object)EnumCloudType.Pink) && entity.field_70173_aa % 20 == 0 && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70691_i(1.0f);
            }
            if (entity.field_70181_x < 0.0) {
                entity.field_70181_x *= 0.005;
            }
        }
    }

    @Override
    public String getMetaName(ItemStack stack) {
        return ((EnumCloudType)((Object)this.func_176203_a(stack.func_77952_i()).func_177229_b(cloud_type))).func_176610_l();
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumCloudType)((Object)state.func_177229_b(cloud_type))).getMeta();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int j = 0; j < EnumCloudType.values().length; ++j) {
            EnumCloudType cloud_type = EnumCloudType.values()[j];
            if (AetherConfig.world_gen.pink_aerclouds) {
                list.add((Object)new ItemStack((Block)this, 1, cloud_type.getMeta()));
                continue;
            }
            if (cloud_type == EnumCloudType.Pink) continue;
            list.add((Object)new ItemStack((Block)this, 1, cloud_type.getMeta()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(cloud_type, (Comparable)((Object)EnumCloudType.getType(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumCloudType)((Object)state.func_177229_b(cloud_type))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{cloud_type});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (worldIn.func_180495_p(pos.func_177972_a(side)) != iblockstate) {
            return true;
        }
        if (block == this) {
            return false;
        }
        return !worldIn.func_180495_p(pos.func_177972_a(side)).doesSideBlockRendering(worldIn, pos.func_177972_a(side), side.func_176734_d());
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return ((EnumCloudType)((Object)blockState.func_177229_b(cloud_type))).getMeta() != 1 ? new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.01, 1.0) : new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }
}

