/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.client.renders.entities;

import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.player.IPlayerAether;
import com.gildedgames.the_aether.client.models.entities.MoaModel;
import com.gildedgames.the_aether.client.renders.entities.layer.LayerMoaSaddle;
import com.gildedgames.the_aether.client.renders.entities.layer.MoaDonatorLayer;
import com.gildedgames.the_aether.entities.passive.mountable.EntityMoa;
import com.gildedgames.the_aether.entities.util.AetherMoaTypes;
import com.gildedgames.the_aether.player.PlayerAether;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class MoaRenderer
extends RenderLiving<EntityMoa> {
    private static final ResourceLocation MOS = new ResourceLocation("aether_legacy", "textures/entities/moa/mos.png");
    private static final ResourceLocation RAPTOR = new ResourceLocation("aether_legacy", "textures/entities/moa/raptor.png");

    public MoaRenderer(RenderManager renderManager) {
        super(renderManager, (ModelBase)new MoaModel(0.0f), 0.7f);
        this.func_177094_a(new MoaDonatorLayer(renderManager, (MoaModel)this.func_177087_b()));
        this.func_177094_a(new LayerMoaSaddle(this));
    }

    protected float getWingRotation(EntityMoa moa, float f) {
        float f1 = moa.prevWingRotation + (moa.wingRotation - moa.prevWingRotation) * f;
        float f2 = moa.prevDestPos + (moa.destPos - moa.prevDestPos) * f;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected float handleRotationFloat(EntityMoa entityliving, float f) {
        return this.getWingRotation(entityliving, f);
    }

    protected void scaleMoa(EntityMoa entityMoa) {
        float moaScale = entityMoa.func_70631_g_() ? 1.0f : 1.8f;
        GL11.glScalef((float)moaScale, (float)moaScale, (float)moaScale);
    }

    protected void preRenderCallback(EntityMoa entityliving, float f) {
        this.scaleMoa(entityliving);
    }

    protected ResourceLocation getEntityTexture(EntityMoa entity) {
        IPlayerAether player;
        EntityMoa moa = entity;
        if (moa.func_184207_aI() && moa.func_184188_bt().get(0) instanceof EntityPlayer && (player = AetherAPI.getInstance().get((EntityPlayer)moa.func_184188_bt().get(0))) != null && !((PlayerAether)player).donatorMoaSkin.shouldUseDefualt()) {
            return null;
        }
        if (entity.func_145818_k_() && "Mos".equals(entity.func_95999_t()) && entity.getMoaType() == AetherMoaTypes.orange) {
            return MOS;
        }
        if (entity.func_145818_k_() && "Raptor__".equals(entity.func_95999_t()) && entity.getMoaType() == AetherMoaTypes.blue) {
            return RAPTOR;
        }
        return moa.getMoaType().getTexture(moa.func_184207_aI());
    }
}

