/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.block;

import com.gildedgames.the_aether.blocks.util.BlockFloating;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFloatingBlock
extends Entity {
    private static final DataParameter<Integer> BLOCK_NAME = new DataParameter(20, DataSerializers.field_187192_b);
    private static final DataParameter<Byte> BLOCK_METADATA = new DataParameter(21, DataSerializers.field_187191_a);
    private boolean hasActivated = false;

    public EntityFloatingBlock(World world) {
        super(world);
        this.func_70105_a(0.98f, 0.98f);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public EntityFloatingBlock(World world, double x, double y, double z, IBlockState state) {
        this(world);
        this.setBlockState(state);
        this.func_70107_b(x, y, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BLOCK_NAME, (Object)2);
        this.field_70180_af.func_187214_a(BLOCK_METADATA, (Object)4);
    }

    public void func_70071_h_() {
        BlockPos pos;
        if (!this.field_70170_p.field_72995_K && !this.hasActivated) {
            pos = new BlockPos((Entity)this);
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() == this.getBlockState().func_177230_c()) {
                this.field_70170_p.func_175698_g(pos);
            } else {
                this.func_70106_y();
            }
            this.hasActivated = true;
        }
        if (this.field_70173_aa > 200) {
            this.func_70106_y();
        } else {
            int count;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70181_x += 0.04;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
            pos = new BlockPos((Entity)this);
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(0.0, 1.0, 0.0));
            for (int stack = 0; stack < list.size(); ++stack) {
                Entity entity = (Entity)list.get(stack);
                if (entity instanceof EntityFallingBlock) continue;
                entity.func_70091_d(MoverType.PLAYER, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                entity.func_70107_b(entity.field_70165_t, this.field_70163_u + 1.0, entity.field_70161_v);
                entity.field_70181_x = 0.0;
                entity.field_70122_E = true;
                entity.field_70143_R = 0.0f;
            }
            if (!BlockFloating.canFallInto(this.field_70170_p, pos.func_177984_a())) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_175656_a(pos, this.getBlockState());
                    this.func_70106_y();
                }
                this.field_70165_t = (double)pos.func_177958_n() + 0.5;
                this.field_70163_u = pos.func_177956_o();
                this.field_70161_v = (double)pos.func_177952_p() + 0.5;
            }
            if (this.field_70170_p.func_175623_d(pos.func_177977_b()) && this.field_70170_p.field_72995_K && (count = MathHelper.func_76128_c((double)(this.field_70181_x / 0.15))) > 5) {
                int n = 5;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        Block block = Block.func_149684_b((String)compound.func_74779_i("Block"));
        this.setBlockState(block.func_176203_a((int)compound.func_74771_c("BlockState")));
        this.field_70173_aa = compound.func_74762_e("TicksExisted");
        this.hasActivated = this.field_70173_aa > 1;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        IBlockState state = this.getBlockState();
        Block block = state.func_177230_c();
        compound.func_74778_a("Block", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
        compound.func_74774_a("BlockState", (byte)block.func_176201_c(state));
        compound.func_74768_a("TicksExisted", this.field_70173_aa);
    }

    public IBlockState getBlockState() {
        Block block = Block.func_149729_e((int)((Integer)this.field_70180_af.func_187225_a(BLOCK_NAME)));
        byte meta = (Byte)this.field_70180_af.func_187225_a(BLOCK_METADATA);
        return block.func_176203_a((int)meta);
    }

    public void setBlockState(IBlockState state) {
        Block block = state.func_177230_c();
        this.field_70180_af.func_187227_b(BLOCK_NAME, (Object)Block.field_149771_c.func_148757_b((Object)block));
        this.field_70180_af.func_187227_b(BLOCK_METADATA, (Object)((byte)block.func_176201_c(state)));
    }
}

