/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.client;

import com.legacy.aether.AetherConfig;
import com.legacy.aether.client.AetherMovementInput;
import com.legacy.aether.client.gui.AetherLoadingScreen;
import com.legacy.aether.client.gui.button.GuiAccessoryButton;
import com.legacy.aether.client.renders.entity.PlayerAetherRenderer;
import com.legacy.aether.entities.EntitiesAether;
import com.legacy.aether.items.ItemAetherSpawnEgg;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.items.armor.ItemAetherArmor;
import com.legacy.aether.network.AetherNetwork;
import com.legacy.aether.network.packets.PacketOpenContainer;
import com.legacy.aether.player.PlayerAether;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;

public class AetherClientEvents {
    private static final GuiAccessoryButton ACCESSORY_BUTTON = new GuiAccessoryButton(0, 0);
    private static int previousSelectedTabIndex = -1;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) throws Exception {
        Minecraft mc = Minecraft.func_71410_x();
        TickEvent.Phase phase = event.phase;
        TickEvent.Type type = event.type;
        if (phase == TickEvent.Phase.END && type.equals((Object)TickEvent.Type.CLIENT)) {
            if (!AetherConfig.triviaDisabled() && !(mc.field_71461_s instanceof AetherLoadingScreen)) {
                mc.field_71461_s = new AetherLoadingScreen(mc);
            }
            if (mc.field_71439_g != null && !(mc.field_71439_g.field_71158_b instanceof AetherMovementInput)) {
                mc.field_71439_g.field_71158_b = new AetherMovementInput(mc, mc.field_71474_y);
            }
        }
        if (phase == TickEvent.Phase.START && type.equals((Object)TickEvent.Type.CLIENT) && (mc.field_71462_r == null || mc.field_71462_r.field_146291_p) && !mc.field_71439_g.func_71039_bw() && GameSettings.func_100015_a((KeyBinding)mc.field_71474_y.field_74322_I)) {
            this.sendPickupPacket(mc);
        }
    }

    private void sendPickupPacket(Minecraft mc) {
        if (mc.field_71476_x != null) {
            if (!this.onPickEntity(mc.field_71476_x, (EntityPlayer)mc.field_71439_g, (World)mc.field_71441_e)) {
                return;
            }
            if (mc.field_71439_g.field_71075_bZ.field_75098_d) {
                int index = mc.field_71439_g.field_71069_bz.field_75151_b.size() - 9 + mc.field_71439_g.field_71071_by.field_70461_c;
                mc.field_71442_b.func_78761_a(mc.field_71439_g.field_71071_by.func_70301_a(mc.field_71439_g.field_71071_by.field_70461_c), index);
            }
        }
    }

    private boolean onPickEntity(MovingObjectPosition target, EntityPlayer player, World world) {
        int id;
        ItemStack result = null;
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        if (!isCreative) {
            return false;
        }
        if (target.field_72308_g != null && (id = EntitiesAether.getEntityID(target.field_72308_g)) >= 0 && ItemAetherSpawnEgg.entityEggs.containsKey(id)) {
            result = new ItemStack(ItemsAether.aether_spawn_egg, 1, id);
        }
        if (result == null) {
            return false;
        }
        for (int x = 0; x < 9; ++x) {
            ItemStack stack = player.field_71071_by.func_70301_a(x);
            if (stack == null || !stack.func_77969_a(result) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)result)) continue;
            player.field_71071_by.field_70461_c = x;
            return true;
        }
        int slot = player.field_71071_by.func_70447_i();
        if (slot < 0 || slot >= 9) {
            slot = player.field_71071_by.field_70461_c;
        }
        player.field_71071_by.func_70299_a(slot, result);
        player.field_71071_by.field_70461_c = slot;
        return true;
    }

    @SubscribeEvent
    public void onBowPulled(FOVUpdateEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player != null && player.func_71045_bC() == null) {
            return;
        }
        Item item = player.func_71045_bC().func_77973_b();
        if (item == ItemsAether.phoenix_bow) {
            int i = player.func_71057_bx();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            float original = event.fov;
            event.newfov = original *= 1.0f - f1 * 0.15f;
        }
    }

    @SubscribeEvent
    public void onGuiOpened(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.gui instanceof GuiContainer) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            Class<?> clazz = event.gui.getClass();
            int guiLeft = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((GuiContainer)event.gui), (String[])new String[]{"guiLeft", "field_147003_i"});
            int guiTop = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((GuiContainer)event.gui), (String[])new String[]{"guiTop", "field_147009_r"});
            if (player.field_71075_bZ.field_75098_d) {
                if (event.gui instanceof GuiContainerCreative && ((GuiContainerCreative)event.gui).func_147056_g() == CreativeTabs.field_78036_m.func_78021_a()) {
                    event.buttonList.add(ACCESSORY_BUTTON.setPosition(guiLeft + 28, guiTop + 38));
                    previousSelectedTabIndex = CreativeTabs.field_78036_m.func_78021_a();
                }
            } else if (clazz == GuiInventory.class) {
                event.buttonList.add(ACCESSORY_BUTTON.setPosition(guiLeft + 26, guiTop + 65));
            }
        }
    }

    @SubscribeEvent
    public void onMouseClicked(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiContainerCreative guiScreen;
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiContainerCreative && previousSelectedTabIndex != (guiScreen = (GuiContainerCreative)Minecraft.func_71410_x().field_71462_r).func_147056_g()) {
            List buttonList = (List)ObfuscationReflectionHelper.getPrivateValue(GuiScreen.class, (Object)guiScreen, (int)4);
            if (guiScreen.func_147056_g() == CreativeTabs.field_78036_m.func_78021_a() && !buttonList.contains((Object)ACCESSORY_BUTTON)) {
                int guiLeft = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)guiScreen, (String[])new String[]{"guiLeft", "field_147003_i"});
                int guiTop = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)guiScreen, (String[])new String[]{"guiTop", "field_147009_r"});
                buttonList.add(ACCESSORY_BUTTON.setPosition(guiLeft + 28, guiTop + 38));
            } else if (previousSelectedTabIndex == CreativeTabs.field_78036_m.func_78021_a()) {
                buttonList.remove((Object)ACCESSORY_BUTTON);
            }
            previousSelectedTabIndex = guiScreen.func_147056_g();
        }
    }

    @SubscribeEvent
    public void onButtonPressed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        Class<?> clazz = event.gui.getClass();
        if ((clazz == GuiInventory.class || clazz == GuiContainerCreative.class) && event.button.field_146127_k == 18067) {
            AetherNetwork.sendToServer(new PacketOpenContainer(1));
        }
    }

    @SubscribeEvent
    public void onRenderInvisibility(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.entityPlayer;
        PlayerAether playerAether = PlayerAether.get(player);
        if (playerAether != null && playerAether.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.invisibility_cape))) {
            event.setCanceled(true);
        }
        PlayerAetherRenderer.instance().setPartialTicks(event.partialRenderTick);
    }

    @SubscribeEvent
    public void onRenderAetherCape(RenderPlayerEvent.Specials.Pre event) {
        event.renderCape = !PlayerAetherRenderer.instance().isCapeRendering();
    }

    @SubscribeEvent
    public void onRenderAetherArmor(RenderPlayerEvent.SetArmorModel event) {
        if (event.stack != null && event.stack.func_77973_b() instanceof ItemAetherArmor) {
            event.result = PlayerAetherRenderer.instance().renderAetherArmor(PlayerAether.get(event.entityPlayer), event.renderer, event.stack, 3 - event.slot);
        }
    }

    @SubscribeEvent
    public void onRenderAccessories(RenderLivingEvent.Post event) {
        if (event.entity instanceof EntityPlayer) {
            PlayerAether playerAether = PlayerAether.get((EntityPlayer)event.entity);
            PlayerAetherRenderer.instance().renderAccessories(playerAether, (RenderPlayer)event.renderer, event.x, event.y, event.z, PlayerAetherRenderer.instance().getPartialTicks());
        }
    }
}

