/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.client.audio.music;

import com.legacy.aether.Aether;
import com.legacy.aether.AetherConfig;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class AetherMusicTicker
implements IUpdatePlayerListBox {
    private final Random rand = new Random();
    private final Minecraft mc;
    private ISound currentMusic;
    private int timeUntilNextMusic = 100;

    public AetherMusicTicker(Minecraft mcIn) {
        this.mc = mcIn;
    }

    public void func_73660_a() {
        TrackType tracktype = this.getRandomTrack();
        if (this.mc.field_71439_g != null) {
            if (this.mc.field_71474_y.func_151438_a(SoundCategory.MUSIC) == 0.0f) {
                if (this.currentMusic != null) {
                    this.stopMusic();
                    this.currentMusic = null;
                }
                return;
            }
            if (this.mc.field_71439_g.field_71093_bK != AetherConfig.getAetherDimensionID()) {
                this.stopMusic();
            } else if (this.mc.field_71439_g.field_71093_bK == AetherConfig.getAetherDimensionID()) {
                if (this.currentMusic != null && !this.mc.func_147118_V().func_147692_c(this.currentMusic)) {
                    this.currentMusic = null;
                    this.timeUntilNextMusic = Math.min(MathHelper.func_76136_a((Random)this.rand, (int)tracktype.getMinDelay(), (int)tracktype.getMaxDelay()), this.timeUntilNextMusic);
                }
                this.timeUntilNextMusic = Math.min(this.timeUntilNextMusic, tracktype.getMaxDelay());
                if (this.currentMusic == null && this.timeUntilNextMusic-- <= 0) {
                    this.playMusic(tracktype);
                }
            }
        }
    }

    public boolean playingMusic() {
        return this.currentMusic != null;
    }

    public TrackType getRandomTrack() {
        int num = this.rand.nextInt(4);
        return num == 0 ? TrackType.TRACK_ONE : (num == 1 ? TrackType.TRACK_TWO : (num == 2 ? TrackType.TRACK_THREE : TrackType.TRACK_FOUR));
    }

    public void playMusic(TrackType requestedMusicType) {
        this.currentMusic = PositionedSoundRecord.func_147673_a((ResourceLocation)requestedMusicType.getMusicLocation());
        this.mc.func_147118_V().func_147682_a(this.currentMusic);
        this.timeUntilNextMusic = Integer.MAX_VALUE;
    }

    public void stopMusic() {
        if (this.currentMusic != null) {
            this.mc.func_147118_V().func_147683_b(this.currentMusic);
            this.currentMusic = null;
            this.timeUntilNextMusic = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum TrackType {
        TRACK_ONE(Aether.locate("music.aether1"), 1200, 1500),
        TRACK_TWO(Aether.locate("music.aether2"), 1200, 1500),
        TRACK_THREE(Aether.locate("music.aether3"), 1200, 1500),
        TRACK_FOUR(Aether.locate("music.aether4"), 1200, 1500);

        private final ResourceLocation musicLocation;
        private final int minDelay;
        private final int maxDelay;

        private TrackType(ResourceLocation musicLocationIn, int minDelayIn, int maxDelayIn) {
            this.musicLocation = musicLocationIn;
            this.minDelay = minDelayIn;
            this.maxDelay = maxDelayIn;
        }

        public ResourceLocation getMusicLocation() {
            return this.musicLocation;
        }

        public int getMinDelay() {
            return this.minDelay;
        }

        public int getMaxDelay() {
            return this.maxDelay;
        }
    }
}

