/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.client.gui.dialogue.entity;

import com.legacy.aether.client.gui.dialogue.DialogueOption;
import com.legacy.aether.client.gui.dialogue.GuiDialogue;
import com.legacy.aether.entities.bosses.valkyrie_queen.EntityValkyrieQueen;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.network.AetherNetwork;
import com.legacy.aether.network.packets.PacketInitiateValkyrieFight;
import net.minecraft.item.ItemStack;
import net.minecraft.world.EnumDifficulty;

public class GuiValkyrieDialogue
extends GuiDialogue {
    private EntityValkyrieQueen valkyrieQueen;
    private String title = this.getDialogue();
    private int medalSlotId = -1;

    public GuiValkyrieDialogue(EntityValkyrieQueen valkyrieQueen) {
        super("[\u00a7e" + valkyrieQueen.getName() + ", the Valkyrie Queen\u00a7r]", new DialogueOption("What can you tell me about this place?"), new DialogueOption("I wish to fight you!"), new DialogueOption("Nevermind"));
        this.valkyrieQueen = valkyrieQueen;
    }

    @Override
    public void dialogueClicked(DialogueOption dialogue) {
        if (this.getDialogueOptions().size() == 3) {
            if (dialogue.getDialogueId() == 0) {
                this.addDialogueMessage(this.title + ": This is a sanctuary for us Valkyries who seek rest.");
                this.dialogueTreeCompleted();
            } else if (dialogue.getDialogueId() == 1) {
                DialogueOption medalDialogue = new DialogueOption(this.getMedalDiaulogue());
                this.addDialogueWithOptions(this.title + ": Very well then. Bring me ten medals from my subordinates to prove your worth, then we'll see.", medalDialogue, new DialogueOption("On second thought, i'd rather not."));
            } else if (dialogue.getDialogueId() == 2) {
                this.addDialogueMessage(this.title + ": Goodbye adventurer.");
                this.dialogueTreeCompleted();
            }
        } else if (dialogue.getDialogueId() == 0) {
            if (this.field_146297_k.field_71441_e.field_73013_u == EnumDifficulty.PEACEFUL) {
                this.addDialogueMessage(this.title + ": Sorry, I don't fight with weaklings.");
                this.dialogueTreeCompleted();
                return;
            }
            if (this.medalSlotId != -1) {
                AetherNetwork.sendToServer(new PacketInitiateValkyrieFight(this.medalSlotId, this.valkyrieQueen.func_145782_y()));
                this.valkyrieQueen.setBossReady(true);
                this.addDialogueMessage(this.title + ": Now then, let's begin!");
                this.dialogueTreeCompleted();
            } else {
                this.addDialogueMessage(this.title + ": Take your time.");
                this.dialogueTreeCompleted();
            }
        } else if (dialogue.getDialogueId() == 1) {
            this.addDialogueMessage(this.title + ": So be it then. Goodbye adventurer.");
            this.dialogueTreeCompleted();
        }
    }

    private String getMedalDiaulogue() {
        for (int slotId = 0; slotId < this.field_146297_k.field_71439_g.field_71071_by.field_70462_a.length; ++slotId) {
            ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.field_70462_a[slotId];
            if (stack == null || stack.func_77973_b() != ItemsAether.victory_medal) continue;
            if (stack.field_77994_a >= 10) {
                this.medalSlotId = slotId;
                return "I'm ready, I have the medals right here!";
            }
            return "I'll return when I have them. (" + stack.field_77994_a + "/10)";
        }
        return "I'll return when I have them. (0/10)";
    }
}

