/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.client.renders.entity;

import com.legacy.aether.Aether;
import com.legacy.aether.api.accessories.AccessoryType;
import com.legacy.aether.client.models.attachments.ModelAetherWings;
import com.legacy.aether.client.models.attachments.ModelHalo;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.items.accessories.ItemAccessory;
import com.legacy.aether.items.armor.ItemAetherArmor;
import com.legacy.aether.player.PlayerAether;
import com.legacy.aether.player.perks.AetherRankings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public class PlayerAetherRenderer {
    private static final ResourceLocation TEXTURE_VALKYRIE = Aether.locate("textures/entities/valkyrie/valkyrie.png");
    private static final ResourceLocation TEXTURE_HALO = Aether.locate("textures/other/halo.png");
    private Minecraft mc = Minecraft.func_71410_x();
    private ModelHalo modelHalo = new ModelHalo();
    public ModelBiped modelMisc;
    public ModelBiped modelGlow = new ModelBiped(0.005f);
    private ModelAetherWings modelWings;
    private float partialTicks;
    private boolean isCapeRendering;
    private static final PlayerAetherRenderer instance = new PlayerAetherRenderer();

    public PlayerAetherRenderer() {
        this.modelMisc = new ModelBiped(1.0f);
        this.modelWings = new ModelAetherWings(1.0f);
    }

    public int renderAetherArmor(PlayerAether playerAether, RenderPlayer renderPlayer, ItemStack stack, int slotType) {
        Item item;
        if (stack != null && (item = stack.func_77973_b()) instanceof ItemAetherArmor) {
            ItemAetherArmor itemarmor = (ItemAetherArmor)item;
            this.mc.func_110434_K().func_110577_a(RenderBiped.getArmorResource((Entity)playerAether.getEntity(), (ItemStack)stack, (int)slotType, null));
            ModelBiped modelbiped = slotType == 2 ? renderPlayer.field_77111_i : renderPlayer.field_77108_b;
            modelbiped.field_78116_c.field_78806_j = slotType == 0;
            modelbiped.field_78114_d.field_78806_j = slotType == 0;
            modelbiped.field_78115_e.field_78806_j = slotType == 1 || slotType == 2;
            modelbiped.field_78112_f.field_78806_j = slotType == 1;
            modelbiped.field_78113_g.field_78806_j = slotType == 1;
            modelbiped.field_78123_h.field_78806_j = slotType == 2 || slotType == 3;
            modelbiped.field_78124_i.field_78806_j = slotType == 2 || slotType == 3;
            modelbiped = ForgeHooksClient.getArmorModel((EntityLivingBase)playerAether.getEntity(), (ItemStack)stack, (int)slotType, (ModelBiped)modelbiped);
            renderPlayer.func_77042_a((ModelBase)modelbiped);
            modelbiped.field_78095_p = renderPlayer.field_77109_a.field_78095_p;
            modelbiped.field_78093_q = renderPlayer.field_77109_a.field_78093_q;
            modelbiped.field_78091_s = renderPlayer.field_77109_a.field_78091_s;
            int j = itemarmor.func_82790_a(stack, 0);
            if (j != -1) {
                float f1 = (float)(j >> 16 & 0xFF) / 255.0f;
                float f2 = (float)(j >> 8 & 0xFF) / 255.0f;
                float f3 = (float)(j & 0xFF) / 255.0f;
                GL11.glColor3f((float)f1, (float)f2, (float)f3);
            }
            if (stack.func_77948_v()) {
                return 15;
            }
            return 1;
        }
        return -1;
    }

    public void renderAccessories(PlayerAether playerAether, RenderPlayer renderer, double x, double y, double z, float partialTicks) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack itemstack = playerAether.getEntity().func_71045_bC();
        this.modelGlow.field_78120_m = itemstack != null ? 1 : 0;
        this.modelWings.field_78120_m = this.modelGlow.field_78120_m;
        this.modelMisc.field_78120_m = this.modelGlow.field_78120_m;
        if (itemstack != null && playerAether.getEntity().func_71052_bv() > 0) {
            EnumAction enumaction = itemstack.func_77975_n();
            if (enumaction == EnumAction.block) {
                this.modelGlow.field_78120_m = 3;
                this.modelWings.field_78120_m = 3;
                this.modelMisc.field_78120_m = 3;
            } else if (enumaction == EnumAction.bow) {
                this.modelGlow.field_78118_o = true;
                this.modelWings.field_78118_o = true;
                this.modelMisc.field_78118_o = true;
            }
        }
        this.modelMisc.field_78117_n = this.modelWings.field_78117_n = (this.modelWings.field_78117_n = playerAether.getEntity().func_70093_af());
        this.doRender(playerAether, x, y, z, partialTicks);
        this.modelGlow.field_78118_o = false;
        this.modelWings.field_78118_o = false;
        this.modelMisc.field_78118_o = false;
        this.modelGlow.field_78117_n = false;
        this.modelWings.field_78117_n = false;
        this.modelMisc.field_78117_n = false;
        this.modelGlow.field_78120_m = 0;
        this.modelWings.field_78120_m = 0;
        this.modelMisc.field_78120_m = 0;
    }

    private void doRender(PlayerAether playerAether, double x, double y, double z, float partialTicks) {
        float f4;
        EntityPlayer player = playerAether.getEntity();
        this.modelWings.field_78095_p = this.modelGlow.field_78095_p = playerAether.getEntity().func_70678_g(partialTicks);
        this.modelMisc.field_78095_p = this.modelGlow.field_78095_p;
        this.modelWings.field_78093_q = this.modelGlow.field_78093_q = playerAether.getEntity().func_70115_ae();
        this.modelMisc.field_78093_q = this.modelGlow.field_78093_q;
        this.modelWings.field_78091_s = this.modelGlow.field_78091_s = playerAether.getEntity().func_70631_g_();
        this.modelMisc.field_78091_s = this.modelGlow.field_78091_s;
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        float f2 = this.interpolateRotation(player.field_70760_ar, player.field_70761_aq, partialTicks);
        float f3 = this.interpolateRotation(player.field_70758_at, player.field_70759_as, partialTicks);
        if (player.func_70115_ae() && player.field_70154_o instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase1 = (EntityLivingBase)player.field_70154_o;
            f2 = this.interpolateRotation(entitylivingbase1.field_70760_ar, entitylivingbase1.field_70761_aq, partialTicks);
            f4 = MathHelper.func_76142_g((float)(f3 - f2));
            if (f4 < -85.0f) {
                f4 = -85.0f;
            }
            if (f4 >= 85.0f) {
                f4 = 85.0f;
            }
            f2 = f3 - f4;
            if (f4 * f4 > 2500.0f) {
                f2 += f4 * 0.2f;
            }
        }
        float f13 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
        this.renderLivingAt((EntityLivingBase)player, x, y, z);
        f4 = this.handleRotationFloat((EntityLivingBase)player, partialTicks);
        this.rotateCorpse((EntityLivingBase)player, f4, f2, partialTicks);
        float f5 = 0.0625f;
        GL11.glEnable((int)32826);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.preRenderCallback((EntityLivingBase)player, partialTicks);
        GL11.glTranslatef((float)0.0f, (float)(-24.0f * f5 - 0.0078125f), (float)0.0f);
        float f6 = player.field_70722_aY + (player.field_70721_aZ - player.field_70722_aY) * partialTicks;
        float f7 = player.field_70754_ba - player.field_70721_aZ * (1.0f - partialTicks);
        if (player.func_70631_g_()) {
            f7 *= 3.0f;
        }
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        GL11.glEnable((int)3008);
        this.modelMisc.func_78086_a((EntityLivingBase)player, f7, f6, partialTicks);
        this.modelWings.func_78086_a((EntityLivingBase)player, f7, f6, partialTicks);
        this.modelHalo.func_78086_a((EntityLivingBase)player, f7, f6, partialTicks);
        this.modelGlow.func_78086_a((EntityLivingBase)player, f7, f6, partialTicks);
        this.renderModel(playerAether, f7, f6, f4, f3 - f2, f13, f5, partialTicks);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    private void renderModel(PlayerAether playerAether, float limbSwing, float prevLimbSwing, float rotation, float interpolateRotation, float prevRotationPitch, float scale, float partialTicks) {
        float blue;
        float green;
        float red;
        int colour;
        EntityPlayer player = playerAether.getEntity();
        GL11.glPushMatrix();
        this.setCapeRendering(playerAether.getAccessoryInventory().getStackInSlot(AccessoryType.CAPE) != null);
        this.modelMisc.func_78087_a(limbSwing, prevLimbSwing, rotation, interpolateRotation, prevRotationPitch, scale, (Entity)player);
        this.modelWings.func_78087_a(limbSwing, prevLimbSwing, rotation, interpolateRotation, prevRotationPitch, scale, (Entity)player);
        this.modelHalo.func_78087_a(limbSwing, prevLimbSwing, rotation, interpolateRotation, prevRotationPitch, scale, (Entity)player);
        this.modelGlow.func_78087_a(limbSwing, prevLimbSwing, rotation, interpolateRotation, prevRotationPitch, scale, (Entity)player);
        if (playerAether.getAccessoryInventory().getStackInSlot(AccessoryType.PENDANT) != null) {
            ItemAccessory pendant = (ItemAccessory)playerAether.getAccessoryInventory().getStackInSlot(AccessoryType.PENDANT).func_77973_b();
            this.mc.func_110434_K().func_110577_a(pendant.texture);
            colour = pendant.func_82790_a(new ItemStack((Item)pendant, 1, 0), 1);
            red = (float)(colour >> 16 & 0xFF) / 255.0f;
            green = (float)(colour >> 8 & 0xFF) / 255.0f;
            blue = (float)(colour & 0xFF) / 255.0f;
            if (player.field_70737_aN > 0) {
                GL11.glColor3f((float)1.0f, (float)0.5f, (float)0.5f);
            } else {
                GL11.glColor3f((float)red, (float)green, (float)blue);
            }
            this.modelMisc.field_78115_e.func_78785_a(scale);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glScalef((float)0.9375f, (float)0.9375f, (float)0.9375f);
        if (playerAether.getAccessoryInventory().getStackInSlot(AccessoryType.CAPE) != null && !playerAether.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.invisibility_cape))) {
            ItemAccessory cape = (ItemAccessory)playerAether.getAccessoryInventory().getStackInSlot(AccessoryType.CAPE).func_77973_b();
            if (!player.func_82150_aj() && !player.func_82238_cc()) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
                double d0 = player.field_71091_bM + (player.field_71094_bP - player.field_71091_bM) * (double)partialTicks - (player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks);
                double d1 = player.field_71096_bN + (player.field_71095_bQ - player.field_71096_bN) * (double)partialTicks - (player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks);
                double d2 = player.field_71097_bO + (player.field_71085_bR - player.field_71097_bO) * (double)partialTicks - (player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks);
                float f = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks;
                double d3 = MathHelper.func_76126_a((float)(f * (float)Math.PI / 180.0f));
                double d4 = -MathHelper.func_76134_b((float)(f * (float)Math.PI / 180.0f));
                float f1 = (float)d1 * 10.0f;
                f1 = MathHelper.func_76131_a((float)f1, (float)-6.0f, (float)32.0f);
                float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                float f4 = player.field_71107_bF + (player.field_71109_bG - player.field_71107_bF) * partialTicks;
                f1 += MathHelper.func_76126_a((float)((player.field_70141_P + (player.field_70140_Q - player.field_70141_P) * partialTicks) * 6.0f)) * 32.0f * f4;
                if (player.func_70093_af()) {
                    f1 += 25.0f;
                }
                GL11.glRotatef((float)(6.0f + f2 / 2.0f + f1), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(f3 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(-f3 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                int colour2 = cape.func_82790_a(playerAether.getAccessoryInventory().getStackInSlot(AccessoryType.CAPE), 0);
                float red2 = (float)(colour2 >> 16 & 0xFF) / 255.0f;
                float green2 = (float)(colour2 >> 8 & 0xFF) / 255.0f;
                float blue2 = (float)(colour2 & 0xFF) / 255.0f;
                if (player.field_70737_aN > 0) {
                    GL11.glColor3f((float)1.0f, (float)0.5f, (float)0.5f);
                } else {
                    GL11.glColor3f((float)red2, (float)green2, (float)blue2);
                }
                if (player.func_110124_au().toString().equals("47ec3a3b-3f41-49b6-b5a0-c39abb7b51ef")) {
                    this.mc.func_110434_K().func_110577_a(Aether.locate("textures/armor/accessory_swuff.png"));
                } else {
                    this.mc.func_110434_K().func_110577_a(cape.texture);
                }
                this.modelMisc.func_78111_c(scale);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
        if (playerAether.getAccessoryInventory().getStackInSlot(AccessoryType.GLOVES) != null) {
            ItemAccessory gloves = (ItemAccessory)playerAether.getAccessoryInventory().getStackInSlot(AccessoryType.GLOVES).func_77973_b();
            this.mc.func_110434_K().func_110577_a(gloves.texture);
            colour = gloves.func_82790_a(playerAether.getAccessoryInventory().getStackInSlot(AccessoryType.GLOVES), 0);
            red = (float)(colour >> 16 & 0xFF) / 255.0f;
            green = (float)(colour >> 8 & 0xFF) / 255.0f;
            blue = (float)(colour & 0xFF) / 255.0f;
            if (player.field_70737_aN > 0) {
                GL11.glColor3f((float)1.0f, (float)0.5f, (float)0.5f);
            } else if (gloves != ItemsAether.phoenix_gloves) {
                GL11.glColor3f((float)red, (float)green, (float)blue);
            }
            this.modelMisc.field_78113_g.func_78785_a(scale);
            this.modelMisc.field_78112_f.func_78785_a(scale);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (playerAether.getAccessoryInventory().getStackInSlot(AccessoryType.SHIELD) != null) {
            ItemAccessory shield = (ItemAccessory)playerAether.getAccessoryInventory().getStackInSlot(AccessoryType.SHIELD).func_77973_b();
            this.mc.func_110434_K().func_110577_a(shield.texture);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
            if (player.field_70172_ad > 0) {
                GL11.glColor4f((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.modelGlow.func_78088_a((Entity)player, limbSwing, prevLimbSwing, rotation, interpolateRotation, prevRotationPitch, scale);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
        if (playerAether.getAccessoryInventory().isWearingValkyrieSet()) {
            this.mc.func_110434_K().func_110577_a(TEXTURE_VALKYRIE);
            this.modelWings.setWingSinage(playerAether.wingSinage);
            this.modelWings.wingLeft.func_78785_a(scale);
            this.modelWings.wingRight.func_78785_a(scale);
            if (player.field_70172_ad > 0) {
                GL11.glColor3f((float)1.0f, (float)0.5f, (float)0.5f);
            } else {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (AetherRankings.isRankedPlayer(player.func_110124_au()) && PlayerAether.get((EntityPlayer)player).shouldRenderHalo) {
            float f9 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * partialTicks - (player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks);
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)f9, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)prevRotationPitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.65f, (float)0.0f);
            GL11.glRotatef((float)(-prevRotationPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-f9), (float)0.0f, (float)1.0f, (float)0.0f);
            this.mc.func_110434_K().func_110577_a(TEXTURE_HALO);
            this.modelHalo.renderHalo(scale);
            GL11.glPopMatrix();
        }
        if (player.func_110124_au().toString().equals("cf51ef47-04a8-439a-aa41-47d871b0b837")) {
            this.mc.func_110434_K().func_110577_a(((AbstractClientPlayer)player).func_110306_p());
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glEnable((int)2977);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBlendFunc((int)1, (int)1);
            this.modelGlow.func_78088_a((Entity)player, limbSwing, prevLimbSwing, rotation, interpolateRotation, prevRotationPitch, scale);
            GL11.glDisable((int)2977);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void preRenderCallback(EntityLivingBase entity, float partialTicks) {
        float f1 = 0.9375f;
        GL11.glScalef((float)f1, (float)f1, (float)f1);
    }

    protected float getDeathMaxRotation(EntityLivingBase entity) {
        return 90.0f;
    }

    private float handleRotationFloat(EntityLivingBase entity, float partialTicks) {
        return (float)entity.field_70173_aa + partialTicks;
    }

    private void renderLivingAt(EntityLivingBase entity, double x, double y, double z) {
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
    }

    protected void rotateCorpse(EntityLivingBase entity, float p_77043_2_, float p_77043_3_, float partialTicks) {
        GL11.glRotatef((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entity.field_70725_aQ > 0) {
            float f3 = ((float)entity.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f3 = MathHelper.func_76129_c((float)f3)) > 1.0f) {
                f3 = 1.0f;
            }
            GL11.glRotatef((float)(f3 * this.getDeathMaxRotation(entity)), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            String s = EnumChatFormatting.func_110646_a((String)entity.func_70005_c_());
            if (!(!s.equals("Dinnerbone") && !s.equals("Grumm") || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_82238_cc())) {
                GL11.glTranslatef((float)0.0f, (float)(entity.field_70131_O + 0.1f), (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    private float interpolateRotation(float p_77034_1_, float p_77034_2_, float p_77034_3_) {
        float f3;
        for (f3 = p_77034_2_ - p_77034_1_; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return p_77034_1_ + p_77034_3_ * f3;
    }

    public void setPartialTicks(float partialTicks) {
        this.partialTicks = partialTicks;
    }

    public float getPartialTicks() {
        return this.partialTicks;
    }

    private void setCapeRendering(boolean isRendering) {
        this.isCapeRendering = isRendering;
    }

    public boolean isCapeRendering() {
        return this.isCapeRendering;
    }

    public static PlayerAetherRenderer instance() {
        return instance;
    }
}

