/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.entities.hostile;

import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.entities.particles.AetherParticle;
import com.legacy.aether.entities.particles.ParticleEvilWhirly;
import com.legacy.aether.entities.particles.ParticlePassiveWhirly;
import com.legacy.aether.player.perks.AetherRankings;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityWhirlwind
extends EntityMob {
    public ArrayList<Object> particles = new ArrayList();
    public int lifeLeft;
    public int actionTimer;
    public float movementAngle;
    public float movementCurve;
    public boolean isRainbow;
    public boolean canDropItems = true;

    public EntityWhirlwind(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.8f);
        this.movementAngle = this.field_70146_Z.nextFloat() * 360.0f;
        this.movementCurve = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f;
        this.lifeLeft = this.field_70146_Z.nextInt(512) + 512;
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.lifeLeft /= 2;
            this.setEvil(true);
        }
        this.setColorData(15);
    }

    public float func_70783_a(int x, int y, int z) {
        return this.field_70170_p.func_147439_a(x, y - 1, z) == BlocksAether.aether_grass ? 10.0f : this.field_70170_p.func_72801_o(x, y, z) - 0.5f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.field_70146_Z.nextDouble() * 0.025 + 0.025);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_70606_j(10.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(21, (Object)new Byte(15));
    }

    public void setColorData(int data) {
        this.field_70180_af.func_75692_b(21, (Object)((byte)data));
    }

    public int getColorData() {
        return this.field_70180_af.func_75683_a(21);
    }

    public void setEvil(boolean isEvil) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)(isEvil ? 1 : 0)));
    }

    public boolean isEvil() {
        return this.field_70180_af.func_75683_a(20) == 1;
    }

    public void func_70636_d() {
        EntityPlayer closestPlayer = this.findClosestPlayer();
        if (this.isEvil() && closestPlayer != null && closestPlayer.field_70122_E) {
            this.func_70624_b((EntityLivingBase)closestPlayer);
        }
        if (this.func_70638_az() == null) {
            this.field_70159_w = Math.cos(0.01745329f * this.movementAngle) * this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            this.field_70179_y = -Math.sin(0.01745329f * this.movementAngle) * this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            this.movementAngle += this.movementCurve;
        } else {
            super.func_70636_d();
        }
        if (this.lifeLeft != -100) {
            --this.lifeLeft;
        }
        if (this.lifeLeft <= 0 && this.lifeLeft != -100 || this.func_70072_I()) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (closestPlayer != null) {
                ++this.actionTimer;
            }
            if (this.actionTimer >= 128) {
                if (this.isEvil()) {
                    EntityCreeper entitycreeper = new EntityCreeper(this.field_70170_p);
                    entitycreeper.func_70012_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                    entitycreeper.field_70159_w = (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.125;
                    entitycreeper.field_70179_y = (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.125;
                    this.field_70170_p.func_72838_d((Entity)entitycreeper);
                    this.actionTimer = 0;
                    this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.5f, 1.0f);
                } else if (this.canDropItems && this.field_70146_Z.nextInt(4) == 0) {
                    this.func_145779_a(this.getRandomDrop(), 1);
                    this.actionTimer = 0;
                    this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.5f, 1.0f);
                }
            }
        } else {
            this.updateParticles();
        }
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(2.5, 2.5, 2.5));
        for (int l = 0; l < list.size(); ++l) {
            int k2;
            int j2;
            int i2;
            double d17;
            Entity entity = (Entity)list.get(l);
            double d9 = (float)entity.field_70165_t;
            double d11 = (double)((float)entity.field_70163_u) - entity.func_70033_W() * (double)0.6f;
            double d13 = (float)entity.field_70161_v;
            double d15 = this.func_70032_d(entity);
            if (d15 <= 1.5 + (d17 = d11 - this.field_70163_u)) {
                entity.field_70181_x = 0.15f;
                entity.field_70143_R = 0.0f;
                if (d17 > 1.5) {
                    entity.field_70181_x = (double)-0.45f + d17 * (double)0.35f;
                    d15 += d17 * 1.5;
                } else {
                    entity.field_70181_x = 0.125;
                }
                double d19 = Math.atan2(this.field_70165_t - d9, this.field_70161_v - d13) / 0.01745329424738884;
                entity.field_70159_w = -Math.cos(0.01745329424738884 * (d19 += 160.0)) * (d15 + 0.25) * (double)0.1f;
                entity.field_70179_y = Math.sin(0.01745329424738884 * d19) * (d15 + 0.25) * (double)0.1f;
                if (entity instanceof EntityWhirlwind) {
                    entity.func_70106_y();
                    if (!this.isEvil()) {
                        this.lifeLeft /= 2;
                        this.setEvil(true);
                        this.func_85030_a("random.fizz", this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat() * 0.2f + 1.2f, 1.0f);
                    }
                }
            } else {
                double d20 = Math.atan2(this.field_70165_t - d9, this.field_70161_v - d13) / 0.01745329424738884;
                entity.field_70159_w += Math.sin(0.01745329424738884 * d20) * (double)0.01f;
                entity.field_70179_y += Math.cos(0.01745329424738884 * d20) * (double)0.01f;
            }
            if (!this.field_70170_p.func_147437_c((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)) {
                this.lifeLeft -= 50;
            }
            if (!this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") || !(this.field_70170_p.func_147439_a(i2 = MathHelper.func_76128_c((double)this.field_70165_t) - 1 + this.field_70146_Z.nextInt(3), j2 = MathHelper.func_76128_c((double)this.field_70163_u) + this.field_70146_Z.nextInt(5), k2 = MathHelper.func_76128_c((double)this.field_70161_v) - 1 + this.field_70146_Z.nextInt(3)) instanceof BlockLeaves)) continue;
            this.field_70170_p.func_147449_b(i2, j2, k2, Blocks.field_150350_a);
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack heldItem = player.func_71045_bC();
        if (heldItem != null && heldItem.func_77973_b() == Items.field_151100_aR && AetherRankings.isRankedPlayer(player.func_110124_au())) {
            this.setColorData(heldItem.func_77960_j());
            return true;
        }
        return super.func_70085_c(player);
    }

    public boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateParticles() {
        if (!this.isEvil()) {
            Integer color = ItemDye.field_150922_c[this.getColorData()];
            for (int k = 0; k < 2; ++k) {
                double d1 = (float)this.field_70165_t + this.field_70146_Z.nextFloat() * 0.25f;
                double d4 = (float)this.field_70163_u + this.field_70131_O + 0.125f;
                double d7 = (float)this.field_70161_v + this.field_70146_Z.nextFloat() * 0.25f;
                float f = this.field_70146_Z.nextFloat() * 360.0f;
                ParticlePassiveWhirly particle = new ParticlePassiveWhirly(this.field_70170_p, -Math.sin(0.01745329f * f) * 0.75, d4 - 0.25, Math.cos(0.01745329f * f) * 0.75, d1, 0.125, d7);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)particle);
                this.particles.add((Object)particle);
                particle.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
                if (this.isRainbow) {
                    int k1 = this.field_70173_aa / 25 + this.func_145782_y();
                    int l = k1 % EntitySheep.field_70898_d.length;
                    int i1 = (k1 + 1) % EntitySheep.field_70898_d.length;
                    float f1 = (float)(this.field_70173_aa % 25) / 25.0f;
                    particle.func_70538_b(EntitySheep.field_70898_d[l][0] * (1.0f - f1) + EntitySheep.field_70898_d[i1][0] * f1, EntitySheep.field_70898_d[l][1] * (1.0f - f1) + EntitySheep.field_70898_d[i1][1] * f1, EntitySheep.field_70898_d[l][2] * (1.0f - f1) + EntitySheep.field_70898_d[i1][2] * f1);
                }
                particle.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        } else {
            for (int k = 0; k < 3; ++k) {
                double d2 = (float)this.field_70165_t + this.field_70146_Z.nextFloat() * 0.25f;
                double d5 = (float)this.field_70163_u + this.field_70131_O + 0.125f;
                double d8 = (float)this.field_70161_v + this.field_70146_Z.nextFloat() * 0.25f;
                float f1 = this.field_70146_Z.nextFloat() * 360.0f;
                ParticleEvilWhirly particle = new ParticleEvilWhirly(this.field_70170_p, -Math.sin(0.01745329f * f1) * 0.75, d5 - 0.25, Math.cos(0.01745329f * f1) * 0.75, d2, 0.125, d8, 3.5f);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)particle);
                this.particles.add((Object)particle);
                particle.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        }
        if (this.particles.size() > 0) {
            for (int i1 = 0; i1 < this.particles.size(); ++i1) {
                AetherParticle particle = (AetherParticle)((Object)this.particles.get(i1));
                if (particle.field_70128_L) {
                    this.particles.remove((Object)particle);
                    continue;
                }
                double d10 = particle.getX();
                double d12 = particle.field_70121_D.field_72338_b;
                double d14 = particle.getZ();
                double d16 = this.func_70032_d((Entity)particle);
                double d18 = d12 - this.field_70163_u;
                particle.setMotionY(0.115f);
                double d21 = Math.atan2(this.field_70165_t - d10, this.field_70161_v - d14) / 0.01745329424738884;
                particle.setMotionX(-Math.cos(0.01745329424738884 * (d21 += 160.0)) * (d16 * 2.5 - d18) * (double)0.1f);
                particle.setMotionZ(Math.sin(0.01745329424738884 * d21) * (d16 * 2.5 - d18) * (double)0.1f);
            }
        }
    }

    public Item getRandomDrop() {
        int i = this.field_70146_Z.nextInt(100) + 1;
        if (i == 100) {
            return Items.field_151045_i;
        }
        if (i >= 96) {
            return Items.field_151042_j;
        }
        if (i >= 91) {
            return Items.field_151043_k;
        }
        if (i >= 82) {
            return Items.field_151044_h;
        }
        if (i >= 80) {
            return Item.func_150898_a((Block)Blocks.field_150423_aK);
        }
        if (i >= 75) {
            return Item.func_150898_a((Block)Blocks.field_150351_n);
        }
        if (i >= 64) {
            return Item.func_150898_a((Block)Blocks.field_150435_aG);
        }
        if (i >= 52) {
            return Items.field_151055_y;
        }
        if (i >= 38) {
            return Items.field_151145_ak;
        }
        if (i > 20) {
            return Item.func_150898_a((Block)Blocks.field_150364_r);
        }
        return Item.func_150898_a((Block)Blocks.field_150354_m);
    }

    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return this.field_70146_Z.nextInt(450) == 0 && this.field_70170_p.func_147439_a(i, j - 1, k) == BlocksAether.aether_grass && this.field_70170_p.func_72957_l(i, j, k) > 8 && this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public EntityPlayer findClosestPlayer() {
        return this.field_70170_p.func_72890_a((Entity)this, 16.0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("movementAngle", this.movementAngle);
        compound.func_74776_a("movementCurve", this.movementCurve);
        compound.func_74757_a("isRainbow", this.isRainbow);
        compound.func_74757_a("canDropItems", this.canDropItems);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.movementAngle = compound.func_74760_g("movementAngle");
        this.movementCurve = compound.func_74760_g("movementCurve");
        this.isRainbow = compound.func_74767_n("isRainbow");
        this.canDropItems = compound.func_74767_n("canDropItems");
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return false;
    }

    public void func_70108_f(Entity entity) {
    }

    public int func_70641_bl() {
        return 3;
    }

    public boolean func_70617_f_() {
        return this.field_70123_F;
    }
}

