/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.entities.passive.mountable;

import com.legacy.aether.api.AetherAPI;
import com.legacy.aether.api.moa.AetherMoaType;
import com.legacy.aether.entities.util.EntitySaddleMount;
import com.legacy.aether.items.ItemMoaEgg;
import com.legacy.aether.items.ItemsAether;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityMoa
extends EntitySaddleMount {
    public float wingRotation;
    public float destPos;
    public float prevDestPos;
    public float prevWingRotation;
    protected int ticksOffGround;
    protected int ticksUntilFlap;
    protected int secsUntilFlying;
    protected int secsUntilWalking;
    protected int secsUntilHungry;
    protected int secsUntilEgg;

    public EntityMoa(World world) {
        super(world);
        this.initAI();
        this.func_70105_a(1.0f, 2.0f);
        this.field_70138_W = 1.0f;
        this.secsUntilEgg = this.getRandomEggTime();
    }

    public EntityMoa(World world, AetherMoaType type) {
        this(world);
        this.setMoaType(type);
    }

    public void func_70091_d(double x, double y, double z) {
        if (!this.isSitting()) {
            super.func_70091_d(x, y, z);
        } else {
            super.func_70091_d(0.0, y, 0.0);
        }
    }

    public int getRandomEggTime() {
        return 775 + this.field_70146_Z.nextInt(50);
    }

    public void initAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, (double)0.3f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.25));
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        AetherMoaType moaType = AetherAPI.instance().getRandomMoaType();
        this.field_70180_af.func_75682_a(20, (Object)new Short((short)AetherAPI.instance().getMoaTypeId(moaType)));
        this.field_70180_af.func_75682_a(21, (Object)new Byte((byte)moaType.getMoaProperties().getMaxJumps()));
        this.field_70180_af.func_75682_a(22, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(23, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(24, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(25, (Object)new Byte(0));
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
    }

    public boolean isSitting() {
        return this.field_70180_af.func_75683_a(25) == 1;
    }

    public void setSitting(boolean isSitting) {
        this.field_70180_af.func_75692_b(25, (Object)((byte)(isSitting ? 1 : 0)));
    }

    public boolean isHungry() {
        return this.field_70180_af.func_75683_a(24) == 1;
    }

    public void setHungry(boolean hungry) {
        this.field_70180_af.func_75692_b(24, (Object)((byte)(hungry ? 1 : 0)));
    }

    public byte getAmountFed() {
        return this.field_70180_af.func_75683_a(23);
    }

    public void setAmountFed(int amountFed) {
        this.field_70180_af.func_75692_b(23, (Object)((byte)amountFed));
    }

    public void increaseAmountFed(int amountFed) {
        byte amount = this.getAmountFed();
        this.setAmountFed(amount + amountFed);
    }

    public boolean isPlayerGrown() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public void setPlayerGrown(boolean playerGrown) {
        this.field_70180_af.func_75692_b(22, (Object)((byte)(playerGrown ? 1 : 0)));
    }

    public int getMaxJumps() {
        return this.getMoaType().getMoaProperties().getMaxJumps();
    }

    public int getRemainingJumps() {
        return this.field_70180_af.func_75683_a(21);
    }

    public void setRemainingJumps(int jumps) {
        this.field_70180_af.func_75692_b(21, (Object)((byte)jumps));
    }

    public int getMoaTypeId() {
        return this.field_70180_af.func_75693_b(20);
    }

    public AetherMoaType getMoaType() {
        short id = this.field_70180_af.func_75693_b(20);
        return AetherAPI.instance().getMoaType(id);
    }

    public void setMoaType(AetherMoaType type) {
        this.field_70180_af.func_75692_b(20, (Object)new Short((short)AetherAPI.instance().getMoaTypeId(type)));
        this.field_70180_af.func_75692_b(21, (Object)new Byte((byte)type.getMoaProperties().getMaxJumps()));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70703_bu) {
            this.field_70181_x += (double)0.05f;
        }
        this.updateWingRotation();
        this.fall();
        if (this.secsUntilHungry > 0) {
            if (this.field_70173_aa % 20 == 0) {
                --this.secsUntilHungry;
            }
        } else if (!this.isHungry()) {
            this.setHungry(true);
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.field_70153_n == null) {
            if (this.secsUntilEgg > 0) {
                if (this.field_70173_aa % 20 == 0) {
                    --this.secsUntilEgg;
                }
            } else {
                this.func_85030_a("mob.chicken.plop", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_70099_a(ItemMoaEgg.getStackFromType(this.getMoaType()), 0.0f);
                this.secsUntilEgg = this.getRandomEggTime();
            }
        }
        this.field_70143_R = 0.0f;
    }

    public void resetHunger() {
        if (!this.field_70170_p.field_72995_K) {
            this.setHungry(false);
        }
        this.secsUntilHungry = 40 + this.field_70146_Z.nextInt(40);
    }

    public void updateWingRotation() {
        if (!this.field_70122_E) {
            if (this.ticksUntilFlap == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "mob.bat.takeoff", 0.15f, MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.7f, (float)1.0f) + MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.0f, (float)0.3f));
                this.ticksUntilFlap = 8;
            } else {
                --this.ticksUntilFlap;
            }
        }
        this.prevWingRotation = this.wingRotation;
        this.prevDestPos = this.destPos;
        this.destPos = (float)((double)this.destPos + 0.2);
        this.destPos = EntityMoa.minMax(0.01f, 1.0f, this.destPos);
        if (this.isOnGround()) {
            this.destPos = 0.0f;
        }
        this.wingRotation += 1.233f;
    }

    public static float minMax(float min, float max, float value) {
        return Math.min(max, Math.max(min, value));
    }

    @Override
    public void onMountedJump(float par1, float par2) {
        if (this.getRemainingJumps() > 0 && this.field_70181_x < 0.0) {
            if (!this.isOnGround()) {
                this.field_70181_x = 0.7;
                this.field_70170_p.func_72956_a((Entity)this, "mob.bat.takeoff", 0.15f, MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.7f, (float)1.0f) + MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.0f, (float)0.3f));
                if (!this.field_70170_p.field_72995_K) {
                    this.setRemainingJumps(this.getRemainingJumps() - 1);
                }
                this.func_70656_aK();
            } else {
                this.field_70181_x = 0.89;
            }
        }
    }

    @Override
    public float getMountedMoveSpeed() {
        return this.getMoaType().getMoaProperties().getMoaSpeed();
    }

    public void setToAdult() {
        this.func_70873_a(0);
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack stack = player.func_71045_bC();
        if (stack != null && this.isPlayerGrown() && !this.field_70170_p.field_72995_K) {
            Item currentItem = stack.func_77973_b();
            if (this.func_70631_g_() && this.isHungry() && this.getAmountFed() < 3 && currentItem == ItemsAether.aechor_petal) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                this.increaseAmountFed(1);
                if (this.getAmountFed() >= 3) {
                    this.setToAdult();
                } else {
                    this.resetHunger();
                }
            }
            if (currentItem == ItemsAether.nature_staff) {
                stack.func_77972_a(2, (EntityLivingBase)player);
                this.setSitting(!this.isSitting());
                return true;
            }
        }
        return super.func_70085_c(player);
    }

    @Override
    public boolean canSaddle() {
        return !this.func_70631_g_() && this.isPlayerGrown();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("playerGrown", this.isPlayerGrown());
        nbt.func_74768_a("remainingJumps", this.getRemainingJumps());
        nbt.func_74768_a("moaTypeId", this.getMoaTypeId());
        nbt.func_74774_a("amountFed", this.getAmountFed());
        nbt.func_74757_a("isHungry", this.isHungry());
        nbt.func_74757_a("isSitting", this.isSitting());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setPlayerGrown(nbt.func_74767_n("playerGrown"));
        this.setRemainingJumps(nbt.func_74762_e("remainingJumps"));
        this.setMoaType(AetherAPI.instance().getMoaType(nbt.func_74762_e("moaTypeId")));
        this.setAmountFed(nbt.func_74771_c("amountFed"));
        this.setHungry(nbt.func_74767_n("isHungry"));
        this.setSitting(nbt.func_74767_n("isSitting"));
    }

    protected String func_70639_aQ() {
        return "aether_legacy:aemob.moa.say";
    }

    protected String func_70621_aR() {
        return "aether_legacy:aemob.moa.say";
    }

    protected String func_70673_aS() {
        return "aether_legacy:aemob.moa.say";
    }

    @Override
    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a("mob.pig.step", 0.15f, 1.0f);
    }

    @Override
    protected void func_70628_a(boolean recentlyHit, int lootLevel) {
        super.func_70628_a(recentlyHit, lootLevel);
        this.func_145779_a(Items.field_151008_G, 3);
    }

    public void fall() {
        int z;
        int y;
        boolean blockBeneath;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        boolean bl = blockBeneath = !this.field_70170_p.func_147437_c(x, (y = MathHelper.func_76128_c((double)this.field_70163_u)) - 1, z = MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70181_x < 0.0 && !this.isRiderSneaking()) {
            this.field_70181_x *= 0.6;
        }
        if (blockBeneath) {
            this.setRemainingJumps(this.getMaxJumps());
        }
    }

    public void func_70664_aZ() {
        if (!this.isSitting() && this.field_70153_n == null) {
            super.func_70664_aZ();
        }
    }

    public double func_70042_X() {
        return 1.25;
    }

    public EntityAgeable func_90011_a(EntityAgeable matingAnimal) {
        return new EntityMoa(this.field_70170_p, this.getMoaType());
    }
}

