/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.entities.projectile.crystals;

import com.legacy.aether.api.player.util.IAetherBoss;
import com.legacy.aether.entities.bosses.EntityFireMinion;
import com.legacy.aether.entities.projectile.crystals.EnumCrystalType;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityCrystal
extends EntityFlying
implements IEntityAdditionalSpawnData {
    public float[] sinage = new float[3];
    public double smotionX;
    public double smotionY;
    public double smotionZ;
    public boolean wasHit;
    private EnumCrystalType type;

    public EntityCrystal(World world) {
        super(world);
        double base = 0.2f;
        this.smotionX = (base + (double)this.field_70146_Z.nextFloat() * 0.15) * (this.field_70146_Z.nextInt(2) == 0 ? 1.0 : -1.0);
        this.smotionY = (base + (double)this.field_70146_Z.nextFloat() * 0.15) * (this.field_70146_Z.nextInt(2) == 0 ? 1.0 : -1.0);
        this.smotionZ = (base + (double)this.field_70146_Z.nextFloat() * 0.15) * (this.field_70146_Z.nextInt(2) == 0 ? 1.0 : -1.0);
        this.field_70178_ae = true;
        this.type = EnumCrystalType.get(this.field_70146_Z.nextInt(2));
        for (int var2 = 0; var2 < this.sinage.length; ++var2) {
            this.sinage[var2] = this.field_70146_Z.nextFloat() * 6.0f;
        }
        this.func_70105_a(0.9f, 0.9f);
    }

    public EntityCrystal(World world, double x, double y, double z, EnumCrystalType type) {
        this(world);
        this.type = type;
        if (this.type == EnumCrystalType.ICE) {
            this.smotionX /= 3.0;
            this.smotionY = 0.0;
            this.smotionZ /= 3.0;
        }
        this.func_70107_b(x, y, z);
    }

    public EntityCrystal(World world, double x, double y, double z, EntityLivingBase target) {
        this(world, x, y, z, EnumCrystalType.THUNDER);
        this.func_70624_b(target);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
    }

    public void func_70071_h_() {
        int var1;
        super.func_70071_h_();
        if (this.type != EnumCrystalType.THUNDER && !this.field_70170_p.field_72995_K) {
            this.field_70159_w = this.smotionX;
            this.field_70181_x = this.smotionY;
            this.field_70179_y = this.smotionZ;
        }
        if (this.type == EnumCrystalType.THUNDER) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.func_70638_az() == null || this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
                    this.func_70106_y();
                }
                this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 10.0f);
                this.moveTowardsTarget((Entity)this.func_70638_az(), 0.02);
            }
        } else if (this.field_70132_H && !this.field_70170_p.field_72995_K) {
            if (this.wasHit()) {
                this.explode();
                this.expire();
                this.func_70106_y();
            }
            var1 = MathHelper.func_76128_c((double)this.field_70165_t);
            int var2 = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int var3 = MathHelper.func_76128_c((double)this.field_70161_v);
            if (this.smotionX > 0.0 && !this.field_70170_p.func_147437_c(var1 + 1, var2, var3)) {
                this.field_70159_w = this.smotionX = -this.smotionX;
            } else if (this.smotionX < 0.0 && !this.field_70170_p.func_147437_c(var1 - 1, var2, var3)) {
                this.field_70159_w = this.smotionX = -this.smotionX;
            }
            if (this.smotionY > 0.0 && !this.field_70170_p.func_147437_c(var1, var2 + 1, var3)) {
                this.field_70181_x = this.smotionY = -this.smotionY;
            } else if (this.smotionY < 0.0 && !this.field_70170_p.func_147437_c(var1, var2 - 1, var3)) {
                this.field_70181_x = this.smotionY = -this.smotionY;
            }
            if (this.smotionZ > 0.0 && !this.field_70170_p.func_147437_c(var1, var2, var3 + 1)) {
                this.field_70179_y = this.smotionZ = -this.smotionZ;
            } else if (this.smotionZ < 0.0 && !this.field_70170_p.func_147437_c(var1, var2, var3 - 1)) {
                this.field_70179_y = this.smotionZ = -this.smotionZ;
            }
        }
        if (this.field_70173_aa >= this.maxTicksAlive()) {
            if (this.type == EnumCrystalType.THUNDER) {
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
            this.expire();
            this.func_70106_y();
        }
        for (var1 = 0; var1 < this.sinage.length; ++var1) {
            int n = var1;
            this.sinage[n] = this.sinage[n] + (0.3f + (float)var1 * 0.13f);
            if (!(this.sinage[var1] > (float)Math.PI * 2)) continue;
            int n2 = var1;
            this.sinage[n2] = this.sinage[n2] - (float)Math.PI * 2;
        }
    }

    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
        if (entity instanceof EntityCrystal && this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
            EntityCrystal crystal = (EntityCrystal)entity;
            if (this.type != crystal.type) {
                this.explode();
                this.expire();
                this.func_70106_y();
                crystal.explode();
                crystal.expire();
                crystal.func_70106_y();
            }
        } else if (entity instanceof EntityLivingBase) {
            if (this.type == EnumCrystalType.FIRE && !(entity instanceof IAetherBoss) && !(entity instanceof EntityFireMinion)) {
                if (entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.0f)) {
                    this.explode();
                    this.expire();
                    this.func_70106_y();
                    entity.func_70015_d(100);
                }
            } else if (this.type == EnumCrystalType.ICE && this.wasHit()) {
                if (entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.0f)) {
                    this.explode();
                    this.expire();
                    this.func_70106_y();
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 10));
                }
            } else if (this.type == EnumCrystalType.CLOUD && !(entity instanceof IAetherBoss)) {
                this.explode();
                this.expire();
                this.func_70106_y();
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.0f);
            } else if (this.type == EnumCrystalType.THUNDER && entity == this.func_70638_az() && entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f)) {
                this.moveTowardsTarget(entity, -0.3);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() != null) {
            if (this.type == EnumCrystalType.THUNDER) {
                this.moveTowardsTarget(source.func_76346_g(), -0.15 - (double)damage / 8.0);
                return super.func_70097_a(source, damage);
            }
            Vec3 var3 = source.func_76346_g().func_70040_Z();
            if (var3 != null) {
                this.smotionX = var3.field_72450_a;
                this.smotionY = var3.field_72448_b;
                this.smotionZ = var3.field_72449_c;
            }
            this.wasHit = true;
            return true;
        }
        return false;
    }

    public void moveTowardsTarget(Entity target, double speed) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        double angle1 = (double)this.field_70177_z / 57.29577951308232;
        this.field_70159_w -= Math.sin(angle1) * speed;
        this.field_70179_y += Math.cos(angle1) * speed;
        double a = target.field_70163_u - 0.75;
        this.field_70181_x = a < this.field_70121_D.field_72338_b - 0.5 ? (this.field_70181_x -= speed / 2.0) : (a > this.field_70121_D.field_72338_b + 0.5 ? (this.field_70181_x += speed / 2.0) : (this.field_70181_x += (a - this.field_70121_D.field_72338_b) * (speed / 2.0)));
        if (this.field_70122_E) {
            this.field_70122_E = false;
            this.field_70181_x = 0.1f;
        }
    }

    public boolean wasHit() {
        return this.wasHit;
    }

    public int maxTicksAlive() {
        return this.type == EnumCrystalType.THUNDER ? 200 : 300;
    }

    private void expire() {
        this.field_70170_p.func_72956_a((Entity)this, this.type.getDeathSound(), 2.0f, this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat() * 0.2f + 1.2f);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ((WorldServer)this.field_70170_p).func_147487_a(this.type.getDeathParticle(), this.field_70165_t, this.field_70121_D.field_72338_b + (double)this.field_70131_O * 0.8, this.field_70161_v, 16, 0.25, 0.25, 0.25, 0.0);
    }

    private void explode() {
        this.field_70170_p.func_72956_a((Entity)this, this.type.getExplosionSound(), 2.0f, this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat() * 0.2f + 1.2f);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        double motionMultiplier = 0.5;
        if (this.type == EnumCrystalType.ICE || this.type == EnumCrystalType.CLOUD) {
            motionMultiplier *= 0.5;
        }
        ((WorldServer)this.field_70170_p).func_147487_a(this.type.getExplosionParticle(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 40, 0.0, 0.0, 0.0, motionMultiplier);
    }

    public EnumCrystalType getCrystalType() {
        return this.type;
    }

    public IChatComponent func_145748_c_() {
        return new ChatComponentText(this.func_70005_c_() + this.type.toString().toLowerCase());
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.type.getId());
        if (this.type == EnumCrystalType.THUNDER) {
            buffer.writeInt(this.func_70638_az().func_145782_y());
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        this.type = EnumCrystalType.get(buffer.readInt());
        if (this.type == EnumCrystalType.THUNDER) {
            this.func_70624_b((EntityLivingBase)this.field_70170_p.func_73045_a(buffer.readInt()));
        }
    }
}

